(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    528104,      11081]
NotebookOptionsPosition[    510795,      10842]
NotebookOutlinePosition[    511189,      10858]
CellTagsIndexPosition[    511146,      10855]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"<<", "VilTeX`"}]], "Input",
 CellChangeTimes->{{3.966968271457609*^9, 3.9669682779533978`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"2521efcf-6906-4eba-ab97-75ec86b9ce05"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     StyleBox["\<\"\|01f680 VilTeX cargado\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontSize->16,
      FontWeight->Bold,
      FontColor->RGBColor[0, 0, 1]]},
    {
     StyleBox["\<\"\:2705 Listo para usar. Versi\[OAcute]n del \
01/10/2025.\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontWeight->Bold,
      FontColor->GrayLevel[0]]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Print",
 CellChangeTimes->{
  3.9669682799375896`*^9, 3.967457948582849*^9, 3.967471948983735*^9, {
   3.9674770386981697`*^9, 3.967477050891842*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"93a74172-ff0a-48c5-b889-5556b227b091"],

Cell[BoxData["\<\"Mostrando editores ya detectados...\"\>"], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967457948582849*^9, 
  3.967471948983735*^9, 3.9674770386981697`*^9, 3.967477074280147*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"674b7854-cd88-4875-8e65-81260c318344"],

Cell[BoxData["\<\"=== EDITORES LaTeX DETECTADOS ===\"\>"], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967457948582849*^9, 
  3.967471948983735*^9, 3.9674770386981697`*^9, 3.967477074281076*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"d2ffd7ff-6ed8-42c2-acbf-1d7f845e9200"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXShop\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"TeXShop\"\>"}],
  SequenceForm["\[Checkmark] ", "TeXShop", " \[RightArrow] ", "TeXShop"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967457948582849*^9, 
  3.967471948983735*^9, 3.9674770386981697`*^9, 3.967477074281493*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"9989d339-677b-4438-9527-3262e2c09fbf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"texstudio-4.8.8-osx-m1\"\>"}],
  SequenceForm[
  "\[Checkmark] ", "TeXstudio", " \[RightArrow] ", "texstudio-4.8.8-osx-m1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967457948582849*^9, 
  3.967471948983735*^9, 3.9674770386981697`*^9, 3.967477074281917*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"ce11a873-a43b-4e74-9987-a0a2f62df38a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"Texifier\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"Texifier\"\>"}],
  SequenceForm["\[Checkmark] ", "Texifier", " \[RightArrow] ", "Texifier"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967457948582849*^9, 
  3.967471948983735*^9, 3.9674770386981697`*^9, 3.967477074282329*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"ceb58b47-ddcd-4420-b386-a6b3509d912a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"LaTeXiT\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"LaTeXiT\"\>"}],
  SequenceForm["\[Checkmark] ", "LaTeXiT", " \[RightArrow] ", "LaTeXiT"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967457948582849*^9, 
  3.967471948983735*^9, 3.9674770386981697`*^9, 3.9674770742827187`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"3a96b8f0-c93a-4caf-bc95-05324fe8da0c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["11. ExportConicsToTikZ", "Subtitle",
 CellChangeTimes->{{3.964711967446312*^9, 3.9647120331966953`*^9}, {
   3.965828746741377*^9, 3.965828772379876*^9}, {3.966422117997758*^9, 
   3.966422160573628*^9}, {3.9664222257197533`*^9, 3.966422232684371*^9}, 
   3.9664306609167547`*^9, {3.966529924925062*^9, 3.966529927164893*^9}},
 Background->RGBColor[
  0.4, 0.6, 1, 0.33],ExpressionUUID->"e620c90a-a47e-4279-8a06-c63909917048"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "ExportConicsToTikZ"}]], "Input",
 CellChangeTimes->{{3.9672957088725033`*^9, 3.96729571486001*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"619f226d-8d73-41d4-8fcf-41bf318723dc"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ExportConicsToTikZ[equations, filename, grid, \
styles, ejes, texto, xmin, xmax, ymin, ymax] exporta rectas y ecuaciones c\
\[OAcute]nicas sin t\[EAcute]rminos cruzados (c\[IAcute]rculos, elipses, par\
\[AAcute]bolas, hip\[EAcute]rbolas) a formato TikZ/LaTeX, generando un \
documento LaTeX completo listo para compilar. No acepta \
desigualdades.\\n\\nSINTAXIS:\\nExportConicsToTikZ[equations, \
filename]\\nExportConicsToTikZ[equations, filename, \
grid]\\nExportConicsToTikZ[equations, filename, grid, \
styles]\\nExportConicsToTikZ[equations, filename, grid, styles, \
ejes]\\nExportConicsToTikZ[equations, filename, grid, styles, ejes, \
texto]\\nExportConicsToTikZ[equations, filename, grid, styles, ejes, texto, \
xmin]\\nExportConicsToTikZ[equations, filename, grid, styles, ejes, texto, \
xmin, xmax]\\nExportConicsToTikZ[equations, filename, grid, styles, ejes, \
texto, xmin, xmax, ymin]\\nExportConicsToTikZ[equations, filename, grid, \
styles, ejes, texto, xmin, xmax, ymin, ymax]\\n\\nARGUMENTOS:\\n\\nequations \
(OBLIGATORIO)\\n   Lista de ecuaciones en el formato {{ecuaci\[OAcute]n, \
{var_x, xmin_eq, xmax_eq}, {var_y, ymin_eq, ymax_eq}}, ...}\\n   - ecuaci\
\[OAcute]n: Ecuaci\[OAcute]n c\[OAcute]nica (Equal, LessEqual, GreaterEqual, \
Less, Greater)\\n   - var_x, var_y: Variables de las ecuaciones (ej. x, y)\\n \
  - xmin_eq, xmax_eq, ymin_eq, ymax_eq: Rangos de evaluaci\[OAcute]n para \
cada ecuaci\[OAcute]n espec\[IAcute]fica\\n\\nfilename (OBLIGATORIO)\\n   \
String terminado en '.tex' que especifica el nombre del archivo de \
salida\\n\\ngrid (OPCIONAL, por defecto: True)\\n   True|False - Controla si \
se muestra la grilla en el gr\[AAcute]fico\\n   - True: Muestra grilla \
mayor\\n   - False: Sin grilla\\n\\nstyles (OPCIONAL, por defecto: {})\\n   \
Lista de estilos para cada ecuaci\[OAcute]n en formato {{estilo1, color1}, \
{estilo2, color2}, ...}\\n   - Si est\[AAcute] vac\[IAcute]a {}, usa estilo \
por defecto: {\\\"solid\\\", \\\"black\\\"} para todas las ecuaciones\\n   - \
Estilos disponibles: \\\"solid\\\", \\\"dashed\\\", \\\"dotted\\\", \\\"thick\
\\\", \\\"thin\\\"\\n   - Colores disponibles: \\\"blue\\\", \\\"red\\\", \
\\\"green\\\", \\\"purple\\\", \\\"yellow\\\", \\\"orange\\\", \\\"cyan\\\", \
\\\"magenta\\\", \\\"black\\\"\\n\\nejes (OPCIONAL, por defecto: True)\\n   \
True|False - Controla la visualizaci\[OAcute]n de los ejes\\n   - True: Ejes \
centrados (axis lines=center)\\n   - False: Sin ejes (axis \
lines=none)\\n\\ntexto (OPCIONAL, por defecto: {})\\n   A\[NTilde]ade \
etiquetas de texto al gr\[AAcute]fico\\n   - Formato simple: {\\\"texto\\\", \
{x, y}}\\n   - Formato m\[UAcute]ltiple: {{\\\"texto1\\\", {x1, y1}}, \
{\\\"texto2\\\", {x2, y2}}, ...}\\n   - Las coordenadas son en el sistema de \
coordenadas del gr\[AAcute]fico\\n\\nxmin (OPCIONAL, por defecto: \
Automatic)\\n   Automatic|n\[UAcute]mero - L\[IAcute]mite inferior del eje \
x\\n   - Automatic: Calcula autom\[AAcute]ticamente basado en los datos \
generados\\n   - n\[UAcute]mero: Valor espec\[IAcute]fico para el \
l\[IAcute]mite inferior\\n\\nxmax (OPCIONAL, por defecto: Automatic)\\n   \
Automatic|n\[UAcute]mero - L\[IAcute]mite superior del eje x\\n   - \
Automatic: Calcula autom\[AAcute]ticamente basado en los datos generados\\n   \
- n\[UAcute]mero: Valor espec\[IAcute]fico para el l\[IAcute]mite superior\\n\
\\nymin (OPCIONAL, por defecto: Automatic)\\n   Automatic|n\[UAcute]mero - L\
\[IAcute]mite inferior del eje y\\n   - Automatic: Calcula \
autom\[AAcute]ticamente basado en los datos generados\\n   - n\[UAcute]mero: \
Valor espec\[IAcute]fico para el l\[IAcute]mite inferior\\n\\nymax (OPCIONAL, \
por defecto: Automatic)\\n   Automatic|n\[UAcute]mero - L\[IAcute]mite \
superior del eje y\\n   - Automatic: Calcula autom\[AAcute]ticamente basado \
en los datos generados\\n   - n\[UAcute]mero: Valor espec\[IAcute]fico para \
el l\[IAcute]mite superior\\n\\nEJEMPLOS DE USO:\\n\\nC\[IAcute]rculo simple \
(solo argumentos obligatorios):\\nExportConicsToTikZ[{{x^2 + y^2 == 4, {x, \
-3, 3}, {y, -3, 3}}}, \\\"circulo.tex\\\"]\\n\\nC\[IAcute]rculo con grilla \
desactivada:\\nExportConicsToTikZ[{{x^2 + y^2 == 4, {x, -3, 3}, {y, -3, 3}}}, \
\\\"circulo.tex\\\", False]\\n\\nM\[UAcute]ltiples c\[OAcute]nicas con \
estilos personalizados:\\nExportConicsToTikZ[{\\n  {x^2 + y^2 == 4, {x, -3, \
3}, {y, -3, 3}},\\n  {x^2/4 + y^2/9 == 1, {x, -3, 3}, {y, -4, 4}}\\n}, \
\\\"conicas.tex\\\", True, {{\\\"solid\\\", \\\"blue\\\"}, {\\\"dashed\\\", \
\\\"red\\\"}}]\\n\\nCon texto a\[NTilde]adido:\\nExportConicsToTikZ[{\\n  \
{x^2 + y^2 == 1, {x, -2, 2}, {y, -2, 2}}\\n}, \\\"ejemplo.tex\\\", True, {}, \
True, {{\\\"Centro\\\", {0, 0}}, {\\\"Radio = 1\\\", {1.2, 1.2}}}]\\n\\nCon l\
\[IAcute]mites personalizados completos:\\nExportConicsToTikZ[{\\n  {x^2/4 - \
y^2/9 == 1, {x, -6, 6}, {y, -8, 8}}\\n}, \\\"hiperbola.tex\\\", False, \
{{\\\"thick\\\", \\\"purple\\\"}}, True, \\n{\\\"Hip\[EAcute]rbola\\\", {0, \
6}}, -5, 5, -7, 7]\\n\\nUsando valores por defecto \
intermedios:\\nExportConicsToTikZ[{{x^2 + y^2 == 4, {x, -3, 3}, {y, -3, 3}}}, \
\\\"circulo.tex\\\", \\nTrue, {}, True, {}, -4]  (* Solo especifica xmin, los \
dem\[AAcute]s son Automatic *)\\n\\nCOMPORTAMIENTO:\\n\[Bullet] Los \
argumentos son posicionales, no opciones con nombres\\n\[Bullet] Si omites un \
argumento, se usa su valor por defecto\\n\[Bullet] Puedes especificar solo \
los primeros N argumentos que necesites\\n\[Bullet] Genera m\[EAcute]todos \
adaptativos para diferentes tipos de c\[OAcute]nicas\\n\[Bullet] \
C\[IAcute]rculos y elipses: M\[EAcute]todo param\[EAcute]trico para mayor \
precisi\[OAcute]n\\n\[Bullet] Hip\[EAcute]rbolas: Detecci\[OAcute]n autom\
\[AAcute]tica de ramas separadas\\n\[Bullet] Crea carpeta \
autom\[AAcute]ticamente en ~/Downloads/ con el nombre del archivo\\n\[Bullet] \
Genera documento LaTeX completo con paquetes necesarios (tikz, \
pgfplots)\\n\\nSALIDA:\\nRetorna la ruta completa del archivo .tex generado, \
listo para compilar con LaTeX.\\n\\nNOTAS:\\n\[Bullet] El archivo generado \
incluye todos los paquetes LaTeX necesarios\\n\[Bullet] Compatible con \
pgfplots versi\[OAcute]n 1.18\\n\[Bullet] Optimizado para curvas \
c\[OAcute]nicas\\n\[Bullet] Manejo autom\[AAcute]tico de puntos duplicados y \
ordenamiento inteligente\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"ExportConicsToTikZ", "[", 
                    
                    RowBox[{
                    "VilTeX`Private`equations_", ",", 
                    "VilTeX`Private`filename_", ",", 
                    RowBox[{"VilTeX`Private`grid_", ":", "True"}], ",", 
                    RowBox[{"VilTeX`Private`styles_", ":", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"VilTeX`Private`ejes_", ":", "True"}], ",", 
                    RowBox[{"VilTeX`Private`texto_", ":", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"VilTeX`Private`xmin_", ":", "Automatic"}], ",", 
                    RowBox[{"VilTeX`Private`xmax_", ":", "Automatic"}], ",", 
                    RowBox[{"VilTeX`Private`ymin_", ":", "Automatic"}], ",", 
                    RowBox[{"VilTeX`Private`ymax_", ":", "Automatic"}]}], 
                    "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`data", "=", 
                    RowBox[{"{", "}"}]}], ",", "VilTeX`Private`tikzLines", 
                    ",", "VilTeX`Private`fullDocument", ",", 
                    "VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`folderName", ",", 
                    "VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`xminFinal", ",", 
                    "VilTeX`Private`xmaxFinal", ",", 
                    "VilTeX`Private`yminFinal", ",", 
                    "VilTeX`Private`ymaxFinal", ",", 
                    "VilTeX`Private`formatNumber", ",", 
                    "VilTeX`Private`allPoints", ",", 
                    "VilTeX`Private`processedStyles"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Clear", "[", 
                    
                    RowBox[{"VilTeX`Private`generarPuntosCirculoElipse", ",", 
                    "VilTeX`Private`SymbolQ"}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"ListQ", "[", "VilTeX`Private`equations", "]"}]}],
                     "||", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`equations", "]"}], 
                    "\[Equal]", "0"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: Se requiere una lista de ecuaciones.\"", "]"}], 
                    ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"StringQ", "[", "VilTeX`Private`filename", 
                    "]"}]}], "||", 
                    RowBox[{"!", 
                    RowBox[{"StringEndsQ", "[", 
                    RowBox[{"VilTeX`Private`filename", ",", "\".tex\""}], 
                    "]"}]}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: filename debe ser un string terminado en \
.tex\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}]}], "]"}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`validacionCompleta", "=", 
                    "True"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`ecuacionEntry", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ecuacionEntry", "=", 
                    
                    RowBox[{"VilTeX`Private`equations", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"ListQ", "[", "VilTeX`Private`ecuacionEntry", 
                    "]"}]}], "||", 
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`ecuacionEntry", 
                    "]"}], "\[NotEqual]", "3"}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error en entrada \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\": Debe ser una lista de 3 elementos. Formato: {ecuaci\
\[OAcute]n, {x, xmin, xmax}, {y, ymin, ymax}}\""}], "]"}], ";", 
                    
                    RowBox[{"VilTeX`Private`validacionCompleta", "=", 
                    "False"}], ";", 
                    RowBox[{"Break", "[", "]"}]}]}], "]"}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`rangoX", ",", 
                    "VilTeX`Private`rangoY"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`rangoX", "=", 
                    
                    RowBox[{"VilTeX`Private`ecuacionEntry", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`rangoY", "=", 
                    
                    RowBox[{"VilTeX`Private`ecuacionEntry", 
                    "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"ListQ", "[", "VilTeX`Private`rangoX", "]"}]}], 
                    "||", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`rangoX", "]"}], 
                    "\[NotEqual]", "3"}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error en entrada \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\": El rango de x debe ser una lista de 3 elementos {x, \
xmin, xmax}\""}], "]"}], ";", 
                    RowBox[{
                    "VilTeX`Private`validacionCompleta", "=", "False"}], ";", 
                    
                    RowBox[{"Break", "[", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"ListQ", "[", "VilTeX`Private`rangoY", "]"}]}], 
                    "||", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`rangoY", "]"}], 
                    "\[NotEqual]", "3"}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error en entrada \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\": El rango de y debe ser una lista de 3 elementos {y, \
ymin, ymax}\""}], "]"}], ";", 
                    RowBox[{
                    "VilTeX`Private`validacionCompleta", "=", "False"}], ";", 
                    
                    RowBox[{"Break", "[", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"VilTeX`Private`SymbolQ", "[", 
                    
                    RowBox[{"VilTeX`Private`rangoX", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error en entrada \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\": La variable x debe ser un s\[IAcute]mbolo \
v\[AAcute]lido\""}], "]"}], ";", 
                    RowBox[{
                    "VilTeX`Private`validacionCompleta", "=", "False"}], ";", 
                    
                    RowBox[{"Break", "[", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"VilTeX`Private`SymbolQ", "[", 
                    
                    RowBox[{"VilTeX`Private`rangoY", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error en entrada \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\": La variable y debe ser un s\[IAcute]mbolo \
v\[AAcute]lido\""}], "]"}], ";", 
                    RowBox[{
                    "VilTeX`Private`validacionCompleta", "=", "False"}], ";", 
                    
                    RowBox[{"Break", "[", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"NumericQ", "[", 
                    
                    RowBox[{"VilTeX`Private`rangoX", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "]"}]}], "||", 
                    RowBox[{"!", 
                    RowBox[{"NumericQ", "[", 
                    
                    RowBox[{"VilTeX`Private`rangoX", "\[LeftDoubleBracket]", 
                    "3", "\[RightDoubleBracket]"}], "]"}]}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error en entrada \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\": xmin y xmax deben ser valores num\[EAcute]ricos\""}],
                     "]"}], ";", 
                    RowBox[{
                    "VilTeX`Private`validacionCompleta", "=", "False"}], ";", 
                    
                    RowBox[{"Break", "[", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"NumericQ", "[", 
                    
                    RowBox[{"VilTeX`Private`rangoY", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "]"}]}], "||", 
                    RowBox[{"!", 
                    RowBox[{"NumericQ", "[", 
                    
                    RowBox[{"VilTeX`Private`rangoY", "\[LeftDoubleBracket]", 
                    "3", "\[RightDoubleBracket]"}], "]"}]}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error en entrada \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\": ymin y ymax deben ser valores num\[EAcute]ricos\""}],
                     "]"}], ";", 
                    RowBox[{
                    "VilTeX`Private`validacionCompleta", "=", "False"}], ";", 
                    
                    RowBox[{"Break", "[", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`rangoX", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "\[GreaterEqual]", 
                    
                    RowBox[{"VilTeX`Private`rangoX", "\[LeftDoubleBracket]", 
                    "3", "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error en entrada \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\": xmin debe ser menor que xmax\""}], "]"}], ";", 
                    
                    RowBox[{"VilTeX`Private`validacionCompleta", "=", 
                    "False"}], ";", 
                    RowBox[{"Break", "[", "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`rangoY", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "\[GreaterEqual]", 
                    
                    RowBox[{"VilTeX`Private`rangoY", "\[LeftDoubleBracket]", 
                    "3", "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error en entrada \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\": ymin debe ser menor que ymax\""}], "]"}], ";", 
                    
                    RowBox[{"VilTeX`Private`validacionCompleta", "=", 
                    "False"}], ";", 
                    RowBox[{"Break", "[", "]"}]}]}], "]"}], ";"}]}], "]"}], 
                    ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`equations", 
                    "]"}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", "VilTeX`Private`validacionCompleta"}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";"}]}],
                     "]"}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`validacionConica", "=", "True"}], 
                    "}"}], ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`eq", ",", "VilTeX`Private`xvar", 
                    ",", "VilTeX`Private`yvar", ",", "VilTeX`Private`xminEq", 
                    ",", "VilTeX`Private`xmaxEq", ",", 
                    "VilTeX`Private`yminEq", ",", "VilTeX`Private`ymaxEq", 
                    ",", "VilTeX`Private`expanded", ",", 
                    "VilTeX`Private`coeffs", ",", "VilTeX`Private`dims", ",", 
                    "VilTeX`Private`hasXYterm", ",", 
                    "VilTeX`Private`degree"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`eq", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xvar", ",", 
                    "VilTeX`Private`xminEq", ",", "VilTeX`Private`xmaxEq"}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`yvar", ",", 
                    "VilTeX`Private`yminEq", ",", "VilTeX`Private`ymaxEq"}], 
                    "}"}]}], "}"}], "=", 
                    
                    RowBox[{"VilTeX`Private`equations", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`eq", "]"}], "=!=", 
                    "Equal"}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error en ecuaci\[OAcute]n \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\": Solo se aceptan ecuaciones (=), no \
desigualdades.\""}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`validacionConica", "=", "False"}],
                     ";", 
                    RowBox[{"Break", "[", "]"}]}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`expanded", "=", 
                    RowBox[{"Expand", "[", 
                    RowBox[{"VilTeX`Private`eq", "/.", "\[VeryThinSpace]", 
                    RowBox[{"Equal", "\[Rule]", "Subtract"}]}], "]"}]}], ";", 
                    
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`vars", "=", 
                    
                    RowBox[{"Variables", "[", "VilTeX`Private`expanded", 
                    "]"}]}], "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"SubsetQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xvar", ",", 
                    "VilTeX`Private`yvar"}], "}"}], ",", 
                    "VilTeX`Private`vars"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error en ecuaci\[OAcute]n \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\": La ecuaci\[OAcute]n contiene variables no declaradas \
(\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Complement", "[", 
                    RowBox[{"VilTeX`Private`vars", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xvar", ",", 
                    "VilTeX`Private`yvar"}], "}"}]}], "]"}], "]"}], "<>", 
                    "\"). Solo se permiten \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`xvar", "]"}], 
                    "<>", "\" y \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`yvar", "]"}], 
                    "<>", "\".\""}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`validacionConica", "=", "False"}],
                     ";", 
                    RowBox[{"Break", "[", "]"}]}]}], "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`coeffs", "=", 
                    RowBox[{"CoefficientList", "[", 
                    RowBox[{"VilTeX`Private`expanded", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xvar", ",", 
                    "VilTeX`Private`yvar"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`dims", "=", 
                    
                    RowBox[{"Dimensions", "[", "VilTeX`Private`coeffs", 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`hasXYterm", "=", "False"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`dims", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "\[GreaterEqual]", "2"}], 
                    "&&", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`dims", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "\[GreaterEqual]", 
                    "2"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`coeffs", "\[LeftDoubleBracket]", 
                    RowBox[{"2", ",", "2"}], "\[RightDoubleBracket]"}], "=!=",
                     "0"}], ",", 
                    RowBox[{"VilTeX`Private`hasXYterm", "=", "True"}]}], 
                    "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`hasXYterm", ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error en ecuaci\[OAcute]n \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\": No se permiten t\[EAcute]rminos cruzados (\"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`xvar", "]"}], 
                    "<>", "\"*\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`yvar", "]"}], 
                    "<>", "\").\""}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`validacionConica", "=", "False"}],
                     ";", 
                    RowBox[{"Break", "[", "]"}]}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`degree", "=", 
                    RowBox[{
                    RowBox[{"Max", "[", "VilTeX`Private`dims", "]"}], "-", 
                    "1"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`degree", ">", "2"}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error en ecuaci\[OAcute]n \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\": El grado m\[AAcute]ximo permitido es 2 \
(c\[OAcute]nicas y rectas). Grado encontrado: \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`degree", "]"}], 
                    "<>", "\".\""}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`validacionConica", "=", "False"}],
                     ";", 
                    RowBox[{"Break", "[", "]"}]}]}], "]"}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`a", ",", "VilTeX`Private`b", ",", 
                    "VilTeX`Private`c", ",", "VilTeX`Private`d", ",", 
                    "VilTeX`Private`e"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`e", "=", 
                    RowBox[{"VilTeX`Private`coeffs", "\[LeftDoubleBracket]", 
                    RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`c", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`dims", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], ">", "1"}], ",", 
                    RowBox[{"VilTeX`Private`coeffs", "\[LeftDoubleBracket]", 
                    RowBox[{"2", ",", "1"}], "\[RightDoubleBracket]"}], ",", 
                    "0"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`d", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`dims", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], ">", "1"}], ",", 
                    RowBox[{"VilTeX`Private`coeffs", "\[LeftDoubleBracket]", 
                    RowBox[{"1", ",", "2"}], "\[RightDoubleBracket]"}], ",", 
                    "0"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`a", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`dims", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], ">", "2"}], ",", 
                    RowBox[{"VilTeX`Private`coeffs", "\[LeftDoubleBracket]", 
                    RowBox[{"3", ",", "1"}], "\[RightDoubleBracket]"}], ",", 
                    "0"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`b", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`dims", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], ">", "2"}], ",", 
                    RowBox[{"VilTeX`Private`coeffs", "\[LeftDoubleBracket]", 
                    RowBox[{"1", ",", "3"}], "\[RightDoubleBracket]"}], ",", 
                    "0"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`a", "\[Equal]", "0"}], "&&", 
                    RowBox[{"VilTeX`Private`b", "\[Equal]", "0"}], "&&", 
                    RowBox[{"VilTeX`Private`c", "\[Equal]", "0"}], "&&", 
                    RowBox[{"VilTeX`Private`d", "\[Equal]", "0"}]}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"Error en ecuaci\[OAcute]n \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\": Ecuaci\[OAcute]n degenerada (solo constante).\""}], 
                    "]"}], ";", 
                    RowBox[{"VilTeX`Private`validacionConica", "=", "False"}],
                     ";", 
                    RowBox[{"Break", "[", "]"}]}]}], "]"}], ";"}]}], "]"}], 
                    ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`equations", 
                    "]"}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", "VilTeX`Private`validacionConica"}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";"}]}],
                     "]"}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`x_", "]"}], ":=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Round", "[", 
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`x", "]"}], ",", 
                    "0.001`"}], "]"}], "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`generarPuntosCirculoElipse", "[", 
                    
                    
                    RowBox[{"VilTeX`Private`eq_", ",", "VilTeX`Private`xvar_",
                     ",", "VilTeX`Private`yvar_", ",", 
                    "VilTeX`Private`xminEq_", ",", "VilTeX`Private`xmaxEq_", 
                    ",", "VilTeX`Private`yminEq_", ",", 
                    "VilTeX`Private`ymaxEq_"}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`expanded", ",", 
                    "VilTeX`Private`coeffs", ",", "VilTeX`Private`dims", ",", 
                    "VilTeX`Private`a", ",", "VilTeX`Private`b", ",", 
                    "VilTeX`Private`c", ",", "VilTeX`Private`d", ",", 
                    "VilTeX`Private`e", ",", "VilTeX`Private`h", ",", 
                    "VilTeX`Private`k", ",", "VilTeX`Private`rx", ",", 
                    "VilTeX`Private`ry", ",", 
                    RowBox[{"VilTeX`Private`points", "=", 
                    RowBox[{"{", "}"}]}], ",", "VilTeX`Private`t", ",", 
                    "VilTeX`Private`xVal", ",", "VilTeX`Private`yVal", ",", 
                    RowBox[{"VilTeX`Private`success", "=", "False"}]}], "}"}],
                     ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`expanded", "=", 
                    RowBox[{"Expand", "[", 
                    RowBox[{"VilTeX`Private`eq", "/.", "\[VeryThinSpace]", 
                    RowBox[{"Equal", "\[Rule]", "Subtract"}]}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`coeffs", "=", 
                    RowBox[{"CoefficientList", "[", 
                    RowBox[{"VilTeX`Private`expanded", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xvar", ",", 
                    "VilTeX`Private`yvar"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`dims", "=", 
                    
                    RowBox[{"Dimensions", "[", "VilTeX`Private`coeffs", 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`e", "=", 
                    RowBox[{"VilTeX`Private`coeffs", "\[LeftDoubleBracket]", 
                    RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`c", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`dims", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], ">", "1"}], ",", 
                    RowBox[{"VilTeX`Private`coeffs", "\[LeftDoubleBracket]", 
                    RowBox[{"2", ",", "1"}], "\[RightDoubleBracket]"}], ",", 
                    "0"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`d", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`dims", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], ">", "1"}], ",", 
                    RowBox[{"VilTeX`Private`coeffs", "\[LeftDoubleBracket]", 
                    RowBox[{"1", ",", "2"}], "\[RightDoubleBracket]"}], ",", 
                    "0"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`a", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`dims", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], ">", "2"}], ",", 
                    RowBox[{"VilTeX`Private`coeffs", "\[LeftDoubleBracket]", 
                    RowBox[{"3", ",", "1"}], "\[RightDoubleBracket]"}], ",", 
                    "0"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`b", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`dims", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], ">", "2"}], ",", 
                    RowBox[{"VilTeX`Private`coeffs", "\[LeftDoubleBracket]", 
                    RowBox[{"1", ",", "3"}], "\[RightDoubleBracket]"}], ",", 
                    "0"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilTeX`Private`a", "]"}], "&&", 
                    
                    RowBox[{"NumericQ", "[", "VilTeX`Private`b", "]"}], "&&", 
                    
                    RowBox[{"VilTeX`Private`a", ">", "0"}], "&&", 
                    RowBox[{"VilTeX`Private`b", ">", "0"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`h", "=", 
                    RowBox[{"-", 
                    FractionBox["VilTeX`Private`c", 
                    RowBox[{"2", " ", "VilTeX`Private`a"}]]}]}], ";", 
                    RowBox[{"VilTeX`Private`k", "=", 
                    RowBox[{"-", 
                    FractionBox["VilTeX`Private`d", 
                    RowBox[{"2", " ", "VilTeX`Private`b"}]]}]}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`discriminant", "=", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["VilTeX`Private`h", "2"], " ", 
                    "VilTeX`Private`a"}], "+", 
                    RowBox[{
                    SuperscriptBox["VilTeX`Private`k", "2"], " ", 
                    "VilTeX`Private`b"}], "-", "VilTeX`Private`e"}]}], "}"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`discriminant", ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`rx", "=", 
                    SqrtBox[
                    FractionBox[
                    "VilTeX`Private`discriminant", "VilTeX`Private`a"]]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`ry", "=", 
                    SqrtBox[
                    FractionBox[
                    "VilTeX`Private`discriminant", "VilTeX`Private`b"]]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilTeX`Private`h", "]"}], "&&", 
                    
                    RowBox[{"NumericQ", "[", "VilTeX`Private`k", "]"}], "&&", 
                    
                    RowBox[{"NumericQ", "[", "VilTeX`Private`rx", "]"}], "&&", 
                    RowBox[{"NumericQ", "[", "VilTeX`Private`ry", "]"}], "&&", 
                    RowBox[{"VilTeX`Private`rx", ">", "0"}], "&&", 
                    RowBox[{"VilTeX`Private`ry", ">", "0"}], "&&", 
                    RowBox[{"VilTeX`Private`rx", "<", "50"}], "&&", 
                    RowBox[{"VilTeX`Private`ry", "<", "50"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`success", "=", "True"}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVal", "=", 
                    RowBox[{"VilTeX`Private`h", "+", 
                    RowBox[{"VilTeX`Private`rx", " ", 
                    RowBox[{"Cos", "[", "VilTeX`Private`t", "]"}]}]}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`yVal", "=", 
                    RowBox[{"VilTeX`Private`k", "+", 
                    RowBox[{"VilTeX`Private`ry", " ", 
                    RowBox[{"Sin", "[", "VilTeX`Private`t", "]"}]}]}]}], ";", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`xminEq", "\[LessEqual]", 
                    "VilTeX`Private`xVal", "\[LessEqual]", 
                    "VilTeX`Private`xmaxEq"}], "&&", 
                    
                    RowBox[{"VilTeX`Private`yminEq", "\[LessEqual]", 
                    "VilTeX`Private`yVal", "\[LessEqual]", 
                    "VilTeX`Private`ymaxEq"}]}], ",", 
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`points", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`xVal", "]"}], ",", 
                    RowBox[{"N", "[", "VilTeX`Private`yVal", "]"}]}], "}"}]}],
                     "]"}], ";"}]}], "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`t", ",", "0", ",", 
                    RowBox[{"2", " ", "\[Pi]"}], ",", 
                    FractionBox["\[Pi]", "150"]}], "}"}]}], "]"}], ";"}]}], 
                    "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], 
                    ";", "VilTeX`Private`points"}]}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`eq", ",", "VilTeX`Private`xvar", 
                    ",", "VilTeX`Private`xminEq", ",", 
                    "VilTeX`Private`xmaxEq", ",", "VilTeX`Private`yvar", ",", 
                    "VilTeX`Private`yminEq", ",", "VilTeX`Private`ymaxEq", 
                    ",", "VilTeX`Private`points"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`eq", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xvar", ",", 
                    "VilTeX`Private`xminEq", ",", "VilTeX`Private`xmaxEq"}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`yvar", ",", 
                    "VilTeX`Private`yminEq", ",", "VilTeX`Private`ymaxEq"}], 
                    "}"}]}], "}"}], "=", 
                    
                    RowBox[{"VilTeX`Private`equations", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`points", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`usedParametricMethod", "=", 
                    "False"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`points", "=", 
                    
                    RowBox[{"VilTeX`Private`generarPuntosCirculoElipse", "[", 
                    
                    RowBox[{"VilTeX`Private`eq", ",", "VilTeX`Private`xvar", 
                    ",", "VilTeX`Private`yvar", ",", "VilTeX`Private`xminEq", 
                    ",", "VilTeX`Private`xmaxEq", ",", 
                    "VilTeX`Private`yminEq", ",", "VilTeX`Private`ymaxEq"}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`points", "]"}], 
                    "\[GreaterEqual]", "50"}], ",", 
                    
                    RowBox[{"VilTeX`Private`usedParametricMethod", "=", 
                    "True"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`points", "]"}], 
                    "<", "50"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`points", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`sols", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Solve", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`eq", "/.", "\[VeryThinSpace]", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xvar", "\[Rule]", 
                    "VilTeX`Private`xVal"}], "}"}]}], ",", 
                    "VilTeX`Private`yvar", ",", 
                    TemplateBox[{}, "Reals"]}], "]"}], "]"}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`sols", "=!=", 
                    RowBox[{"{", "}"}]}], "&&", 
                    RowBox[{"VilTeX`Private`sols", "=!=", "$Failed"}]}], ",", 
                    
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`yVal", "=", 
                    RowBox[{"VilTeX`Private`yvar", "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"VilTeX`Private`sols", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}]}]}], "}"}], 
                    ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilTeX`Private`yVal", "]"}], 
                    "&&", 
                    RowBox[{"VilTeX`Private`yminEq", "\[LessEqual]", 
                    "VilTeX`Private`yVal", "\[LessEqual]", 
                    "VilTeX`Private`ymaxEq"}]}], ",", 
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`points", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`xVal", "]"}], ",", 
                    RowBox[{"N", "[", "VilTeX`Private`yVal", "]"}]}], "}"}]}],
                     "]"}], ";"}]}], "]"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`sols", "]"}]}], 
                    "}"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVal", ",", 
                    "VilTeX`Private`xminEq", ",", "VilTeX`Private`xmaxEq", 
                    ",", 
                    FractionBox[
                    
                    RowBox[{"VilTeX`Private`xmaxEq", "-", 
                    "VilTeX`Private`xminEq"}], "200"]}], "}"}]}], "]"}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`points", "]"}], 
                    ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`points", "=", 
                    RowBox[{"DeleteDuplicates", "[", 
                    RowBox[{"VilTeX`Private`points", ",", 
                    RowBox[{
                    RowBox[{
                    TemplateBox[{
                    RowBox[{"#1", "-", "#2"}]}, "Norm"], "<", "0.01`"}], 
                    "&"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`usedParametricMethod", ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`center", "=", 
                    RowBox[{"Mean", "[", "VilTeX`Private`points", "]"}]}], 
                    ",", "VilTeX`Private`sortedPoints"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`sortedPoints", "=", 
                    RowBox[{"SortBy", "[", 
                    RowBox[{"VilTeX`Private`points", ",", 
                    RowBox[{
                    RowBox[{"ArcTan", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "VilTeX`Private`center", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "VilTeX`Private`center", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}]}], "]"}], "&"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`sortedPoints", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`sortedPoints", ",", 
                    
                    RowBox[{"First", "[", "VilTeX`Private`sortedPoints", 
                    "]"}]}], "]"}]}], ";", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`data", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"\"line\"", ",", "VilTeX`Private`sortedPoints", 
                    ",", "VilTeX`Private`i"}], "}"}]}], "]"}], ";"}]}], "]"}],
                     ";"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`center", ",", 
                    "VilTeX`Private`sortedPoints", ",", 
                    "VilTeX`Private`isCircleElipse"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`isCircleElipse", "=", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`points", "]"}], 
                    ">", "100"}], "&&", 
                    RowBox[{
                    TemplateBox[{
                    RowBox[{
                    RowBox[{"First", "[", "VilTeX`Private`points", "]"}], "-", 
                    RowBox[{"Last", "[", "VilTeX`Private`points", "]"}]}]}, 
                    "Norm"], "<", "1.`"}]}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`isCircleElipse", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`center", "=", 
                    RowBox[{"Mean", "[", "VilTeX`Private`points", "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`sortedPoints", "=", 
                    RowBox[{"SortBy", "[", 
                    RowBox[{"VilTeX`Private`points", ",", 
                    RowBox[{
                    RowBox[{"ArcTan", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{"VilTeX`Private`center", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{"VilTeX`Private`center", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}]}], "]"}], "&"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`sortedPoints", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`sortedPoints", ",", 
                    
                    RowBox[{"First", "[", "VilTeX`Private`sortedPoints", 
                    "]"}]}], "]"}]}], ";", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`data", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"\"line\"", ",", "VilTeX`Private`sortedPoints", 
                    ",", "VilTeX`Private`i"}], "}"}]}], "]"}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`leftPoints", "=", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"VilTeX`Private`rightPoints", "=", 
                    RowBox[{"{", "}"}]}], ",", "VilTeX`Private`centerX"}], 
                    "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`points", "]"}], 
                    ">", "20"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`centerX", "=", 
                    RowBox[{"Mean", "[", 
                    RowBox[{"VilTeX`Private`points", "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`pt", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "<", 
                    "VilTeX`Private`centerX"}], ",", 
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`leftPoints", ",", 
                    "VilTeX`Private`pt"}], "]"}], ",", 
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`rightPoints", ",", 
                    "VilTeX`Private`pt"}], "]"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`pt", ",", 
                    "VilTeX`Private`points"}], "}"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`leftPoints", "]"}],
                     ">", "10"}], "&&", 
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`rightPoints", 
                    "]"}], ">", "10"}], "&&", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Min", "[", 
                    
                    RowBox[{"VilTeX`Private`rightPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}], "-", 
                    RowBox[{"Max", "[", 
                    
                    RowBox[{"VilTeX`Private`leftPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ">", "0.5`"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`leftPoints", "]"}],
                     ">", "3"}], ",", 
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`data", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"line\"", ",", 
                    RowBox[{"SortBy", "[", 
                    RowBox[{"VilTeX`Private`leftPoints", ",", "Last"}], "]"}],
                     ",", "VilTeX`Private`i"}], "}"}]}], "]"}], ";"}]}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`rightPoints", 
                    "]"}], ">", "3"}], ",", 
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`data", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"line\"", ",", 
                    RowBox[{"SortBy", "[", 
                    RowBox[{"VilTeX`Private`rightPoints", ",", "Last"}], 
                    "]"}], ",", "VilTeX`Private`i"}], "}"}]}], "]"}], 
                    ";"}]}], "]"}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`data", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"line\"", ",", 
                    RowBox[{"SortBy", "[", 
                    RowBox[{"VilTeX`Private`points", ",", "First"}], "]"}], 
                    ",", "VilTeX`Private`i"}], "}"}]}], "]"}], ";"}]}], 
                    "]"}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`data", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"line\"", ",", 
                    RowBox[{"SortBy", "[", 
                    RowBox[{"VilTeX`Private`points", ",", "First"}], "]"}], 
                    ",", "VilTeX`Private`i"}], "}"}]}], "]"}], ";"}]}], "]"}],
                     ";"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";"}]}], 
                    "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`equations", 
                    "]"}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`processedStyles", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`styles", "]"}], 
                    "\[Equal]", "0"}], ",", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"\"solid\"", ",", "\"black\""}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"Length", "[", "VilTeX`Private`equations", "]"}], 
                    "}"}]}], "]"}], ",", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`i", "\[LessEqual]", 
                    RowBox[{"Length", "[", "VilTeX`Private`styles", "]"}]}], 
                    "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`styles", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "]"}], 
                    "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`styles", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], "]"}], 
                    "\[GreaterEqual]", "2"}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`styles", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"solid\"", ",", "\"black\""}], "}"}]}], "]"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`equations", 
                    "]"}]}], "}"}]}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`data", "]"}], ">", 
                    "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`allPoints", "=", 
                    RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`data", "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], ",",
                     "1"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`xminFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmin", "===", "Automatic"}], ",", 
                    
                    RowBox[{
                    RowBox[{"Min", "[", 
                    
                    RowBox[{"VilTeX`Private`allPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}], "-", "0.5`"}], ",", "VilTeX`Private`xmin"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`xmaxFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmax", "===", "Automatic"}], ",", 
                    
                    RowBox[{
                    RowBox[{"Max", "[", 
                    
                    RowBox[{"VilTeX`Private`allPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}], "+", "0.5`"}], ",", "VilTeX`Private`xmax"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yminFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymin", "===", "Automatic"}], ",", 
                    
                    RowBox[{
                    RowBox[{"Min", "[", 
                    
                    RowBox[{"VilTeX`Private`allPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}], "-", "0.5`"}], ",", "VilTeX`Private`ymin"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`ymaxFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymax", "===", "Automatic"}], ",", 
                    
                    RowBox[{
                    RowBox[{"Max", "[", 
                    
                    RowBox[{"VilTeX`Private`allPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}], "+", "0.5`"}], ",", "VilTeX`Private`ymax"}], 
                    "]"}]}], ";"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xminFinal", ",", 
                    "VilTeX`Private`xmaxFinal", ",", 
                    "VilTeX`Private`yminFinal", ",", 
                    "VilTeX`Private`ymaxFinal"}], "}"}], "=", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "5"}], ",", "5", ",", 
                    RowBox[{"-", "5"}], ",", "5"}], "}"}]}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"VilTeX`Private`tikzLines", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`tikzLines", ",", 
                    "\"\\\\begin{tikzpicture}\""}], "]"}], ";", 
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`tikzLines", ",", 
                    "\"\\\\begin{axis}[\""}], "]"}], ";", 
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`tikzLines", ",", 
                    "\"  xlabel={$x$},\""}], "]"}], ";", 
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`tikzLines", ",", 
                    "\"  ylabel={$y$},\""}], "]"}], ";", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`tikzLines", ",", 
                    RowBox[{"\"  xmin=\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`xminFinal", "]"}], "<>", "\",\""}]}], 
                    "]"}], ";", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`tikzLines", ",", 
                    RowBox[{"\"  xmax=\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`xmaxFinal", "]"}], "<>", "\",\""}]}], 
                    "]"}], ";", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`tikzLines", ",", 
                    RowBox[{"\"  ymin=\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`yminFinal", "]"}], "<>", "\",\""}]}], 
                    "]"}], ";", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`tikzLines", ",", 
                    RowBox[{"\"  ymax=\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`ymaxFinal", "]"}], "<>", "\",\""}]}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`grid", ",", 
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`tikzLines", ",", 
                    "\"  grid=major,\""}], "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`ejes", ",", 
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`tikzLines", ",", 
                    "\"  axis lines=center,\""}], "]"}], ",", 
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`tikzLines", ",", 
                    "\"  axis lines=none,\""}], "]"}]}], "]"}], ";", 
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`tikzLines", ",", 
                    "\"  width=10cm,\""}], "]"}], ";", 
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`tikzLines", ",", 
                    "\"  height=8cm\""}], "]"}], ";", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`tikzLines", ",", "\"]\""}], "]"}],
                     ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`dataType", ",", 
                    "VilTeX`Private`pts", ",", "VilTeX`Private`equationIndex",
                     ",", "VilTeX`Private`style", ",", "VilTeX`Private`color",
                     ",", "VilTeX`Private`coordStr", ",", 
                    "VilTeX`Private`styleStr", ",", "VilTeX`Private`colorStr",
                     ",", "VilTeX`Private`tikzStyleOptions"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`dataType", ",", 
                    "VilTeX`Private`pts", ",", 
                    "VilTeX`Private`equationIndex"}], "}"}], "=", 
                    
                    RowBox[{"VilTeX`Private`data", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`style", ",", 
                    "VilTeX`Private`color"}], "}"}], "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`equationIndex", "\[LessEqual]", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`processedStyles", 
                    "]"}]}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`processedStyles", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`equationIndex", 
                    "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`processedStyles", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`equationIndex", 
                    "\[RightDoubleBracket]"}], "]"}], "\[GreaterEqual]", 
                    "2"}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`processedStyles", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`equationIndex", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"solid\"", ",", "\"black\""}], "}"}]}], "]"}]}],
                     ";", 
                    RowBox[{"VilTeX`Private`styleStr", "=", 
                    RowBox[{"ToString", "[", "VilTeX`Private`style", "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`colorStr", "=", 
                    RowBox[{"ToString", "[", "VilTeX`Private`color", "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`colorStr", "=", 
                    RowBox[{"Switch", "[", 
                    RowBox[{
                    
                    RowBox[{"ToLowerCase", "[", "VilTeX`Private`colorStr", 
                    "]"}], ",", "\"blue\"", ",", "\"blue\"", ",", "\"red\"", 
                    ",", "\"red\"", ",", "\"green\"", ",", "\"green\"", ",", 
                    "\"purple\"", ",", "\"violet\"", ",", "\"yellow\"", ",", 
                    "\"yellow\"", ",", "\"orange\"", ",", "\"orange\"", ",", 
                    "\"cyan\"", ",", "\"cyan\"", ",", "\"magenta\"", ",", 
                    "\"magenta\"", ",", "_", ",", "\"black\""}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzStyleOptions", "=", 
                    RowBox[{"Switch", "[", 
                    RowBox[{
                    
                    RowBox[{"ToLowerCase", "[", "VilTeX`Private`styleStr", 
                    "]"}], ",", "\"dashed\"", ",", "\", dashed\"", ",", 
                    "\"dotted\"", ",", "\", dotted\"", ",", "\"thick\"", ",", 
                    "\", very thick\"", ",", "\"thin\"", ",", "\", thin\"", 
                    ",", "_", ",", "\"\""}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`coordStr", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Riffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`pt", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`pt", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`pt", ",", "VilTeX`Private`pts"}], 
                    "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "]"}]}], ";", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`tikzLines", ",", 
                    
                    RowBox[{"\"\\\\addplot[\"", "<>", 
                    "VilTeX`Private`colorStr", "<>", "\", thick\"", "<>", 
                    "VilTeX`Private`tikzStyleOptions", "<>", 
                    "\"] coordinates {\""}]}], "]"}], ";", 
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`tikzLines", ",", 
                    "VilTeX`Private`coordStr"}], "]"}], ";", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`tikzLines", ",", "\"};\""}], 
                    "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`data", "]"}]}], 
                    "}"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`texto", "]"}], ">",
                     "0"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`textoEntries", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`texto", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], ",", 
                    "VilTeX`Private`texto", ",", 
                    RowBox[{"{", "VilTeX`Private`texto", "}"}]}], "]"}]}], 
                    "}"}], ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`textoStr", ",", 
                    "VilTeX`Private`coordenadas"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`textoStr", ",", 
                    "VilTeX`Private`coordenadas"}], "}"}], "=", 
                    
                    RowBox[{"VilTeX`Private`textoEntries", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`tikzLines", ",", 
                    RowBox[{"\"\\\\node at (axis cs:\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`coordenadas", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`coordenadas", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\") {\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`textoStr", "]"}],
                     "<>", "\"};\""}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`textoEntries", 
                    "]"}]}], "}"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`tikzLines", ",", 
                    "\"\\\\end{axis}\""}], "]"}], ";", 
                    RowBox[{"AppendTo", "[", 
                    
                    RowBox[{"VilTeX`Private`tikzLines", ",", 
                    "\"\\\\end{tikzpicture}\""}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`fullDocument", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{
                    "\"\\\\documentclass[border=5mm]{standalone}\\n\"", ",", 
                    "\"\\\\usepackage{tikz}\\n\"", ",", 
                    "\"\\\\usepackage{pgfplots}\\n\"", ",", 
                    "\"\\\\usepackage{amsmath}\\n\"", ",", 
                    "\"\\\\pgfplotsset{compat=1.18}\\n\\n\"", ",", 
                    "\"\\\\begin{document}\\n\"", ",", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{"VilTeX`Private`tikzLines", ",", "\"\\n\""}], 
                    "]"}], ",", "\"\\n\\\\end{document}\""}], "}"}], "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`folderName", "=", 
                    
                    RowBox[{"FileBaseName", "[", "VilTeX`Private`filename", 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`folderPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"$HomeDirectory", ",", "\"Downloads\"", ",", 
                    "VilTeX`Private`folderName"}], "}"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"DirectoryQ", "[", "VilTeX`Private`folderPath", 
                    "]"}]}], ",", 
                    
                    RowBox[{"CreateDirectory", "[", 
                    "VilTeX`Private`folderPath", "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`downloadPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`filename"}], "}"}], "]"}]}], ";", 
                    RowBox[{"Export", "[", 
                    
                    RowBox[{"VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`fullDocument", ",", "\"Text\""}], "]"}], 
                    ";", "VilTeX`Private`downloadPath"}]}], "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilTeX`ExportConicsToTikZ\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ExportConicsToTikZ[equations, filename, grid, \
styles, ejes, texto, xmin, xmax, ymin, ymax] exporta rectas y ecuaciones c\
\[OAcute]nicas sin t\[EAcute]rminos cruzados (c\[IAcute]rculos, elipses, par\
\[AAcute]bolas, hip\[EAcute]rbolas) a formato TikZ/LaTeX, generando un \
documento LaTeX completo listo para compilar. No acepta \
desigualdades.\\n\\nSINTAXIS:\\nExportConicsToTikZ[equations, \
filename]\\nExportConicsToTikZ[equations, filename, \
grid]\\nExportConicsToTikZ[equations, filename, grid, \
styles]\\nExportConicsToTikZ[equations, filename, grid, styles, \
ejes]\\nExportConicsToTikZ[equations, filename, grid, styles, ejes, \
texto]\\nExportConicsToTikZ[equations, filename, grid, styles, ejes, texto, \
xmin]\\nExportConicsToTikZ[equations, filename, grid, styles, ejes, texto, \
xmin, xmax]\\nExportConicsToTikZ[equations, filename, grid, styles, ejes, \
texto, xmin, xmax, ymin]\\nExportConicsToTikZ[equations, filename, grid, \
styles, ejes, texto, xmin, xmax, ymin, ymax]\\n\\nARGUMENTOS:\\n\\nequations \
(OBLIGATORIO)\\n   Lista de ecuaciones en el formato {{ecuaci\[OAcute]n, \
{var_x, xmin_eq, xmax_eq}, {var_y, ymin_eq, ymax_eq}}, ...}\\n   - ecuaci\
\[OAcute]n: Ecuaci\[OAcute]n c\[OAcute]nica (Equal, LessEqual, GreaterEqual, \
Less, Greater)\\n   - var_x, var_y: Variables de las ecuaciones (ej. x, y)\\n \
  - xmin_eq, xmax_eq, ymin_eq, ymax_eq: Rangos de evaluaci\[OAcute]n para \
cada ecuaci\[OAcute]n espec\[IAcute]fica\\n\\nfilename (OBLIGATORIO)\\n   \
String terminado en '.tex' que especifica el nombre del archivo de \
salida\\n\\ngrid (OPCIONAL, por defecto: True)\\n   True|False - Controla si \
se muestra la grilla en el gr\[AAcute]fico\\n   - True: Muestra grilla \
mayor\\n   - False: Sin grilla\\n\\nstyles (OPCIONAL, por defecto: {})\\n   \
Lista de estilos para cada ecuaci\[OAcute]n en formato {{estilo1, color1}, \
{estilo2, color2}, ...}\\n   - Si est\[AAcute] vac\[IAcute]a {}, usa estilo \
por defecto: {\\\"solid\\\", \\\"black\\\"} para todas las ecuaciones\\n   - \
Estilos disponibles: \\\"solid\\\", \\\"dashed\\\", \\\"dotted\\\", \\\"thick\
\\\", \\\"thin\\\"\\n   - Colores disponibles: \\\"blue\\\", \\\"red\\\", \
\\\"green\\\", \\\"purple\\\", \\\"yellow\\\", \\\"orange\\\", \\\"cyan\\\", \
\\\"magenta\\\", \\\"black\\\"\\n\\nejes (OPCIONAL, por defecto: True)\\n   \
True|False - Controla la visualizaci\[OAcute]n de los ejes\\n   - True: Ejes \
centrados (axis lines=center)\\n   - False: Sin ejes (axis \
lines=none)\\n\\ntexto (OPCIONAL, por defecto: {})\\n   A\[NTilde]ade \
etiquetas de texto al gr\[AAcute]fico\\n   - Formato simple: {\\\"texto\\\", \
{x, y}}\\n   - Formato m\[UAcute]ltiple: {{\\\"texto1\\\", {x1, y1}}, \
{\\\"texto2\\\", {x2, y2}}, ...}\\n   - Las coordenadas son en el sistema de \
coordenadas del gr\[AAcute]fico\\n\\nxmin (OPCIONAL, por defecto: \
Automatic)\\n   Automatic|n\[UAcute]mero - L\[IAcute]mite inferior del eje \
x\\n   - Automatic: Calcula autom\[AAcute]ticamente basado en los datos \
generados\\n   - n\[UAcute]mero: Valor espec\[IAcute]fico para el \
l\[IAcute]mite inferior\\n\\nxmax (OPCIONAL, por defecto: Automatic)\\n   \
Automatic|n\[UAcute]mero - L\[IAcute]mite superior del eje x\\n   - \
Automatic: Calcula autom\[AAcute]ticamente basado en los datos generados\\n   \
- n\[UAcute]mero: Valor espec\[IAcute]fico para el l\[IAcute]mite superior\\n\
\\nymin (OPCIONAL, por defecto: Automatic)\\n   Automatic|n\[UAcute]mero - L\
\[IAcute]mite inferior del eje y\\n   - Automatic: Calcula \
autom\[AAcute]ticamente basado en los datos generados\\n   - n\[UAcute]mero: \
Valor espec\[IAcute]fico para el l\[IAcute]mite inferior\\n\\nymax (OPCIONAL, \
por defecto: Automatic)\\n   Automatic|n\[UAcute]mero - L\[IAcute]mite \
superior del eje y\\n   - Automatic: Calcula autom\[AAcute]ticamente basado \
en los datos generados\\n   - n\[UAcute]mero: Valor espec\[IAcute]fico para \
el l\[IAcute]mite superior\\n\\nEJEMPLOS DE USO:\\n\\nC\[IAcute]rculo simple \
(solo argumentos obligatorios):\\nExportConicsToTikZ[{{x^2 + y^2 == 4, {x, \
-3, 3}, {y, -3, 3}}}, \\\"circulo.tex\\\"]\\n\\nC\[IAcute]rculo con grilla \
desactivada:\\nExportConicsToTikZ[{{x^2 + y^2 == 4, {x, -3, 3}, {y, -3, 3}}}, \
\\\"circulo.tex\\\", False]\\n\\nM\[UAcute]ltiples c\[OAcute]nicas con \
estilos personalizados:\\nExportConicsToTikZ[{\\n  {x^2 + y^2 == 4, {x, -3, \
3}, {y, -3, 3}},\\n  {x^2/4 + y^2/9 == 1, {x, -3, 3}, {y, -4, 4}}\\n}, \
\\\"conicas.tex\\\", True, {{\\\"solid\\\", \\\"blue\\\"}, {\\\"dashed\\\", \
\\\"red\\\"}}]\\n\\nCon texto a\[NTilde]adido:\\nExportConicsToTikZ[{\\n  \
{x^2 + y^2 == 1, {x, -2, 2}, {y, -2, 2}}\\n}, \\\"ejemplo.tex\\\", True, {}, \
True, {{\\\"Centro\\\", {0, 0}}, {\\\"Radio = 1\\\", {1.2, 1.2}}}]\\n\\nCon l\
\[IAcute]mites personalizados completos:\\nExportConicsToTikZ[{\\n  {x^2/4 - \
y^2/9 == 1, {x, -6, 6}, {y, -8, 8}}\\n}, \\\"hiperbola.tex\\\", False, \
{{\\\"thick\\\", \\\"purple\\\"}}, True, \\n{\\\"Hip\[EAcute]rbola\\\", {0, \
6}}, -5, 5, -7, 7]\\n\\nUsando valores por defecto \
intermedios:\\nExportConicsToTikZ[{{x^2 + y^2 == 4, {x, -3, 3}, {y, -3, 3}}}, \
\\\"circulo.tex\\\", \\nTrue, {}, True, {}, -4]  (* Solo especifica xmin, los \
dem\[AAcute]s son Automatic *)\\n\\nCOMPORTAMIENTO:\\n\[Bullet] Los \
argumentos son posicionales, no opciones con nombres\\n\[Bullet] Si omites un \
argumento, se usa su valor por defecto\\n\[Bullet] Puedes especificar solo \
los primeros N argumentos que necesites\\n\[Bullet] Genera m\[EAcute]todos \
adaptativos para diferentes tipos de c\[OAcute]nicas\\n\[Bullet] \
C\[IAcute]rculos y elipses: M\[EAcute]todo param\[EAcute]trico para mayor \
precisi\[OAcute]n\\n\[Bullet] Hip\[EAcute]rbolas: Detecci\[OAcute]n autom\
\[AAcute]tica de ramas separadas\\n\[Bullet] Crea carpeta \
autom\[AAcute]ticamente en ~/Downloads/ con el nombre del archivo\\n\[Bullet] \
Genera documento LaTeX completo con paquetes necesarios (tikz, \
pgfplots)\\n\\nSALIDA:\\nRetorna la ruta completa del archivo .tex generado, \
listo para compilar con LaTeX.\\n\\nNOTAS:\\n\[Bullet] El archivo generado \
incluye todos los paquetes LaTeX necesarios\\n\[Bullet] Compatible con \
pgfplots versi\[OAcute]n 1.18\\n\[Bullet] Optimizado para curvas \
c\[OAcute]nicas\\n\[Bullet] Manejo autom\[AAcute]tico de puntos duplicados y \
ordenamiento inteligente\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}},
            ScrollPosition->{0., 0.}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "ExportConicsToTikZ[equations, filename, grid, styles, ejes, texto, xmin, \
xmax, ymin, ymax] exporta rectas y ecuaciones c\[OAcute]nicas sin \
t\[EAcute]rminos cruzados (c\[IAcute]rculos, elipses, par\[AAcute]bolas, hip\
\[EAcute]rbolas) a formato TikZ/LaTeX, generando un documento LaTeX completo \
listo para compilar. No acepta desigualdades.\n\nSINTAXIS:\n\
ExportConicsToTikZ[equations, filename]\nExportConicsToTikZ[equations, \
filename, grid]\nExportConicsToTikZ[equations, filename, grid, styles]\n\
ExportConicsToTikZ[equations, filename, grid, styles, ejes]\n\
ExportConicsToTikZ[equations, filename, grid, styles, ejes, texto]\n\
ExportConicsToTikZ[equations, filename, grid, styles, ejes, texto, xmin]\n\
ExportConicsToTikZ[equations, filename, grid, styles, ejes, texto, xmin, \
xmax]\nExportConicsToTikZ[equations, filename, grid, styles, ejes, texto, \
xmin, xmax, ymin]\nExportConicsToTikZ[equations, filename, grid, styles, \
ejes, texto, xmin, xmax, ymin, ymax]\n\nARGUMENTOS:\n\nequations \
(OBLIGATORIO)\n   Lista de ecuaciones en el formato {{ecuaci\[OAcute]n, \
{var_x, xmin_eq, xmax_eq}, {var_y, ymin_eq, ymax_eq}}, ...}\n   - ecuaci\
\[OAcute]n: Ecuaci\[OAcute]n c\[OAcute]nica (Equal, LessEqual, GreaterEqual, \
Less, Greater)\n   - var_x, var_y: Variables de las ecuaciones (ej. x, y)\n   \
- xmin_eq, xmax_eq, ymin_eq, ymax_eq: Rangos de evaluaci\[OAcute]n para cada \
ecuaci\[OAcute]n espec\[IAcute]fica\n\nfilename (OBLIGATORIO)\n   String \
terminado en '.tex' que especifica el nombre del archivo de salida\n\ngrid \
(OPCIONAL, por defecto: True)\n   True|False - Controla si se muestra la \
grilla en el gr\[AAcute]fico\n   - True: Muestra grilla mayor\n   - False: \
Sin grilla\n\nstyles (OPCIONAL, por defecto: {})\n   Lista de estilos para \
cada ecuaci\[OAcute]n en formato {{estilo1, color1}, {estilo2, color2}, ...}\n\
   - Si est\[AAcute] vac\[IAcute]a {}, usa estilo por defecto: {\"solid\", \
\"black\"} para todas las ecuaciones\n   - Estilos disponibles: \"solid\", \
\"dashed\", \"dotted\", \"thick\", \"thin\"\n   - Colores disponibles: \"blue\
\", \"red\", \"green\", \"purple\", \"yellow\", \"orange\", \"cyan\", \
\"magenta\", \"black\"\n\nejes (OPCIONAL, por defecto: True)\n   True|False - \
Controla la visualizaci\[OAcute]n de los ejes\n   - True: Ejes centrados \
(axis lines=center)\n   - False: Sin ejes (axis lines=none)\n\ntexto \
(OPCIONAL, por defecto: {})\n   A\[NTilde]ade etiquetas de texto al gr\
\[AAcute]fico\n   - Formato simple: {\"texto\", {x, y}}\n   - Formato m\
\[UAcute]ltiple: {{\"texto1\", {x1, y1}}, {\"texto2\", {x2, y2}}, ...}\n   - \
Las coordenadas son en el sistema de coordenadas del gr\[AAcute]fico\n\nxmin \
(OPCIONAL, por defecto: Automatic)\n   Automatic|n\[UAcute]mero - \
L\[IAcute]mite inferior del eje x\n   - Automatic: Calcula \
autom\[AAcute]ticamente basado en los datos generados\n   - n\[UAcute]mero: \
Valor espec\[IAcute]fico para el l\[IAcute]mite inferior\n\nxmax (OPCIONAL, \
por defecto: Automatic)\n   Automatic|n\[UAcute]mero - L\[IAcute]mite \
superior del eje x\n   - Automatic: Calcula autom\[AAcute]ticamente basado en \
los datos generados\n   - n\[UAcute]mero: Valor espec\[IAcute]fico para el l\
\[IAcute]mite superior\n\nymin (OPCIONAL, por defecto: Automatic)\n   \
Automatic|n\[UAcute]mero - L\[IAcute]mite inferior del eje y\n   - Automatic: \
Calcula autom\[AAcute]ticamente basado en los datos generados\n   - \
n\[UAcute]mero: Valor espec\[IAcute]fico para el l\[IAcute]mite inferior\n\n\
ymax (OPCIONAL, por defecto: Automatic)\n   Automatic|n\[UAcute]mero - L\
\[IAcute]mite superior del eje y\n   - Automatic: Calcula \
autom\[AAcute]ticamente basado en los datos generados\n   - n\[UAcute]mero: \
Valor espec\[IAcute]fico para el l\[IAcute]mite superior\n\nEJEMPLOS DE USO:\n\
\nC\[IAcute]rculo simple (solo argumentos obligatorios):\n\
ExportConicsToTikZ[{{x^2 + y^2 == 4, {x, -3, 3}, {y, -3, 3}}}, \
\"circulo.tex\"]\n\nC\[IAcute]rculo con grilla desactivada:\n\
ExportConicsToTikZ[{{x^2 + y^2 == 4, {x, -3, 3}, {y, -3, 3}}}, \
\"circulo.tex\", False]\n\nM\[UAcute]ltiples c\[OAcute]nicas con estilos \
personalizados:\nExportConicsToTikZ[{\n  {x^2 + y^2 == 4, {x, -3, 3}, {y, -3, \
3}},\n  {x^2/4 + y^2/9 == 1, {x, -3, 3}, {y, -4, 4}}\n}, \"conicas.tex\", \
True, {{\"solid\", \"blue\"}, {\"dashed\", \"red\"}}]\n\nCon texto \
a\[NTilde]adido:\nExportConicsToTikZ[{\n  {x^2 + y^2 == 1, {x, -2, 2}, {y, \
-2, 2}}\n}, \"ejemplo.tex\", True, {}, True, {{\"Centro\", {0, 0}}, {\"Radio \
= 1\", {1.2, 1.2}}}]\n\nCon l\[IAcute]mites personalizados completos:\n\
ExportConicsToTikZ[{\n  {x^2/4 - y^2/9 == 1, {x, -6, 6}, {y, -8, 8}}\n}, \
\"hiperbola.tex\", False, {{\"thick\", \"purple\"}}, True, \n\
{\"Hip\[EAcute]rbola\", {0, 6}}, -5, 5, -7, 7]\n\nUsando valores por defecto \
intermedios:\nExportConicsToTikZ[{{x^2 + y^2 == 4, {x, -3, 3}, {y, -3, 3}}}, \
\"circulo.tex\", \nTrue, {}, True, {}, -4]  (* Solo especifica xmin, los dem\
\[AAcute]s son Automatic *)\n\nCOMPORTAMIENTO:\n\[Bullet] Los argumentos son \
posicionales, no opciones con nombres\n\[Bullet] Si omites un argumento, se \
usa su valor por defecto\n\[Bullet] Puedes especificar solo los primeros N \
argumentos que necesites\n\[Bullet] Genera m\[EAcute]todos adaptativos para \
diferentes tipos de c\[OAcute]nicas\n\[Bullet] C\[IAcute]rculos y elipses: M\
\[EAcute]todo param\[EAcute]trico para mayor precisi\[OAcute]n\n\[Bullet] Hip\
\[EAcute]rbolas: Detecci\[OAcute]n autom\[AAcute]tica de ramas separadas\n\
\[Bullet] Crea carpeta autom\[AAcute]ticamente en ~/Downloads/ con el nombre \
del archivo\n\[Bullet] Genera documento LaTeX completo con paquetes \
necesarios (tikz, pgfplots)\n\nSALIDA:\nRetorna la ruta completa del archivo \
.tex generado, listo para compilar con LaTeX.\n\nNOTAS:\n\[Bullet] El archivo \
generado incluye todos los paquetes LaTeX necesarios\n\[Bullet] Compatible \
con pgfplots versi\[OAcute]n 1.18\n\[Bullet] Optimizado para curvas \
c\[OAcute]nicas\n\[Bullet] Manejo autom\[AAcute]tico de puntos duplicados y \
ordenamiento inteligente", "Documentation" -> None, "OwnValues" -> None, 
    "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilTeX`ExportConicsToTikZ, {VilTeX`ExportConicsToTikZ[
         Pattern[VilTeX`Private`equations, 
          Blank[]], 
         Pattern[VilTeX`Private`filename, 
          Blank[]], 
         Optional[
          Pattern[VilTeX`Private`grid, 
           Blank[]], True], 
         Optional[
          Pattern[VilTeX`Private`styles, 
           Blank[]], {}], 
         Optional[
          Pattern[VilTeX`Private`ejes, 
           Blank[]], True], 
         Optional[
          Pattern[VilTeX`Private`texto, 
           Blank[]], {}], 
         Optional[
          Pattern[VilTeX`Private`xmin, 
           Blank[]], Automatic], 
         Optional[
          Pattern[VilTeX`Private`xmax, 
           Blank[]], Automatic], 
         Optional[
          Pattern[VilTeX`Private`ymin, 
           Blank[]], Automatic], 
         Optional[
          Pattern[VilTeX`Private`ymax, 
           Blank[]], Automatic]] :> 
       Module[{VilTeX`Private`data = {}, VilTeX`Private`tikzLines, 
          VilTeX`Private`fullDocument, VilTeX`Private`downloadPath, 
          VilTeX`Private`folderName, VilTeX`Private`folderPath, 
          VilTeX`Private`xminFinal, VilTeX`Private`xmaxFinal, 
          VilTeX`Private`yminFinal, VilTeX`Private`ymaxFinal, 
          VilTeX`Private`formatNumber, VilTeX`Private`allPoints, 
          VilTeX`Private`processedStyles}, 
         Clear[VilTeX`Private`generarPuntosCirculoElipse, 
           VilTeX`Private`SymbolQ]; If[
           Or[
            Not[
             ListQ[VilTeX`Private`equations]], 
            Length[VilTeX`Private`equations] == 0], 
           Print["Error: Se requiere una lista de ecuaciones."]; 
           Return[$Failed]]; If[
           Or[
            Not[
             StringQ[VilTeX`Private`filename]], 
            Not[
             StringEndsQ[VilTeX`Private`filename, ".tex"]]], 
           Print["Error: filename debe ser un string terminado en .tex"]; 
           Return[$Failed]]; 
         Module[{VilTeX`Private`validacionCompleta = True}, Do[
             
             Module[{VilTeX`Private`ecuacionEntry}, 
              VilTeX`Private`ecuacionEntry = 
               Part[VilTeX`Private`equations, VilTeX`Private`i]; If[
                Or[
                 Not[
                  ListQ[VilTeX`Private`ecuacionEntry]], 
                 Length[VilTeX`Private`ecuacionEntry] != 3], 
                Print["Error en entrada " <> ToString[VilTeX`Private`i] <> 
                  ": Debe ser una lista de 3 elementos. Formato: {ecuaci\
\[OAcute]n, {x, xmin, xmax}, {y, ymin, ymax}}"]; 
                VilTeX`Private`validacionCompleta = False; Break[]]; 
              Module[{VilTeX`Private`rangoX, VilTeX`Private`rangoY}, 
                VilTeX`Private`rangoX = Part[VilTeX`Private`ecuacionEntry, 2]; 
                VilTeX`Private`rangoY = Part[VilTeX`Private`ecuacionEntry, 3]; 
                If[
                  Or[
                   Not[
                    ListQ[VilTeX`Private`rangoX]], 
                   Length[VilTeX`Private`rangoX] != 3], 
                  Print["Error en entrada " <> ToString[VilTeX`Private`i] <> 
                    ": El rango de x debe ser una lista de 3 elementos {x, \
xmin, xmax}"]; VilTeX`Private`validacionCompleta = False; Break[]]; If[
                  Or[
                   Not[
                    ListQ[VilTeX`Private`rangoY]], 
                   Length[VilTeX`Private`rangoY] != 3], 
                  Print["Error en entrada " <> ToString[VilTeX`Private`i] <> 
                    ": El rango de y debe ser una lista de 3 elementos {y, \
ymin, ymax}"]; VilTeX`Private`validacionCompleta = False; Break[]]; If[
                  Not[
                   VilTeX`Private`SymbolQ[
                    Part[VilTeX`Private`rangoX, 1]]], 
                  Print["Error en entrada " <> ToString[VilTeX`Private`i] <> 
                    ": La variable x debe ser un s\[IAcute]mbolo \
v\[AAcute]lido"]; VilTeX`Private`validacionCompleta = False; Break[]]; If[
                  Not[
                   VilTeX`Private`SymbolQ[
                    Part[VilTeX`Private`rangoY, 1]]], 
                  Print["Error en entrada " <> ToString[VilTeX`Private`i] <> 
                    ": La variable y debe ser un s\[IAcute]mbolo \
v\[AAcute]lido"]; VilTeX`Private`validacionCompleta = False; Break[]]; If[
                  Or[
                   Not[
                    NumericQ[
                    Part[VilTeX`Private`rangoX, 2]]], 
                   Not[
                    NumericQ[
                    Part[VilTeX`Private`rangoX, 3]]]], 
                  Print["Error en entrada " <> ToString[VilTeX`Private`i] <> 
                    ": xmin y xmax deben ser valores num\[EAcute]ricos"]; 
                  VilTeX`Private`validacionCompleta = False; Break[]]; If[
                  Or[
                   Not[
                    NumericQ[
                    Part[VilTeX`Private`rangoY, 2]]], 
                   Not[
                    NumericQ[
                    Part[VilTeX`Private`rangoY, 3]]]], 
                  Print["Error en entrada " <> ToString[VilTeX`Private`i] <> 
                    ": ymin y ymax deben ser valores num\[EAcute]ricos"]; 
                  VilTeX`Private`validacionCompleta = False; Break[]]; 
                If[Part[VilTeX`Private`rangoX, 2] >= 
                  Part[VilTeX`Private`rangoX, 3], 
                  Print["Error en entrada " <> ToString[VilTeX`Private`i] <> 
                    ": xmin debe ser menor que xmax"]; 
                  VilTeX`Private`validacionCompleta = False; Break[]]; 
                If[Part[VilTeX`Private`rangoY, 2] >= 
                  Part[VilTeX`Private`rangoY, 3], 
                  Print["Error en entrada " <> ToString[VilTeX`Private`i] <> 
                    ": ymin debe ser menor que ymax"]; 
                  VilTeX`Private`validacionCompleta = False; Break[]]; Null]; 
              Null], {VilTeX`Private`i, 
              Length[VilTeX`Private`equations]}]; If[
             Not[VilTeX`Private`validacionCompleta], 
             Return[$Failed]]; Null]; 
         Module[{VilTeX`Private`validacionConica = True}, Do[
             
             Module[{VilTeX`Private`eq, VilTeX`Private`xvar, 
               VilTeX`Private`yvar, VilTeX`Private`xminEq, 
               VilTeX`Private`xmaxEq, VilTeX`Private`yminEq, 
               VilTeX`Private`ymaxEq, VilTeX`Private`expanded, 
               VilTeX`Private`coeffs, VilTeX`Private`dims, 
               VilTeX`Private`hasXYterm, 
               VilTeX`Private`degree}, {
                VilTeX`Private`eq, {
                 VilTeX`Private`xvar, VilTeX`Private`xminEq, 
                  VilTeX`Private`xmaxEq}, {
                 VilTeX`Private`yvar, VilTeX`Private`yminEq, 
                  VilTeX`Private`ymaxEq}} = 
               Part[VilTeX`Private`equations, VilTeX`Private`i]; 
              If[Head[VilTeX`Private`eq] =!= Equal, 
                Print["Error en ecuaci\[OAcute]n " <> 
                  ToString[VilTeX`Private`i] <> 
                  ": Solo se aceptan ecuaciones (=), no desigualdades."]; 
                VilTeX`Private`validacionConica = False; Break[]]; 
              VilTeX`Private`expanded = Expand[
                 ReplaceAll[VilTeX`Private`eq, Equal -> Subtract]]; 
              Module[{VilTeX`Private`vars = 
                 Variables[VilTeX`Private`expanded]}, 
                If[
                 Not[
                  
                  SubsetQ[{VilTeX`Private`xvar, VilTeX`Private`yvar}, 
                   VilTeX`Private`vars]], 
                 Print["Error en ecuaci\[OAcute]n " <> 
                   ToString[VilTeX`Private`i] <> 
                   ": La ecuaci\[OAcute]n contiene variables no declaradas (" <> 
                   ToString[
                    Complement[
                    VilTeX`Private`vars, {
                    VilTeX`Private`xvar, VilTeX`Private`yvar}]] <> 
                   "). Solo se permiten " <> ToString[VilTeX`Private`xvar] <> 
                   " y " <> ToString[VilTeX`Private`yvar] <> "."]; 
                 VilTeX`Private`validacionConica = False; Break[]]]; 
              VilTeX`Private`coeffs = 
               CoefficientList[
                VilTeX`Private`expanded, {
                 VilTeX`Private`xvar, VilTeX`Private`yvar}]; 
              VilTeX`Private`dims = Dimensions[VilTeX`Private`coeffs]; 
              VilTeX`Private`hasXYterm = False; If[
                And[
                Part[VilTeX`Private`dims, 1] >= 2, 
                 Part[VilTeX`Private`dims, 2] >= 2], 
                If[
                Part[VilTeX`Private`coeffs, 2, 2] =!= 0, 
                 VilTeX`Private`hasXYterm = True]]; 
              If[VilTeX`Private`hasXYterm, 
                Print["Error en ecuaci\[OAcute]n " <> 
                  ToString[VilTeX`Private`i] <> 
                  ": No se permiten t\[EAcute]rminos cruzados (" <> 
                  ToString[VilTeX`Private`xvar] <> "*" <> 
                  ToString[VilTeX`Private`yvar] <> ")."]; 
                VilTeX`Private`validacionConica = False; Break[]]; 
              VilTeX`Private`degree = Max[VilTeX`Private`dims] - 1; 
              If[VilTeX`Private`degree > 2, 
                Print["Error en ecuaci\[OAcute]n " <> 
                  ToString[VilTeX`Private`i] <> 
                  ": El grado m\[AAcute]ximo permitido es 2 (c\[OAcute]nicas \
y rectas). Grado encontrado: " <> ToString[VilTeX`Private`degree] <> "."]; 
                VilTeX`Private`validacionConica = False; Break[]]; 
              Module[{VilTeX`Private`a, VilTeX`Private`b, VilTeX`Private`c, 
                 VilTeX`Private`d, VilTeX`Private`e}, 
                VilTeX`Private`e = Part[VilTeX`Private`coeffs, 1, 1]; 
                VilTeX`Private`c = If[Part[VilTeX`Private`dims, 1] > 1, 
                   Part[VilTeX`Private`coeffs, 2, 1], 0]; 
                VilTeX`Private`d = If[Part[VilTeX`Private`dims, 2] > 1, 
                   Part[VilTeX`Private`coeffs, 1, 2], 0]; 
                VilTeX`Private`a = If[Part[VilTeX`Private`dims, 1] > 2, 
                   Part[VilTeX`Private`coeffs, 3, 1], 0]; 
                VilTeX`Private`b = If[Part[VilTeX`Private`dims, 2] > 2, 
                   Part[VilTeX`Private`coeffs, 1, 3], 0]; If[
                  And[
                  VilTeX`Private`a == 0, VilTeX`Private`b == 0, 
                   VilTeX`Private`c == 0, VilTeX`Private`d == 0], 
                  Print["Error en ecuaci\[OAcute]n " <> 
                    ToString[VilTeX`Private`i] <> 
                    ": Ecuaci\[OAcute]n degenerada (solo constante)."]; 
                  VilTeX`Private`validacionConica = False; Break[]]; Null]; 
              Null], {VilTeX`Private`i, 
              Length[VilTeX`Private`equations]}]; If[
             Not[VilTeX`Private`validacionConica], 
             Return[$Failed]]; Null]; VilTeX`Private`formatNumber[
            Pattern[VilTeX`Private`x, 
             Blank[]]] := ToString[
            Round[
             N[VilTeX`Private`x], 0.001]]; 
         VilTeX`Private`generarPuntosCirculoElipse[
            Pattern[VilTeX`Private`eq, 
             Blank[]], 
            Pattern[VilTeX`Private`xvar, 
             Blank[]], 
            Pattern[VilTeX`Private`yvar, 
             Blank[]], 
            Pattern[VilTeX`Private`xminEq, 
             Blank[]], 
            Pattern[VilTeX`Private`xmaxEq, 
             Blank[]], 
            Pattern[VilTeX`Private`yminEq, 
             Blank[]], 
            Pattern[VilTeX`Private`ymaxEq, 
             Blank[]]] := 
          Module[{VilTeX`Private`expanded, VilTeX`Private`coeffs, 
             VilTeX`Private`dims, VilTeX`Private`a, VilTeX`Private`b, 
             VilTeX`Private`c, VilTeX`Private`d, VilTeX`Private`e, 
             VilTeX`Private`h, VilTeX`Private`k, VilTeX`Private`rx, 
             VilTeX`Private`ry, VilTeX`Private`points = {}, VilTeX`Private`t, 
             VilTeX`Private`xVal, VilTeX`Private`yVal, VilTeX`Private`success = 
             False}, VilTeX`Private`expanded = Expand[
               ReplaceAll[VilTeX`Private`eq, Equal -> Subtract]]; 
            VilTeX`Private`coeffs = 
             CoefficientList[
              VilTeX`Private`expanded, {
               VilTeX`Private`xvar, VilTeX`Private`yvar}]; 
            VilTeX`Private`dims = Dimensions[VilTeX`Private`coeffs]; 
            VilTeX`Private`e = Part[VilTeX`Private`coeffs, 1, 1]; 
            VilTeX`Private`c = If[Part[VilTeX`Private`dims, 1] > 1, 
               Part[VilTeX`Private`coeffs, 2, 1], 0]; 
            VilTeX`Private`d = If[Part[VilTeX`Private`dims, 2] > 1, 
               Part[VilTeX`Private`coeffs, 1, 2], 0]; 
            VilTeX`Private`a = If[Part[VilTeX`Private`dims, 1] > 2, 
               Part[VilTeX`Private`coeffs, 3, 1], 0]; 
            VilTeX`Private`b = If[Part[VilTeX`Private`dims, 2] > 2, 
               Part[VilTeX`Private`coeffs, 1, 3], 0]; If[
              And[
               NumericQ[VilTeX`Private`a], 
               NumericQ[VilTeX`Private`b], VilTeX`Private`a > 0, 
               VilTeX`Private`b > 0], 
              VilTeX`Private`h = (-VilTeX`Private`c)/(2 VilTeX`Private`a); 
              VilTeX`Private`k = (-VilTeX`Private`d)/(2 VilTeX`Private`b); 
              Module[{VilTeX`Private`discriminant = 
                 VilTeX`Private`h^2 VilTeX`Private`a + 
                  VilTeX`Private`k^2 VilTeX`Private`b - VilTeX`Private`e}, 
                If[VilTeX`Private`discriminant > 0, 
                  VilTeX`Private`rx = 
                   Sqrt[VilTeX`Private`discriminant/VilTeX`Private`a]; 
                  VilTeX`Private`ry = 
                   Sqrt[VilTeX`Private`discriminant/VilTeX`Private`b]; If[
                    And[
                    NumericQ[VilTeX`Private`h], 
                    NumericQ[VilTeX`Private`k], 
                    NumericQ[VilTeX`Private`rx], 
                    NumericQ[VilTeX`Private`ry], VilTeX`Private`rx > 0, 
                    VilTeX`Private`ry > 0, VilTeX`Private`rx < 50, 
                    VilTeX`Private`ry < 50], VilTeX`Private`success = True; 
                    Do[VilTeX`Private`xVal = 
                    VilTeX`Private`h + 
                    VilTeX`Private`rx Cos[VilTeX`Private`t]; 
                    VilTeX`Private`yVal = 
                    VilTeX`Private`k + 
                    VilTeX`Private`ry Sin[VilTeX`Private`t]; If[
                    And[
                    VilTeX`Private`xminEq <= VilTeX`Private`xVal <= 
                    VilTeX`Private`xmaxEq, VilTeX`Private`yminEq <= 
                    VilTeX`Private`yVal <= VilTeX`Private`ymaxEq], 
                    AppendTo[VilTeX`Private`points, {
                    N[VilTeX`Private`xVal], 
                    N[VilTeX`Private`yVal]}]; Null], {
                    VilTeX`Private`t, 0, 2 Pi, Pi/150}]; Null]; Null]; Null]; 
              Null]; VilTeX`Private`points]; Do[
           
           Module[{VilTeX`Private`eq, VilTeX`Private`xvar, 
             VilTeX`Private`xminEq, VilTeX`Private`xmaxEq, 
             VilTeX`Private`yvar, VilTeX`Private`yminEq, 
             VilTeX`Private`ymaxEq, 
             VilTeX`Private`points}, {
              VilTeX`Private`eq, {
               VilTeX`Private`xvar, VilTeX`Private`xminEq, 
                VilTeX`Private`xmaxEq}, {
               VilTeX`Private`yvar, VilTeX`Private`yminEq, 
                VilTeX`Private`ymaxEq}} = 
             Part[VilTeX`Private`equations, VilTeX`Private`i]; 
            VilTeX`Private`points = {}; 
            Module[{VilTeX`Private`usedParametricMethod = False}, 
              VilTeX`Private`points = 
               VilTeX`Private`generarPuntosCirculoElipse[
                VilTeX`Private`eq, VilTeX`Private`xvar, VilTeX`Private`yvar, 
                 VilTeX`Private`xminEq, VilTeX`Private`xmaxEq, 
                 VilTeX`Private`yminEq, VilTeX`Private`ymaxEq]; 
              If[Length[VilTeX`Private`points] >= 50, 
                VilTeX`Private`usedParametricMethod = True]; 
              If[Length[VilTeX`Private`points] < 50, 
                VilTeX`Private`points = {}; Do[
                  Module[{VilTeX`Private`sols = Quiet[
                    Solve[
                    ReplaceAll[
                    VilTeX`Private`eq, {
                    VilTeX`Private`xvar -> VilTeX`Private`xVal}], 
                    VilTeX`Private`yvar, Reals]]}, If[
                    And[
                    VilTeX`Private`sols =!= {}, 
                    VilTeX`Private`sols =!= $Failed], Do[
                    
                    Module[{
                    VilTeX`Private`yVal = ReplaceAll[VilTeX`Private`yvar, 
                    Part[VilTeX`Private`sols, VilTeX`Private`j]]}, 
                    If[
                    And[
                    NumericQ[VilTeX`Private`yVal], VilTeX`Private`yminEq <= 
                    VilTeX`Private`yVal <= VilTeX`Private`ymaxEq], 
                    AppendTo[VilTeX`Private`points, {
                    N[VilTeX`Private`xVal], 
                    N[VilTeX`Private`yVal]}]; Null]], {VilTeX`Private`j, 
                    Length[VilTeX`Private`sols]}]; Null]; Null], {
                  VilTeX`Private`xVal, VilTeX`Private`xminEq, 
                   VilTeX`Private`xmaxEq, (VilTeX`Private`xmaxEq - 
                    VilTeX`Private`xminEq)/200}]; Null]; 
              If[Length[VilTeX`Private`points] > 0, 
                VilTeX`Private`points = 
                 DeleteDuplicates[
                  VilTeX`Private`points, Norm[# - #2] < 0.01& ]; 
                If[VilTeX`Private`usedParametricMethod, 
                  Module[{
                    VilTeX`Private`center = Mean[VilTeX`Private`points], 
                    VilTeX`Private`sortedPoints}, 
                    VilTeX`Private`sortedPoints = 
                    SortBy[VilTeX`Private`points, ArcTan[
                    Part[#, 1] - Part[VilTeX`Private`center, 1], Part[#, 2] - 
                    Part[VilTeX`Private`center, 2]]& ]; 
                    VilTeX`Private`sortedPoints = 
                    Append[VilTeX`Private`sortedPoints, 
                    First[VilTeX`Private`sortedPoints]]; 
                    AppendTo[
                    VilTeX`Private`data, {
                    "line", VilTeX`Private`sortedPoints, VilTeX`Private`i}]; 
                    Null]; Null, 
                  Module[{
                    VilTeX`Private`center, VilTeX`Private`sortedPoints, 
                    VilTeX`Private`isCircleElipse}, 
                    VilTeX`Private`isCircleElipse = 
                    And[Length[VilTeX`Private`points] > 100, 
                    Norm[First[VilTeX`Private`points] - Last[
                    VilTeX`Private`points]] < 1.]; 
                    If[VilTeX`Private`isCircleElipse, 
                    VilTeX`Private`center = Mean[VilTeX`Private`points]; 
                    VilTeX`Private`sortedPoints = 
                    SortBy[VilTeX`Private`points, ArcTan[
                    Part[#, 1] - Part[VilTeX`Private`center, 1], Part[#, 2] - 
                    Part[VilTeX`Private`center, 2]]& ]; 
                    VilTeX`Private`sortedPoints = 
                    Append[VilTeX`Private`sortedPoints, 
                    First[VilTeX`Private`sortedPoints]]; 
                    AppendTo[
                    VilTeX`Private`data, {
                    "line", VilTeX`Private`sortedPoints, VilTeX`Private`i}]; 
                    Null, Module[{
                    VilTeX`Private`leftPoints = {}, 
                    VilTeX`Private`rightPoints = {}, VilTeX`Private`centerX}, 
                    If[Length[VilTeX`Private`points] > 20, 
                    VilTeX`Private`centerX = Mean[
                    Part[VilTeX`Private`points, All, 1]]; Do[
                    If[Part[VilTeX`Private`pt, 1] < VilTeX`Private`centerX, 
                    AppendTo[VilTeX`Private`leftPoints, VilTeX`Private`pt], 
                    AppendTo[
                    VilTeX`Private`rightPoints, VilTeX`Private`pt]], {
                    VilTeX`Private`pt, VilTeX`Private`points}]; If[
                    And[
                    Length[VilTeX`Private`leftPoints] > 10, 
                    Length[VilTeX`Private`rightPoints] > 10, Min[
                    Part[VilTeX`Private`rightPoints, All, 1]] - Max[
                    Part[VilTeX`Private`leftPoints, All, 1]] > 0.5], 
                    If[Length[VilTeX`Private`leftPoints] > 3, 
                    AppendTo[VilTeX`Private`data, {"line", 
                    SortBy[VilTeX`Private`leftPoints, Last], 
                    VilTeX`Private`i}]; Null]; 
                    If[Length[VilTeX`Private`rightPoints] > 3, 
                    AppendTo[VilTeX`Private`data, {"line", 
                    SortBy[VilTeX`Private`rightPoints, Last], 
                    VilTeX`Private`i}]; Null]; Null, 
                    AppendTo[VilTeX`Private`data, {"line", 
                    SortBy[VilTeX`Private`points, First], VilTeX`Private`i}]; 
                    Null]; Null, AppendTo[VilTeX`Private`data, {"line", 
                    SortBy[VilTeX`Private`points, First], VilTeX`Private`i}]; 
                    Null]; Null]; Null]; Null]; Null]; Null]; Null]; Null], {
           VilTeX`Private`i, 
            Length[VilTeX`Private`equations]}]; 
         VilTeX`Private`processedStyles = 
          If[Length[VilTeX`Private`styles] == 0, 
            Table[{"solid", "black"}, {
              Length[VilTeX`Private`equations]}], 
            Table[
             If[
              And[VilTeX`Private`i <= Length[VilTeX`Private`styles], 
               ListQ[
                Part[VilTeX`Private`styles, VilTeX`Private`i]], Length[
                 Part[VilTeX`Private`styles, VilTeX`Private`i]] >= 2], 
              Part[VilTeX`Private`styles, VilTeX`Private`i], {
              "solid", "black"}], {VilTeX`Private`i, 
              Length[VilTeX`Private`equations]}]]; 
         If[Length[VilTeX`Private`data] > 0, 
           VilTeX`Private`allPoints = Flatten[
              Part[VilTeX`Private`data, All, 2], 1]; 
           VilTeX`Private`xminFinal = 
            If[VilTeX`Private`xmin === Automatic, Min[
                Part[VilTeX`Private`allPoints, All, 1]] - 0.5, 
              VilTeX`Private`xmin]; 
           VilTeX`Private`xmaxFinal = 
            If[VilTeX`Private`xmax === Automatic, Max[
                Part[VilTeX`Private`allPoints, All, 1]] + 0.5, 
              VilTeX`Private`xmax]; 
           VilTeX`Private`yminFinal = 
            If[VilTeX`Private`ymin === Automatic, Min[
                Part[VilTeX`Private`allPoints, All, 2]] - 0.5, 
              VilTeX`Private`ymin]; 
           VilTeX`Private`ymaxFinal = 
            If[VilTeX`Private`ymax === Automatic, Max[
                Part[VilTeX`Private`allPoints, All, 2]] + 0.5, 
              VilTeX`Private`ymax]; 
           Null, {VilTeX`Private`xminFinal, VilTeX`Private`xmaxFinal, 
              VilTeX`Private`yminFinal, VilTeX`Private`ymaxFinal} = {-5, 
             5, -5, 5}; Null]; VilTeX`Private`tikzLines = {}; 
         AppendTo[VilTeX`Private`tikzLines, "\\begin{tikzpicture}"]; 
         AppendTo[VilTeX`Private`tikzLines, "\\begin{axis}["]; 
         AppendTo[VilTeX`Private`tikzLines, "  xlabel={$x$},"]; 
         AppendTo[VilTeX`Private`tikzLines, "  ylabel={$y$},"]; 
         AppendTo[
          VilTeX`Private`tikzLines, "  xmin=" <> 
           VilTeX`Private`formatNumber[VilTeX`Private`xminFinal] <> ","]; 
         AppendTo[
          VilTeX`Private`tikzLines, "  xmax=" <> 
           VilTeX`Private`formatNumber[VilTeX`Private`xmaxFinal] <> ","]; 
         AppendTo[
          VilTeX`Private`tikzLines, "  ymin=" <> 
           VilTeX`Private`formatNumber[VilTeX`Private`yminFinal] <> ","]; 
         AppendTo[
          VilTeX`Private`tikzLines, "  ymax=" <> 
           VilTeX`Private`formatNumber[VilTeX`Private`ymaxFinal] <> ","]; 
         If[VilTeX`Private`grid, 
           AppendTo[VilTeX`Private`tikzLines, "  grid=major,"]]; 
         If[VilTeX`Private`ejes, 
           AppendTo[VilTeX`Private`tikzLines, "  axis lines=center,"], 
           AppendTo[VilTeX`Private`tikzLines, "  axis lines=none,"]]; 
         AppendTo[VilTeX`Private`tikzLines, "  width=10cm,"]; 
         AppendTo[VilTeX`Private`tikzLines, "  height=8cm"]; 
         AppendTo[VilTeX`Private`tikzLines, "]"]; Do[
           
           Module[{VilTeX`Private`dataType, VilTeX`Private`pts, 
             VilTeX`Private`equationIndex, VilTeX`Private`style, 
             VilTeX`Private`color, VilTeX`Private`coordStr, 
             VilTeX`Private`styleStr, VilTeX`Private`colorStr, 
             VilTeX`Private`tikzStyleOptions}, {
              VilTeX`Private`dataType, VilTeX`Private`pts, 
               VilTeX`Private`equationIndex} = 
             Part[VilTeX`Private`data, VilTeX`Private`i]; {
              VilTeX`Private`style, VilTeX`Private`color} = If[
               And[
               VilTeX`Private`equationIndex <= 
                Length[VilTeX`Private`processedStyles], 
                ListQ[
                 Part[
                 VilTeX`Private`processedStyles, 
                  VilTeX`Private`equationIndex]], Length[
                  Part[
                  VilTeX`Private`processedStyles, 
                   VilTeX`Private`equationIndex]] >= 2], 
               Part[
               VilTeX`Private`processedStyles, 
                VilTeX`Private`equationIndex], {"solid", "black"}]; 
            VilTeX`Private`styleStr = ToString[VilTeX`Private`style]; 
            VilTeX`Private`colorStr = ToString[VilTeX`Private`color]; 
            VilTeX`Private`colorStr = Switch[
               ToLowerCase[VilTeX`Private`colorStr], "blue", "blue", "red", 
               "red", "green", "green", "purple", "violet", "yellow", 
               "yellow", "orange", "orange", "cyan", "cyan", "magenta", 
               "magenta", 
               Blank[], "black"]; VilTeX`Private`tikzStyleOptions = Switch[
               ToLowerCase[VilTeX`Private`styleStr], "dashed", ", dashed", 
               "dotted", ", dotted", "thick", ", very thick", "thin", 
               ", thin", 
               Blank[], ""]; VilTeX`Private`coordStr = StringJoin[
               Riffle[
                Table["  (" <> VilTeX`Private`formatNumber[
                   Part[VilTeX`Private`pt, 1]] <> "," <> 
                 VilTeX`Private`formatNumber[
                   Part[VilTeX`Private`pt, 2]] <> ")", {
                 VilTeX`Private`pt, VilTeX`Private`pts}], "\n"]]; 
            AppendTo[
             VilTeX`Private`tikzLines, "\\addplot[" <> 
              VilTeX`Private`colorStr <> ", thick" <> 
              VilTeX`Private`tikzStyleOptions <> "] coordinates {"]; 
            AppendTo[VilTeX`Private`tikzLines, VilTeX`Private`coordStr]; 
            AppendTo[VilTeX`Private`tikzLines, "};"]; Null], {
           VilTeX`Private`i, 
            Length[VilTeX`Private`data]}]; 
         If[Length[VilTeX`Private`texto] > 0, 
           Module[{VilTeX`Private`textoEntries = If[
                ListQ[
                 Part[VilTeX`Private`texto, 1]], VilTeX`Private`texto, {
                VilTeX`Private`texto}]}, Do[
               Module[{
                VilTeX`Private`textoStr, 
                 VilTeX`Private`coordenadas}, {
                  VilTeX`Private`textoStr, VilTeX`Private`coordenadas} = 
                 Part[VilTeX`Private`textoEntries, VilTeX`Private`i]; 
                AppendTo[
                 VilTeX`Private`tikzLines, "\\node at (axis cs:" <> 
                  VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`coordenadas, 1]] <> "," <> 
                  VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`coordenadas, 2]] <> ") {" <> 
                  ToString[VilTeX`Private`textoStr] <> "};"]; Null], {
               VilTeX`Private`i, 
                Length[VilTeX`Private`textoEntries]}]; Null]; Null]; 
         AppendTo[VilTeX`Private`tikzLines, "\\end{axis}"]; 
         AppendTo[VilTeX`Private`tikzLines, "\\end{tikzpicture}"]; 
         VilTeX`Private`fullDocument = 
          StringJoin[{
            "\\documentclass[border=5mm]{standalone}\n", 
             "\\usepackage{tikz}\n", "\\usepackage{pgfplots}\n", 
             "\\usepackage{amsmath}\n", "\\pgfplotsset{compat=1.18}\n\n", 
             "\\begin{document}\n", 
             StringRiffle[VilTeX`Private`tikzLines, "\n"], 
             "\n\\end{document}"}]; 
         VilTeX`Private`folderName = FileBaseName[VilTeX`Private`filename]; 
         VilTeX`Private`folderPath = 
          FileNameJoin[{$HomeDirectory, "Downloads", 
             VilTeX`Private`folderName}]; If[
           Not[
            DirectoryQ[VilTeX`Private`folderPath]], 
           CreateDirectory[VilTeX`Private`folderPath]]; 
         VilTeX`Private`downloadPath = 
          FileNameJoin[{VilTeX`Private`folderPath, VilTeX`Private`filename}]; 
         Export[VilTeX`Private`downloadPath, VilTeX`Private`fullDocument, 
           "Text"]; VilTeX`Private`downloadPath]}], "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {Protected}, "FullName" -> 
    "VilTeX`ExportConicsToTikZ"|>, False]]], "Output",
 CellChangeTimes->{3.9672972576731663`*^9, 3.967458290165004*^9, 
  3.96745871650187*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"5bf1ce74-a78b-4b02-a18f-9b0bc8c1b001"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 1: rectas y par\[AAcute]bola", "Subsection",
 CellChangeTimes->{{3.967295680579814*^9, 3.967295688242674*^9}, {
   3.967297180677174*^9, 3.967297185314023*^9}, 3.967458938765065*^9, {
   3.967459008276498*^9, 3.9674590134962063`*^9}, {3.967459575508655*^9, 
   3.967459577847847*^9}, {3.9674627592467318`*^9, 
   3.967462768787777*^9}},ExpressionUUID->"4990730b-335b-4741-81a6-\
e9c19d533e3a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"y", "==", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "-", "3"}], ")"}], "^", "2"}], "-", "2"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "3"}], ",", "9"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"y", "==", 
       RowBox[{
        RowBox[{"2", "*", "x"}], "-", "5"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "3"}], ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"y", "==", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "0.5"}], "*", "x"}], "+", "1"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "3"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"PlotStyle", "->", "All"}]}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", "True"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "3"}], "]"}]}]}], "}"}],
     "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", "True"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Par\[AAcute]bola\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "3"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<Recta 1\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"5", ",", "4"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<Recta 2\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "0"}], "}"}]}], "}"}]}], "}"}]}]}], "}"}], 
    "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", 
       RowBox[{"-", "2"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "7"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", 
       RowBox[{"-", "4"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "10"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportConicsToTikZ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y", "==", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"x", "-", "3"}], ")"}], "^", "2"}], "-", "2"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "7"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "3"}], ",", "9"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y", "==", 
         RowBox[{
          RowBox[{"2", "*", "x"}], "-", "5"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "7"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "3"}], ",", "10"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y", "==", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "0.5"}], "*", "x"}], "+", "1"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "3"}], ",", "5"}], "}"}]}], "}"}]}], "}"}], 
    ",", "\"\<conicas1.tex\>\"", ",", "grid", ",", "estilos", ",", "ejes", ",",
     "texto", ",", "xmin", ",", "xmax", ",", "ymin", ",", "ymax"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967458949134716*^9, 3.967459027720326*^9}, {
   3.967459071759989*^9, 3.9674590970531263`*^9}, {3.9674594354664183`*^9, 
   3.967459437241929*^9}, {3.967459508130843*^9, 3.967459508712741*^9}, {
   3.9674595408130283`*^9, 3.967459548251939*^9}, {3.967459585390415*^9, 
   3.967459604549168*^9}, {3.9674596658040037`*^9, 3.96745967875946*^9}, {
   3.967459741950267*^9, 3.9674597424546623`*^9}, {3.9674598092151203`*^9, 
   3.967459818772814*^9}, {3.9674598852880297`*^9, 3.96745993122128*^9}, {
   3.9674599822112093`*^9, 3.967459999188642*^9}, {3.96746004716756*^9, 
   3.967460061048337*^9}, 3.967460111844652*^9, {3.967460144021962*^9, 
   3.967460165860093*^9}, {3.967460472391869*^9, 3.9674604860265923`*^9}, {
   3.967461499809793*^9, 3.967461500199552*^9}, {3.967461786544467*^9, 
   3.967461787098959*^9}, {3.9674622786670933`*^9, 3.967462523304508*^9}, {
   3.9674625573065166`*^9, 3.96746271564194*^9}, {3.9674735591670628`*^9, 
   3.9674735594492607`*^9}, {3.967473839591363*^9, 3.967473840251309*^9}, 
   3.970593777977022*^9},ExpressionUUID->"28fa47aa-4e40-421c-8947-\
d4387ce41d48"],

Cell[BoxData[
 GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJxVVwlYU8cWTsIWdkMgCSJLWkGgamtbwQplDtCqoLQ+5CGCuFvpokBbrGJF
FLSWTSpbtX2igkLV+FyAovI6gEurkVLcUgkCWhBQ0bDEsCbvkjuT73PuyXe/
yZz7nzNzZs75R7omPnw9j8PhdDK/iferbQqcq7Ya6kg4gJqrNiqrNjpB3dGs
1CX5R9DezPveibOcYJGw/dTWeeeR36Yjd8z8JsN8377k8MfVaEJbWeUILE4t
0r8mOcKqxJR4385aZHftk8DKLgn0TM78fPrpOvRhlmTWmisSqFplycg1Vp8j
AU7et56yFX8gr8mP9sUUiSFydGHvm5WN6FZpSJ5HmAjqx+R4TN6I9k8NYUQE
JRXJD1/7uxGhTbGt3PkiYv8vFg9EcCjuQoom8RbSu7fRAQJO/J1w9/pt1Ogj
XvT2iD2EzAjSHnS+i/Rw++3h32VrkrwjFei6MrfG+roQkm+sWB1WrkCj00K5
m2VCKHxu7Slc2ox+1U/YDryxy8yrZUp01WOuImidHZR961yYENGGhDlPXgz4
CKDjv/f/lZnbhvTwUwVQaSM6kniiDYW++OTgBicB8bedzF8Aec+UX33a/RDJ
NPJkfMoWgrzyGXlE7NnA/Jntap+Rf9CB3yONradZQ9lzz4L3xv9BU519bq1+
3RoyorzX/LK3E7Xo52sJgqE5SpXHYzRdumfX8FELYq+btZfKh4jFgSYOEd1o
ai7wzKfyYYu+kXEOHz7VnFFvrO1G6xPnXfpOZgYF4aFex/KfIFnlvejPZSYw
ln1uNPvcU7J+xvC4ATtHtj5DJ98Jn/XrXCM48TB+Sdbk5yikeJARLuwoeZZS
8uw5WQ8uJA/Ef1fg+wI9zYq4KfuTQ/xTEfsc6PQMiFjdpEJ7pfvuH78zhiyq
jZfzZvaReI4SvX4S7yG0tyQ4b8yyH73T6P1Zlv0QipXXNaRI+9GfKdLI/Gsa
dPktK0YGiL+D6EyhavbliAFU++Cb5TVfDBC8QfLuQxEZLi/nHRtE85rP8laX
9qIZf/EYURP7T9FoT1lxyogaleZPLEwH+qfYw/FdrRrVL/CLdMvqQC/6XBjR
kHgo0bfnD3kq4zRosz+kL1qtIHaGEN230jY35hlCTt1i5vkVic7l7p6+bpiM
5/qz7xHSr8E4pHWl2doRVGLl/+Cg6zWs0LdRFBk90Zrxnzc+3nu+f5ScZyWO
rT4Zv18zihpsM/N3likxizNG8Fpw/DKVOqJ0HDWUz87Nu9lJxrVkv3RhNn5a
gvcUf7X1pW/RBh3yTlfIgrb0Yho3EkfcbvwRIxxYoI93H7atnv7DqiMcmOMU
ZKON6yf6XFa/dgBbVgAjXCDxwSWZMy92H+VC04fi2K+b1ESfR/A1mPmTGaH9
Idy9Mma7tpIHdUpb85rxIbyjISc6fYwHm/QBGybfGxF7w/iOQmRmGWoERXDv
reb4EXY8lYyrRnC756U2z0tGQPYb3lw09Ft5pxE0B/5VYPrHKMEzJvbHcHuQ
U+1uH2PY3/Tu1JJPx7CVJG/OlpXGUPBTxmPzyjGCT/RVY7jVj1c0L8MYTK/e
dlnKHccm0YcZMSbrNU7wTYi/47g0OKEvYK4J+K0WbLso1OJ5tdfi/MJMIKYl
fTh2hpbgE/0ELdZsb2PEBNjwa3HDoGOMUmMCk/Plk5ZpiD7HlPivwxfnQuRp
G1Ow8W1JuGytw40zEp9olpvCHPW2Td8v0RF8op+gw5KsBeffqTKFxe2BmcEF
OvzZ1jvnL14zhYXp00yuF+vw6G8vGDEFtj6Q7zlmZD46fLBGsGudjxmk1XcN
yRU6fEAl2fx0oRm8Je/Kv9BG7RF9lQ5vHR8wfXjKDL7DYbM+G9Jhy4Sv9mTc
MQOu74byBeMUn0/mw6kNkud0RYTz4UcPm7WVaorHN+CFx4RsdK/kQ912Y42g
hX5vbvDP74ppwNo55hBz1W+47mf6vblh/vsWbz8u6zOHtGXhNnut6Pc0z+ow
X98sQPNyomnx3UDnO4HOFoZ43PZeaaW7YgHO7uMfSQU0HpaGeC9URLb/mGQJ
Ho++zOvijOMvnEca7h2xhLt8+fvZZ8h+4lgZ9l9GnFng0slWhv3ppviAESvD
/mX9tzLs7+mePUODlVav7n+ONbE/jHe+nXhsm5G14fxIDpfu4oZaG84Xez6J
PnP+0m4ej16rsAbzr1fF1H+tIXg2ZFyDx/1eNj1YYQPfp7c2ZijUWL0QDy7E
NobzzurZEvsDuG/+7U3FK2wN+cJt9Kzr6FlbQz5h9ScRfBWODMA/X/KYBEnb
Tq3vTu0l858ENF+x8yf6TD4r7Umrf1I4CV7Nd7Qut+AegcM6J54AaL5cZP3M
eYmRAGg+tdA3AdB8m7uR7xmwQQA0H7N2KF4NTr79U+vgcdrP9Z/zhy/zCIDm
+9LhtOz5AwJ4oMeXk7xsR/SZ+rDk79nX3e2A1o/ytLmM2AGtL6w9op/agcyi
qoa/ZPq0Hu00EUWt2mkHtF6x628HtJ59Hrsl6PQ9O6D1jrUrJPaZetic9naj
txBovWwc8GdESOOHvLL3LTr8jRBovXURv6nkbBcCrcesXwSPqdfaJm3cjgoh
3Z/o9yTViTK5EGi931GBml17hfS8EH/siT8c+IFr97G1oz1Q/tCcnZq/+XWG
1xF+ITfan3Tan+kT/hFsusB/9jp7oPwETn/PiD1Q/sLyGnug/Eb4MCSwv8se
KP/pU000ap8P6rtLV25XM98T/sT+70DWnw/a9h87pH4OQPnXi4qLt5985ACU
n73xKLohKtUBKH/zHQmWXmD6lN9VTqifdADK/zbtSm/qr3cAyg9Ze5T3CsCh
+HlnlIkIKL/krX8UqjEVAeWfPp6HXlZbiIDyU2t7F1nahyKg/HXn2TL/K8tF
QPktOw+CnyuEKOETr227RUD5cObdX6L+kyECypffeOC02OO0CCifXp7UX77m
sggo32b9FJP4iyDGe7A7gCsGyt/lqR/bFDF9yu/dDxekRvLEQPl/nFNNocX7
YqD3A/Vx3//1hBE85v7gVVbyc86XYqD3iySr9A/ubREDvX+4NLh+4X9QDPS+
cn7HIsfH58RA7zMXH2ujFC1ioPed6za7ZY5dYqD3oV7XJXsuPBNDToynui7H
yWCXfU+BabJyuz5LCfyg938K7Opyfy/cXQJjXvxDRR1T4FDF0dArb0pI/nIG
d+OOsYggCaw9MJi1oNAZrta35oTFSkATZ2+5zc8FFpslMSIh+98FdoUXphzO
Z/DCtB478lwhuctYd7NEArJgfH/uoCuEHZN2BVySkPVzg/Q3xE/bb0igonlZ
76nNbsRPck9zk4LRe/yTEq4j3PfPrDryuhREZyJro5k+u1+kwLvhfLiF6XvI
1tzy9pDCnp79NdWzHSH72HHVQJMUpkni1xcH03vfa/B/WKuU2g==
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
          180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
          193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 
          206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
          219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229}]},
        RowBox[{
          TagBox["y", HoldForm], "\[Equal]", 
          RowBox[{
            RowBox[{"-", "2"}], "+", 
            SuperscriptBox[
             RowBox[{"(", 
               RowBox[{
                 RowBox[{"-", "3"}], "+", 
                 TagBox["x", HoldForm]}], ")"}], "2"]}]}]],
       Annotation[#, 
        HoldForm[$CellContext`y] == -2 + (-3 + HoldForm[$CellContext`x])^2, 
        "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxdVE1IVGEUfY7jOE7q/P+P00ykLW0VGcF3MAjMWhjUJrAIJKPMrKUtDKyl
kRnW0mhT0c7sh+y9nUWbqUWRUyCZLQojNVNTK7977zdQw8jh4Tv3nnvOvZM/
3n2ww2VZVsfGn0b+fFeMXudMcayrOLagBre2bHzdzsh4/8/Q5II62txbNVvv
dvi9H/K+2zmXmejJTCyqgemdG1+X817Tu5YU0QctZ4+mjS4pKtNqCX9Z+JYT
nmztbBxZUe80jK/Z+6jxqjpNOlbsT7rswKoimF62mbYm/GX7wXChvbl3XRFU
LdqPdPvib3WVBMzbl3Tbzj+KoHFO+BZkbvveXf2xcIfwi32NeGU4Rf1nbNZX
hhON2omPwncJf8qm8YZdaNHy+9+I/nIUyIeXor8cQW1Tz1PhuzE11Ja83ta0
ez/x3LhIdRyZqwIewoIapcEqsJcavZX/e0x/VUd1PZhhg9RDmt+DJ4SfFc9f
iW1U6KvJ2cyvdNdCuxfs45zi/L1gH+fV4UP6UwXGReH7YHJ8Rrn6sET+rqh6
yt2HIfLxl2qgvptwk/JZF341TA68N9XgOSzw/lRLf0vq1uAb6TS+18L4yHtZ
C9bhBudXiwbS4cZzXTbjxxXqY3wLwPhwg3QFcIzqeEH6QwHR7wXnE8B2OgQz
dxD/zhFE2X/PLnmulOeMPHOeQbzWbWdreN7ZIM6S736cpD0L4hYdjF/qhUq6
2acQdpFxAfEphG7iB/GK6oaEb3SGS3V4H8LwUfAh9utFWPwKo4nqhnGe7trw
IiXkHCIo0r1GwPsSwQfKLSp9I+C7jwrPYEz2KAq+uxjoXm5Hxe+46IoiQncX
L/EYE5JzDBfoXhKiO4ZWursk+PcoBr67pPBMnRR4H+M4QLmmOLe+uOSVlrni
cg/pUl/GjOxRAlnKISP7msBjyiEjcydwmXyuE57RkZV9ToqPWc7vSFLyz4ov
SfFpc0k3Y072PSWYk31PCebAv1cpwZzwzBx5sOy0YJ7z25EWzPN7ffJ+X158
Tgvmed77acF8yRfGLfgLOjUfjg==
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101}]},
        
        RowBox[{
          TagBox["y", HoldForm], "\[Equal]", 
          RowBox[{
            RowBox[{"-", "5"}], "+", 
            RowBox[{"2", " ", 
              TagBox["x", HoldForm]}]}]}]],
       Annotation[#, 
        HoldForm[$CellContext`y] == -5 + 2 HoldForm[$CellContext`x], 
        "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxVVH9oFHQUv93pnVNv3O3cnQj3x8o0GQhao1jWewvEDMkxMRGKJDVxtETY
SEgi2aCYIGor/FG5BolBsEtrxiLfMJdW0nSbtu1aa7cfzO3Wbr/O6bab9/18
3z9+uePd477f9z7v8z7v5b59oHiv0+Fw7E5/jbVnOeuPxjuN/67Lj4T42yO/
7C7ZNS/u8iJPeVGIvUM1WUM1Kdl8cmX6E2KYzSn58OUvPjvnC/Fc5fN5lJuS
y6XR+tJokA8YUz8n78EG+R9jSufk6Ws7H2QeDHLRJ5fGA7FZsXGCDHNyVnLe
GjMfXnMllnclNiO3N4beLLudw7VH1zYM1s4IwpXmMEz0oXxwvS2NOIeTxwzi
h/IU4izjVxH4gaxU/xX1n1R/k/p//bHVIOGz6Sr29d8XhK0PcCcS3JdDW7zx
8LYAj55a0f7C+aSsf8acAO95x5ykWBzZ/C7eTUkuAmZzoaFl35R8CgDZvAp5
J8Wmy+Zqk271pMzj+DkFOyEcbisMt/n5o4ILFQUXJqQMBPh5EASMi63Dz8cR
d1zC21xpCnxccN6dpmBMXvOYhvn4bJZpWEJO4J6Pn0D+hICufB+DrpKEZKDt
PrZaSMiPqCeLS1DPiDSYNuRlcVnTjsNNO+LybOT9NCNe3r/LMDIsts9e7gYR
w4rPq/iGBG3+bimbaq/tvKd4liqeQenCuyXcgLwD2t8l2t8B6VT/B/Xb1Y+o
b1RxdO1ifgNE9YntQybbe70CGY8uYheE0iPJqrrpqrpFHIfQepR/D8/Cdgvo
iXi42D6Qn5DHzTELSPXr5hoU1KH6dau+OmQZ9LuQiw8bwv5WfS7kuG2UWB0s
4NN416L6XKB8tageXXzwdTNZzbIOenPxx6fN+V315tT6f1O9OXkxHjRJNeI4
uQb2qtixdup8N0o59JTBW8xYbbys85yh+S/KVujHwVdb0zIs/FJugBAH/2do
PFWl+VN0DvdrKR96mKPtWAQRsjqYoUqbn6LqV6vfof5X6legP9M0lWkKuEkW
57TaW7QGfCepzqQJt1IA/E5RZyEGhSx/k2T7dJeawd8EAe6Kdvrczgm1WeBk
6x+joCk/1EW2/jGye6qL7PwkaC/WUDc9h/pGqG+1AdKj9QyT7XuMKoF/kF5C
I3rJD3z9dMisTU+/4uvT+P10C/h6CevEPUBnNM4lq2eNH1Vc98iLeHfoRbMO
KoaoBe9bCWvJNUxfW91Qu+Ky7/8kuwfjdBf3f6VvzHo4MqL//6z4/6cZ6L55
g9X/qPLz/YZ59R2PnQQ9An9SCjc=
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99}]},
        RowBox[{
          TagBox["y", HoldForm], "\[Equal]", 
          RowBox[{"1", "-", 
            RowBox[{"0.5`", " ", 
              TagBox["x", HoldForm]}]}]}]],
       Annotation[#, HoldForm[$CellContext`y] == 
        1 - 0.5 HoldForm[$CellContext`x], "Tooltip"]& ]}], {}}},
  PlotStyle -> All,
  AspectRatio->1,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "GridLinesInFront" -> 
    True},
  PlotInteractivity:>True,
  PlotRange->{{0, 7}, {-3, 9}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.967459034225935*^9, 3.967459098089028*^9, {3.96745944844427*^9, 
   3.9674594589461117`*^9}, 3.967459509790453*^9, 3.967459549062497*^9, {
   3.967459614699257*^9, 3.9674596348876257`*^9}, 3.967459708788945*^9, 
   3.967459743289287*^9, {3.9674598224858*^9, 3.967459865333578*^9}, {
   3.9674599351740923`*^9, 3.9674600212130823`*^9}, {3.967460065063712*^9, 
   3.9674600765299177`*^9}, {3.9674601509456177`*^9, 3.967460166336681*^9}, {
   3.9674605016544847`*^9, 3.96746051282707*^9}, {3.9674615012402487`*^9, 
   3.967461507903171*^9}, {3.967461799876987*^9, 3.967461806246373*^9}, 
   3.967462445925672*^9, {3.967462524202586*^9, 3.967462648999484*^9}, {
   3.967462697983872*^9, 3.9674627338090067`*^9}, 3.9674732051104937`*^9, 
   3.9674735598060703`*^9, 3.9674738463755417`*^9, 3.967475233236064*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"e7198d52-6165-4505-a9f0-45f4b2866fa7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"dotted\"", ",", "\"blue\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dashed\"", ",", "\"black\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thin\"", ",", "\"blue\""}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"Par\[AAcute]bola\"", ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "3"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"Recta 1\"", ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", "4"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"Recta 2\"", ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "0"}], "}"}]}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", 
     RowBox[{"-", "2"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "7"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", 
     RowBox[{"-", "4"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "10"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.967459034225935*^9, 3.967459098089028*^9, {3.96745944844427*^9, 
   3.9674594589461117`*^9}, 3.967459509790453*^9, 3.967459549062497*^9, {
   3.967459614699257*^9, 3.9674596348876257`*^9}, 3.967459708788945*^9, 
   3.967459743289287*^9, {3.9674598224858*^9, 3.967459865333578*^9}, {
   3.9674599351740923`*^9, 3.9674600212130823`*^9}, {3.967460065063712*^9, 
   3.9674600765299177`*^9}, {3.9674601509456177`*^9, 3.967460166336681*^9}, {
   3.9674605016544847`*^9, 3.96746051282707*^9}, {3.9674615012402487`*^9, 
   3.967461507903171*^9}, {3.967461799876987*^9, 3.967461806246373*^9}, 
   3.967462445925672*^9, {3.967462524202586*^9, 3.967462648999484*^9}, {
   3.967462697983872*^9, 3.9674627338090067`*^9}, 3.9674732051104937`*^9, 
   3.9674735598060703`*^9, 3.9674738463755417`*^9, 3.9674752332387238`*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"43160be4-e4f2-4fbb-9955-e92eca9b7663"],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/conicas1/conicas1.\
tex\"\>"], "Output",
 CellChangeTimes->{
  3.967459034225935*^9, 3.967459098089028*^9, {3.96745944844427*^9, 
   3.9674594589461117`*^9}, 3.967459509790453*^9, 3.967459549062497*^9, {
   3.967459614699257*^9, 3.9674596348876257`*^9}, 3.967459708788945*^9, 
   3.967459743289287*^9, {3.9674598224858*^9, 3.967459865333578*^9}, {
   3.9674599351740923`*^9, 3.9674600212130823`*^9}, {3.967460065063712*^9, 
   3.9674600765299177`*^9}, {3.9674601509456177`*^9, 3.967460166336681*^9}, {
   3.9674605016544847`*^9, 3.96746051282707*^9}, {3.9674615012402487`*^9, 
   3.967461507903171*^9}, {3.967461799876987*^9, 3.967461806246373*^9}, 
   3.967462445925672*^9, {3.967462524202586*^9, 3.967462648999484*^9}, {
   3.967462697983872*^9, 3.9674627338090067`*^9}, 3.9674732051104937`*^9, 
   3.9674735598060703`*^9, 3.9674738463755417`*^9, 3.9674752335766582`*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"68f42fb0-fa1d-4d00-82e1-5d48188af0b7"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967459034315958*^9, 3.967459098180764*^9, {3.967459448533113*^9, 
   3.96745945903547*^9}, 3.967459509883054*^9, 3.9674595491510277`*^9, {
   3.9674596147862988`*^9, 3.967459634976653*^9}, 3.967459708876252*^9, 
   3.967459743376113*^9, {3.967459822574348*^9, 3.967459865421421*^9}, {
   3.967459935262339*^9, 3.967460021300417*^9}, {3.9674600651528063`*^9, 
   3.967460076617337*^9}, {3.96746015102787*^9, 3.967460166426392*^9}, {
   3.967460501743394*^9, 3.9674605129158373`*^9}, {3.9674615012432547`*^9, 
   3.967461507906205*^9}, {3.9674617998796053`*^9, 3.96746180624934*^9}, 
   3.967462446289171*^9, {3.967462524525981*^9, 3.967462649327703*^9}, {
   3.967462698313772*^9, 3.967462734137342*^9}, 3.967473205479186*^9, 
   3.9674735601247473`*^9, 3.967473846721135*^9, 3.967475233577319*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"ef34e438-c250-43eb-9e15-5449a0ba788e"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967459034315958*^9, 3.967459098180764*^9, {3.967459448533113*^9, 
   3.96745945903547*^9}, 3.967459509883054*^9, 3.9674595491510277`*^9, {
   3.9674596147862988`*^9, 3.967459634976653*^9}, 3.967459708876252*^9, 
   3.967459743376113*^9, {3.967459822574348*^9, 3.967459865421421*^9}, {
   3.967459935262339*^9, 3.967460021300417*^9}, {3.9674600651528063`*^9, 
   3.967460076617337*^9}, {3.96746015102787*^9, 3.967460166426392*^9}, {
   3.967460501743394*^9, 3.9674605129158373`*^9}, {3.9674615012432547`*^9, 
   3.967461507906205*^9}, {3.9674617998796053`*^9, 3.96746180624934*^9}, 
   3.967462446289171*^9, {3.967462524525981*^9, 3.967462649327703*^9}, {
   3.967462698313772*^9, 3.967462734137342*^9}, 3.967473205479186*^9, 
   3.9674735601247473`*^9, 3.967473846721135*^9, 3.967475233577691*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"44b7f74e-7a1d-4f9c-9971-b2499e40f821"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967459034315958*^9, 3.967459098180764*^9, {3.967459448533113*^9, 
   3.96745945903547*^9}, 3.967459509883054*^9, 3.9674595491510277`*^9, {
   3.9674596147862988`*^9, 3.967459634976653*^9}, 3.967459708876252*^9, 
   3.967459743376113*^9, {3.967459822574348*^9, 3.967459865421421*^9}, {
   3.967459935262339*^9, 3.967460021300417*^9}, {3.9674600651528063`*^9, 
   3.967460076617337*^9}, {3.96746015102787*^9, 3.967460166426392*^9}, {
   3.967460501743394*^9, 3.9674605129158373`*^9}, {3.9674615012432547`*^9, 
   3.967461507906205*^9}, {3.9674617998796053`*^9, 3.96746180624934*^9}, 
   3.967462446289171*^9, {3.967462524525981*^9, 3.967462649327703*^9}, {
   3.967462698313772*^9, 3.967462734137342*^9}, 3.967473205479186*^9, 
   3.9674735601247473`*^9, 3.967473846721135*^9, 3.9674752335781612`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"7de0f30b-c64e-4f5c-a162-078a8d3251b3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967459034315958*^9, 3.967459098180764*^9, {3.967459448533113*^9, 
   3.96745945903547*^9}, 3.967459509883054*^9, 3.9674595491510277`*^9, {
   3.9674596147862988`*^9, 3.967459634976653*^9}, 3.967459708876252*^9, 
   3.967459743376113*^9, {3.967459822574348*^9, 3.967459865421421*^9}, {
   3.967459935262339*^9, 3.967460021300417*^9}, {3.9674600651528063`*^9, 
   3.967460076617337*^9}, {3.96746015102787*^9, 3.967460166426392*^9}, {
   3.967460501743394*^9, 3.9674605129158373`*^9}, {3.9674615012432547`*^9, 
   3.967461507906205*^9}, {3.9674617998796053`*^9, 3.96746180624934*^9}, 
   3.967462446289171*^9, {3.967462524525981*^9, 3.967462649327703*^9}, {
   3.967462698313772*^9, 3.967462734137342*^9}, 3.967473205479186*^9, 
   3.9674735601247473`*^9, 3.967473846721135*^9, 3.967475233578453*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"409e353c-822e-479c-accd-c5ab3316dd72"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967459034315958*^9, 3.967459098180764*^9, {3.967459448533113*^9, 
   3.96745945903547*^9}, 3.967459509883054*^9, 3.9674595491510277`*^9, {
   3.9674596147862988`*^9, 3.967459634976653*^9}, 3.967459708876252*^9, 
   3.967459743376113*^9, {3.967459822574348*^9, 3.967459865421421*^9}, {
   3.967459935262339*^9, 3.967460021300417*^9}, {3.9674600651528063`*^9, 
   3.967460076617337*^9}, {3.96746015102787*^9, 3.967460166426392*^9}, {
   3.967460501743394*^9, 3.9674605129158373`*^9}, {3.9674615012432547`*^9, 
   3.967461507906205*^9}, {3.9674617998796053`*^9, 3.96746180624934*^9}, 
   3.967462446289171*^9, {3.967462524525981*^9, 3.967462649327703*^9}, {
   3.967462698313772*^9, 3.967462734137342*^9}, 3.967473205479186*^9, 
   3.9674735601247473`*^9, 3.967473846721135*^9, 3.967475233578746*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"6bd20ff4-eeea-4946-a6b5-5cac51c07fda"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967459034315958*^9, 3.967459098180764*^9, {3.967459448533113*^9, 
   3.96745945903547*^9}, 3.967459509883054*^9, 3.9674595491510277`*^9, {
   3.9674596147862988`*^9, 3.967459634976653*^9}, 3.967459708876252*^9, 
   3.967459743376113*^9, {3.967459822574348*^9, 3.967459865421421*^9}, {
   3.967459935262339*^9, 3.967460021300417*^9}, {3.9674600651528063`*^9, 
   3.967460076617337*^9}, {3.96746015102787*^9, 3.967460166426392*^9}, {
   3.967460501743394*^9, 3.9674605129158373`*^9}, {3.9674615012432547`*^9, 
   3.967461507906205*^9}, {3.9674617998796053`*^9, 3.96746180624934*^9}, 
   3.967462446289171*^9, {3.967462524525981*^9, 3.967462649327703*^9}, {
   3.967462698313772*^9, 3.967462734137342*^9}, 3.967473205479186*^9, 
   3.9674735601247473`*^9, 3.967473846721135*^9, 3.9674752336723843`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"83b8b8c1-b9e1-44ea-ab19-a0e24bf9b7cf"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967459034315958*^9, 3.967459098180764*^9, {3.967459448533113*^9, 
   3.96745945903547*^9}, 3.967459509883054*^9, 3.9674595491510277`*^9, {
   3.9674596147862988`*^9, 3.967459634976653*^9}, 3.967459708876252*^9, 
   3.967459743376113*^9, {3.967459822574348*^9, 3.967459865421421*^9}, {
   3.967459935262339*^9, 3.967460021300417*^9}, {3.9674600651528063`*^9, 
   3.967460076617337*^9}, {3.96746015102787*^9, 3.967460166426392*^9}, {
   3.967460501743394*^9, 3.9674605129158373`*^9}, {3.9674615012432547`*^9, 
   3.967461507906205*^9}, {3.9674617998796053`*^9, 3.96746180624934*^9}, 
   3.967462446289171*^9, {3.967462524525981*^9, 3.967462649327703*^9}, {
   3.967462698313772*^9, 3.967462734137342*^9}, 3.967473205479186*^9, 
   3.9674735601247473`*^9, 3.967473846721135*^9, 3.9674752346786137`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"b767709a-5fd4-4663-905d-2d1d9318a4ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", "\<\"/Users/enriquevilchezquesada/Downloads/conicas1/\
\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/conicas1/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967459034315958*^9, 3.967459098180764*^9, {3.967459448533113*^9, 
   3.96745945903547*^9}, 3.967459509883054*^9, 3.9674595491510277`*^9, {
   3.9674596147862988`*^9, 3.967459634976653*^9}, 3.967459708876252*^9, 
   3.967459743376113*^9, {3.967459822574348*^9, 3.967459865421421*^9}, {
   3.967459935262339*^9, 3.967460021300417*^9}, {3.9674600651528063`*^9, 
   3.967460076617337*^9}, {3.96746015102787*^9, 3.967460166426392*^9}, {
   3.967460501743394*^9, 3.9674605129158373`*^9}, {3.9674615012432547`*^9, 
   3.967461507906205*^9}, {3.9674617998796053`*^9, 3.96746180624934*^9}, 
   3.967462446289171*^9, {3.967462524525981*^9, 3.967462649327703*^9}, {
   3.967462698313772*^9, 3.967462734137342*^9}, 3.967473205479186*^9, 
   3.9674735601247473`*^9, 3.967473846721135*^9, 3.967475234681532*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"fe2a596b-b35b-4315-9033-f21ebe3fef42"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"conicas1\"\>"}],
  SequenceForm["Archivo: ", "conicas1"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967459034315958*^9, 3.967459098180764*^9, {3.967459448533113*^9, 
   3.96745945903547*^9}, 3.967459509883054*^9, 3.9674595491510277`*^9, {
   3.9674596147862988`*^9, 3.967459634976653*^9}, 3.967459708876252*^9, 
   3.967459743376113*^9, {3.967459822574348*^9, 3.967459865421421*^9}, {
   3.967459935262339*^9, 3.967460021300417*^9}, {3.9674600651528063`*^9, 
   3.967460076617337*^9}, {3.96746015102787*^9, 3.967460166426392*^9}, {
   3.967460501743394*^9, 3.9674605129158373`*^9}, {3.9674615012432547`*^9, 
   3.967461507906205*^9}, {3.9674617998796053`*^9, 3.96746180624934*^9}, 
   3.967462446289171*^9, {3.967462524525981*^9, 3.967462649327703*^9}, {
   3.967462698313772*^9, 3.967462734137342*^9}, 3.967473205479186*^9, 
   3.9674735601247473`*^9, 3.967473846721135*^9, 3.967475234683054*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"b085ad53-a87b-4b37-91d4-3b50c535e068"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967459034315958*^9, 3.967459098180764*^9, {3.967459448533113*^9, 
   3.96745945903547*^9}, 3.967459509883054*^9, 3.9674595491510277`*^9, {
   3.9674596147862988`*^9, 3.967459634976653*^9}, 3.967459708876252*^9, 
   3.967459743376113*^9, {3.967459822574348*^9, 3.967459865421421*^9}, {
   3.967459935262339*^9, 3.967460021300417*^9}, {3.9674600651528063`*^9, 
   3.967460076617337*^9}, {3.96746015102787*^9, 3.967460166426392*^9}, {
   3.967460501743394*^9, 3.9674605129158373`*^9}, {3.9674615012432547`*^9, 
   3.967461507906205*^9}, {3.9674617998796053`*^9, 3.96746180624934*^9}, 
   3.967462446289171*^9, {3.967462524525981*^9, 3.967462649327703*^9}, {
   3.967462698313772*^9, 3.967462734137342*^9}, 3.967473205479186*^9, 
   3.9674735601247473`*^9, 3.967473846721135*^9, 3.967475235355047*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"3d53ca21-8226-4b70-88b3-c92767c8f51d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/conicas1/conicas1.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/conicas1/conicas1.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967459034315958*^9, 3.967459098180764*^9, {3.967459448533113*^9, 
   3.96745945903547*^9}, 3.967459509883054*^9, 3.9674595491510277`*^9, {
   3.9674596147862988`*^9, 3.967459634976653*^9}, 3.967459708876252*^9, 
   3.967459743376113*^9, {3.967459822574348*^9, 3.967459865421421*^9}, {
   3.967459935262339*^9, 3.967460021300417*^9}, {3.9674600651528063`*^9, 
   3.967460076617337*^9}, {3.96746015102787*^9, 3.967460166426392*^9}, {
   3.967460501743394*^9, 3.9674605129158373`*^9}, {3.9674615012432547`*^9, 
   3.967461507906205*^9}, {3.9674617998796053`*^9, 3.96746180624934*^9}, 
   3.967462446289171*^9, {3.967462524525981*^9, 3.967462649327703*^9}, {
   3.967462698313772*^9, 3.967462734137342*^9}, 3.967473205479186*^9, 
   3.9674735601247473`*^9, 3.967473846721135*^9, 3.967475235355627*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"ada8e69e-73ee-42ec-b80d-4a93aef8edb2"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/conicas1/conicas1.\
pdf\"\>"], "Output",
 CellChangeTimes->{
  3.967459034225935*^9, 3.967459098089028*^9, {3.96745944844427*^9, 
   3.9674594589461117`*^9}, 3.967459509790453*^9, 3.967459549062497*^9, {
   3.967459614699257*^9, 3.9674596348876257`*^9}, 3.967459708788945*^9, 
   3.967459743289287*^9, {3.9674598224858*^9, 3.967459865333578*^9}, {
   3.9674599351740923`*^9, 3.9674600212130823`*^9}, {3.967460065063712*^9, 
   3.9674600765299177`*^9}, {3.9674601509456177`*^9, 3.967460166336681*^9}, {
   3.9674605016544847`*^9, 3.96746051282707*^9}, {3.9674615012402487`*^9, 
   3.967461507903171*^9}, {3.967461799876987*^9, 3.967461806246373*^9}, 
   3.967462445925672*^9, {3.967462524202586*^9, 3.967462648999484*^9}, {
   3.967462697983872*^9, 3.9674627338090067`*^9}, 3.9674732051104937`*^9, 
   3.9674735598060703`*^9, 3.9674738463755417`*^9, 3.967475235367991*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"e4513195-118d-4b7e-b869-2e49213bbd8a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 2: hip\[EAcute]rbola con as\[IAcute]ntotas", "Subsection",
 CellChangeTimes->{{3.967295680579814*^9, 3.96729570644077*^9}, {
  3.967460195880177*^9, 3.967460200495964*^9}, {3.9674627835026493`*^9, 
  3.967462791825242*^9}},ExpressionUUID->"8c5757b8-938d-4bd1-8719-\
806bd88b112c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "-", "2"}], ")"}], "^", "2"}], "/", "4"}], "-", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"y", "+", "1"}], ")"}], "^", "2"}], "/", "9"}]}], "==", 
       "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "4"}], ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "7"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"y", "==", 
       RowBox[{
        RowBox[{"1.5", "*", "x"}], "-", "4"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "4"}], ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "7"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"y", "==", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1.5"}], "*", "x"}], "+", "2"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "4"}], ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "7"}], ",", "5"}], "}"}]}], "]"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", "True"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "3"}], "]"}]}]}], "}"}],
     "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", "True"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Centro (2,-1)\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", 
             RowBox[{"-", "1.5"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<As\[IAcute]ntota 1\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"6", ",", "4"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<As\[IAcute]ntota 2\>\"", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "2"}], ",", "4"}], "}"}]}], "}"}]}], "}"}]}]}], 
     "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", 
       RowBox[{"-", "5"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "9"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", 
       RowBox[{"-", "8"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "6"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportConicsToTikZ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"x", "-", "2"}], ")"}], "^", "2"}], "/", "4"}], "-", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"y", "+", "1"}], ")"}], "^", "2"}], "/", "9"}]}], "==", 
         "1"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "4"}], ",", "8"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "7"}], ",", "5"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y", "==", 
         RowBox[{
          RowBox[{"1.5", "*", "x"}], "-", "4"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "4"}], ",", "8"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "7"}], ",", "5"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y", "==", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "1.5"}], "*", "x"}], "+", "2"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "4"}], ",", "8"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "7"}], ",", "5"}], "}"}]}], "}"}]}], "}"}], 
    ",", "\"\<conicas2.tex\>\"", ",", "grid", ",", "estilos", ",", "ejes", ",",
     "texto", ",", "xmin", ",", "xmax", ",", "ymin"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967458949134716*^9, 3.967459027720326*^9}, {
   3.967459071759989*^9, 3.9674590970531263`*^9}, {3.9674594354664183`*^9, 
   3.967459437241929*^9}, {3.967459508130843*^9, 3.967459508712741*^9}, {
   3.9674595408130283`*^9, 3.967459548251939*^9}, {3.967459585390415*^9, 
   3.967459604549168*^9}, {3.9674596658040037`*^9, 3.96745967875946*^9}, {
   3.967459741950267*^9, 3.9674597424546623`*^9}, {3.9674598092151203`*^9, 
   3.967459818772814*^9}, {3.9674598852880297`*^9, 3.96745993122128*^9}, {
   3.9674599822112093`*^9, 3.967459999188642*^9}, {3.96746004716756*^9, 
   3.967460061048337*^9}, 3.967460111844652*^9, {3.9674602162623367`*^9, 
   3.967460307919488*^9}, {3.967460387363729*^9, 3.967460460871293*^9}, {
   3.967460735293603*^9, 3.9674607439333067`*^9}, {3.967461477173238*^9, 
   3.967461477504286*^9}, {3.967461824632308*^9, 3.967461825352717*^9}, 
   3.967462671421789*^9, {3.9674628025659657`*^9, 3.9674628584462147`*^9}, {
   3.967462888672852*^9, 3.967463008364242*^9}, {3.9674735786545477`*^9, 
   3.967473578951253*^9}, {3.9674738346635723`*^9, 3.9674738353217163`*^9}, 
   3.9705937845502234`*^9},ExpressionUUID->"2c5e1a65-a617-42ba-9dd0-\
9ebf0034f058"],

Cell[BoxData[
 GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJxVlwlUFFcWhrtZ7ShQ3XQ3TdMMGEYcUIfpgcQoaF1FAu7GMa7RMARx3xDB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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104}], 
         LineBox[{105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
          117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 
          130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 
          143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 
          156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 
          169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 
          182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 
          195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207}]},
        RowBox[{
          RowBox[{
            RowBox[{
              FractionBox["1", "4"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                 RowBox[{
                   RowBox[{"-", "2"}], "+", 
                   TagBox["x", HoldForm]}], ")"}], "2"]}], "-", 
            RowBox[{
              FractionBox["1", "9"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                 RowBox[{"1", "+", 
                   TagBox["y", HoldForm]}], ")"}], "2"]}]}], "\[Equal]", 
          "1"}]],
       Annotation[#, 
        Rational[1, 4] (-2 + HoldForm[$CellContext`x])^2 + 
         Rational[-1, 9] (1 + HoldForm[$CellContext`y])^2 == 1, 
        "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJx1ldtLVFEUxsdpvE1e5j6mFYiWUfQHNAl7BVEZPZgPSSAJXUyqybB8yopQ
CAxMp6lU6OJLGVEKmRaVexdMD1EQFZZZWRJFimhSOWpqc9b+HGigwx4Ov9ln
77O+b317JntnRdEes8lkKo98jPucvqSJr8Wq9Ic7MuZkra+txteWpfz9XZEx
IwsCuZGRpY6GiqtDxX9k2tCVyMhUPO2fljxdkKlamo1rUur7ItXDG/yWebxB
hroHXga+G8Nd4Fzw63VLIuOn7AjXtYfrvOocT4xLvc6jxt1csVxrlFvjUbMs
ZxR6PGopbzAinxhlV7vVAL9gWG7mgt1qu/F16JvcmlhVmFjlUq28/6D8yM85
1Xnwe3AwhhvB/eBW1t0n95YZl0Nd4vmXsoIfsKsVXM9zqeu2q3qefyy7WY9N
Ec/flMfYZxv8f/QgjvXYlJXnHwob+5+mduv9xWr2K0XVgvPAdeDl4CA4F+zk
/T6IfPbPqk5rPWIL+5OsXrD/X0QR+5OkdJ1fhdafqC6w3u+inPUmqF7trzjE
dcerEs7TqDjOeiyoZ1w08d2szoCD4AbwWXAAHAAfKTQK+SWuG+X6TKpT50VU
IqfbuJ8T4gRyqnM7ifVTcg3rnBI3eH1YvtX5FfeRuyz2Y0a8Qe7C+nyIFPZ/
TM6ALeBZsBmsc2ciE5jll8ZRCXKm82KmFuRmcFVPZJipjB8cQK4WUAfX0yt1
/i20ErnJYUEW6kRuWGZ1PF19ZcxfFLd5XQLtQp+7wCdj+BS4G9wAvsa+JNEw
1/1ZbNQ5oFvoexP3O5mC6Lv21Uq63yPCOKXtYStd5h+IMfGOX7iQ6tFHtqE4
hSrRx328LpXy0Sc/eH0MbwAfBG8C72Df0ikTfdPtSKdp9IXb7bPRBBdmIp17
Gx3gfeKIT9GQjT6hD3pfO/WhDyyz2U5PnxmXBT450J8EagR3ggPgOzE877v2
x4H3JhF+N7CvlbjcNifN+6hz5MI9hbR/LjrM/qVCj4v2wxd9PtxUAl/0927K
/ke3m3LA/v/wvE98rMs8UR+0Dk9Ul/bfS/r/wEG631746CSOZ8gb1aV1ZER1
/QWx7AWj
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104}]},
        RowBox[{
          TagBox["y", HoldForm], "\[Equal]", 
          RowBox[{
            RowBox[{"-", "4"}], "+", 
            RowBox[{"1.5`", " ", 
              TagBox["x", HoldForm]}]}]}]],
       Annotation[#, 
        HoldForm[$CellContext`y] == -4 + 1.5 HoldForm[$CellContext`x], 
        "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJx1lUtIlFEUx8dpfL9m1PGZhDTmQlq0LeEeIUKjRdlCoodRVEKMhiUtepAo
hCVW40QpmbXrQRpkoxF5L0G1qBaVZWYWihQ9xAeVr8zmO+c/G8HLHS6/+eY7
5/z/99w7OXsqS/bZbTZbefBjrTLSSdblpvT4k+BMo9q1N4Izy3wIeAcC3jQq
8nmKfZ4ss2vCXTbhTqOE79eCM9Pw44FU4sfFmWY/j1RqabZGhqm0HgfclGc9
9qWbCnAu2LsEe8DVmyOD000d02eCM83I71KoW/KaE1a5pSm0ziq3NtWIjhTo
STV1rCOZnrIwt/nIBSfTRi7Ybc5y4CTaYqWpTjF+TpxEn+R3pgmM94xvCR4A
i24XHWAfkozkcZH44DLX2TgnTVo2lrmM6HSS+Og0N9l4J4kupwljHU7Canaz
/4mUyP4nmCMcN55Wc5w4cwicB64ErwJXgD3gk5wnjgrYvxgzyIXE0iauO9o0
sD8xVML+REFvDPRHQm80lbPeCOiNJqkjHHqioMdhHrLOCLrMceymG+xfxE3g
LrAPLPsYTrc4rs2ILgdVcb55/bYwu7cw20GnON9fLXUuQ/xZPZLfM5zfY6fb
/P60Rl6Suv5o2Zcw6uM4v7RDGonieBnXYWDHIraDcaDQf+N6Ra8VaF7t4HP1
VUtfzakWzjusxfdZVc77+lmzHM+MEh/e6W383pRaw3Fe6gdSp+rk9x/ro3w+
fqu6N9bzVnWFv59U23l9rS6Ca8B+cD3YB/aD93IdY+on+zCkhrjeH6qd835R
rbzf35Qfaxe+l74aVe/ZtxF1lft8XMk+D6tG5MllHYOqCnV3Im8BdLeB14Nb
wBvAoTqLwMTxHqlM+Czn8FnB3AIP1ce+3NFT1vXRYaNG+Cb3TBjFwdch9MVp
ia/70TeNrLNfP39hDQfVYN/uoi8bwJ3gRvB98AVwALwVfdDG/kTRO/FXn8e5
yuB6RnU9zt0/ljGmRU4sjfG+TOjD7F88nRNf9UGc61fo2524J9rR1zm4Z+6B
V4I7F3EAHLqXLrH+Gd2Me038ndOhe+8Yzpn8HySRF+dQ+jiZuFr3gg7dw6Jj
QYfu6f+TgfGE
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104}]},
        RowBox[{
          TagBox["y", HoldForm], "\[Equal]", 
          RowBox[{"2", "-", 
            RowBox[{"1.5`", " ", 
              TagBox["x", HoldForm]}]}]}]],
       Annotation[#, HoldForm[$CellContext`y] == 
        2 - 1.5 HoldForm[$CellContext`x], "Tooltip"]& ]}], {}}},
  AspectRatio->1,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "GridLinesInFront" -> 
    True},
  PlotInteractivity:>True,
  PlotRange->{{-4, 8}, {-7, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.96746028299515*^9, 3.9674603083534107`*^9}, {
   3.967460536554369*^9, 3.967460565141779*^9}, {3.967461477912668*^9, 
   3.967461491726306*^9}, {3.967461826213462*^9, 3.9674618426537743`*^9}, {
   3.967463016386972*^9, 3.9674630445682487`*^9}, {3.9674732270147257`*^9, 
   3.967473238969886*^9}, {3.9674735722872353`*^9, 3.9674735795881042`*^9}, 
   3.96747386080729*^9, 3.967475243821075*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"74052746-f2af-41a7-af22-47459e8f6a11"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"dotted\"", ",", "\"orange\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thick\"", ",", "\"magenta\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dotted\"", ",", "\"orange\""}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"Centro (2,-1)\"", ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", 
                 RowBox[{"-", "1.5`"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"As\[IAcute]ntota 1\"", ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "4"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"As\[IAcute]ntota 2\"", ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"-", "2"}], ",", "4"}], "}"}]}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", 
     RowBox[{"-", "5"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "9"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", 
     RowBox[{"-", "8"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "6"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{{3.96746028299515*^9, 3.9674603083534107`*^9}, {
   3.967460536554369*^9, 3.967460565141779*^9}, {3.967461477912668*^9, 
   3.967461491726306*^9}, {3.967461826213462*^9, 3.9674618426537743`*^9}, {
   3.967463016386972*^9, 3.9674630445682487`*^9}, {3.9674732270147257`*^9, 
   3.967473238969886*^9}, {3.9674735722872353`*^9, 3.9674735795881042`*^9}, 
   3.96747386080729*^9, 3.967475243823688*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"ce903e4e-80d4-4946-abb0-456d9be6ae9d"],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/conicas2/conicas2.\
tex\"\>"], "Output",
 CellChangeTimes->{{3.96746028299515*^9, 3.9674603083534107`*^9}, {
   3.967460536554369*^9, 3.967460565141779*^9}, {3.967461477912668*^9, 
   3.967461491726306*^9}, {3.967461826213462*^9, 3.9674618426537743`*^9}, {
   3.967463016386972*^9, 3.9674630445682487`*^9}, {3.9674732270147257`*^9, 
   3.967473238969886*^9}, {3.9674735722872353`*^9, 3.9674735795881042`*^9}, 
   3.96747386080729*^9, 3.9674752444309263`*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"d29059e2-c5c0-402f-af67-209b4e272daf"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9674602830803013`*^9, 3.967460308441778*^9}, {
   3.9674605366405897`*^9, 3.967460565229879*^9}, {3.967461477915875*^9, 
   3.967461491730104*^9}, {3.967461826216905*^9, 3.96746184265732*^9}, {
   3.9674630169864883`*^9, 3.9674630451597967`*^9}, {3.967473227622559*^9, 
   3.967473239561665*^9}, {3.967473572893334*^9, 3.967473580188501*^9}, 
   3.967473861410782*^9, 3.9674752444316807`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"2bea6f08-f38b-468d-8d29-dea7a6bae665"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.9674602830803013`*^9, 3.967460308441778*^9}, {
   3.9674605366405897`*^9, 3.967460565229879*^9}, {3.967461477915875*^9, 
   3.967461491730104*^9}, {3.967461826216905*^9, 3.96746184265732*^9}, {
   3.9674630169864883`*^9, 3.9674630451597967`*^9}, {3.967473227622559*^9, 
   3.967473239561665*^9}, {3.967473572893334*^9, 3.967473580188501*^9}, 
   3.967473861410782*^9, 3.96747524443209*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"a0a6e61f-240e-49be-971a-e23e0b0f665a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9674602830803013`*^9, 3.967460308441778*^9}, {
   3.9674605366405897`*^9, 3.967460565229879*^9}, {3.967461477915875*^9, 
   3.967461491730104*^9}, {3.967461826216905*^9, 3.96746184265732*^9}, {
   3.9674630169864883`*^9, 3.9674630451597967`*^9}, {3.967473227622559*^9, 
   3.967473239561665*^9}, {3.967473572893334*^9, 3.967473580188501*^9}, 
   3.967473861410782*^9, 3.967475244432584*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"36d5b940-e81c-4753-890e-6eb35aeb014a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9674602830803013`*^9, 3.967460308441778*^9}, {
   3.9674605366405897`*^9, 3.967460565229879*^9}, {3.967461477915875*^9, 
   3.967461491730104*^9}, {3.967461826216905*^9, 3.96746184265732*^9}, {
   3.9674630169864883`*^9, 3.9674630451597967`*^9}, {3.967473227622559*^9, 
   3.967473239561665*^9}, {3.967473572893334*^9, 3.967473580188501*^9}, 
   3.967473861410782*^9, 3.967475244432893*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"dcd985a1-f29b-4445-85ee-333ae8b03da6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9674602830803013`*^9, 3.967460308441778*^9}, {
   3.9674605366405897`*^9, 3.967460565229879*^9}, {3.967461477915875*^9, 
   3.967461491730104*^9}, {3.967461826216905*^9, 3.96746184265732*^9}, {
   3.9674630169864883`*^9, 3.9674630451597967`*^9}, {3.967473227622559*^9, 
   3.967473239561665*^9}, {3.967473572893334*^9, 3.967473580188501*^9}, 
   3.967473861410782*^9, 3.9674752444332037`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"f81c2345-dc09-40d6-87e0-e6bd8a8ec205"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.9674602830803013`*^9, 3.967460308441778*^9}, {
   3.9674605366405897`*^9, 3.967460565229879*^9}, {3.967461477915875*^9, 
   3.967461491730104*^9}, {3.967461826216905*^9, 3.96746184265732*^9}, {
   3.9674630169864883`*^9, 3.9674630451597967`*^9}, {3.967473227622559*^9, 
   3.967473239561665*^9}, {3.967473572893334*^9, 3.967473580188501*^9}, 
   3.967473861410782*^9, 3.967475244504058*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"8bff247f-b5f0-4499-9fcd-cac33cbc45ea"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.9674602830803013`*^9, 3.967460308441778*^9}, {
   3.9674605366405897`*^9, 3.967460565229879*^9}, {3.967461477915875*^9, 
   3.967461491730104*^9}, {3.967461826216905*^9, 3.96746184265732*^9}, {
   3.9674630169864883`*^9, 3.9674630451597967`*^9}, {3.967473227622559*^9, 
   3.967473239561665*^9}, {3.967473572893334*^9, 3.967473580188501*^9}, 
   3.967473861410782*^9, 3.967475245509276*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"b7013c65-66a9-4a99-a88e-e62fcc550fb1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", "\<\"/Users/enriquevilchezquesada/Downloads/conicas2/\
\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/conicas2/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9674602830803013`*^9, 3.967460308441778*^9}, {
   3.9674605366405897`*^9, 3.967460565229879*^9}, {3.967461477915875*^9, 
   3.967461491730104*^9}, {3.967461826216905*^9, 3.96746184265732*^9}, {
   3.9674630169864883`*^9, 3.9674630451597967`*^9}, {3.967473227622559*^9, 
   3.967473239561665*^9}, {3.967473572893334*^9, 3.967473580188501*^9}, 
   3.967473861410782*^9, 3.967475245512129*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"321c049d-e00a-4a07-88d1-b79547950188"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"conicas2\"\>"}],
  SequenceForm["Archivo: ", "conicas2"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9674602830803013`*^9, 3.967460308441778*^9}, {
   3.9674605366405897`*^9, 3.967460565229879*^9}, {3.967461477915875*^9, 
   3.967461491730104*^9}, {3.967461826216905*^9, 3.96746184265732*^9}, {
   3.9674630169864883`*^9, 3.9674630451597967`*^9}, {3.967473227622559*^9, 
   3.967473239561665*^9}, {3.967473572893334*^9, 3.967473580188501*^9}, 
   3.967473861410782*^9, 3.9674752455144167`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"d4595632-c044-4db3-8a5e-80b9b2903d89"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.9674602830803013`*^9, 3.967460308441778*^9}, {
   3.9674605366405897`*^9, 3.967460565229879*^9}, {3.967461477915875*^9, 
   3.967461491730104*^9}, {3.967461826216905*^9, 3.96746184265732*^9}, {
   3.9674630169864883`*^9, 3.9674630451597967`*^9}, {3.967473227622559*^9, 
   3.967473239561665*^9}, {3.967473572893334*^9, 3.967473580188501*^9}, 
   3.967473861410782*^9, 3.967475246214902*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"8e564270-aa15-49d4-a2bf-7c4b9bacda5f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/conicas2/conicas2.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/conicas2/conicas2.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9674602830803013`*^9, 3.967460308441778*^9}, {
   3.9674605366405897`*^9, 3.967460565229879*^9}, {3.967461477915875*^9, 
   3.967461491730104*^9}, {3.967461826216905*^9, 3.96746184265732*^9}, {
   3.9674630169864883`*^9, 3.9674630451597967`*^9}, {3.967473227622559*^9, 
   3.967473239561665*^9}, {3.967473572893334*^9, 3.967473580188501*^9}, 
   3.967473861410782*^9, 3.967475246215474*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[14]:=",ExpressionUUID->"b432258b-2c8e-4eae-9b13-74903f587bca"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/conicas2/conicas2.\
pdf\"\>"], "Output",
 CellChangeTimes->{{3.96746028299515*^9, 3.9674603083534107`*^9}, {
   3.967460536554369*^9, 3.967460565141779*^9}, {3.967461477912668*^9, 
   3.967461491726306*^9}, {3.967461826213462*^9, 3.9674618426537743`*^9}, {
   3.967463016386972*^9, 3.9674630445682487`*^9}, {3.9674732270147257`*^9, 
   3.967473238969886*^9}, {3.9674735722872353`*^9, 3.9674735795881042`*^9}, 
   3.96747386080729*^9, 3.967475246227437*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"0c0f8126-bcbe-4c4d-8d09-de67dcbe3068"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Ejemplo 3: c\[IAcute]rculos y elipses conc\[EAcute]ntricas simulando \
\[OAcute]rbitas planetarias\
\>", "Subsection",
 CellChangeTimes->{{3.967295680579814*^9, 3.967295717462656*^9}, {
   3.967460713361005*^9, 3.967460718712819*^9}, {3.967460772178719*^9, 
   3.967460772941152*^9}, {3.9674630899912157`*^9, 3.96746309589929*^9}, 
   3.967474004659421*^9},ExpressionUUID->"65225bfa-9f11-4710-acdb-\
963434bfb5c4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "==", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "==", "4"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "/", "9"}], "+", 
        RowBox[{
         RowBox[{"y", "^", "2"}], "/", "4"}]}], "==", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "/", "16"}], "+", 
        RowBox[{
         RowBox[{"y", "^", "2"}], "/", "9"}]}], "==", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}], ",", 
    RowBox[{"PlotStyle", "->", "All"}]}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "4"}], "]"}]}]}], "}"}],
     "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Sol\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<Planeta A\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"0.7", ",", "0.7"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<Planeta B\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"1.8", ",", "0"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<Cometa\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"2.5", ",", "1.2"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<Planeta C\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"3.5", ",", 
             RowBox[{"-", "1.5"}]}], "}"}]}], "}"}]}], "}"}]}]}], "}"}], 
    "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", 
       RowBox[{"-", "5"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "5"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", 
       RowBox[{"-", "4"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "4"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportConicsToTikZ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", 
          RowBox[{"y", "^", "2"}]}], "==", "1"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", 
          RowBox[{"y", "^", "2"}]}], "==", "4"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "2"}], "/", "9"}], "+", 
          RowBox[{
           RowBox[{"y", "^", "2"}], "/", "4"}]}], "==", "1"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "2"}], "/", "16"}], "+", 
          RowBox[{
           RowBox[{"y", "^", "2"}], "/", "9"}]}], "==", "1"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}]}], "}"}], 
    ",", "\"\<conicas3.tex\>\"", ",", "grid", ",", "estilos", ",", "ejes", ",",
     "texto", ",", "xmin", ",", "xmax", ",", "ymin", ",", "ymax"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9672969931877527`*^9, 3.96729713382244*^9}, {
   3.9672971913491163`*^9, 3.967297241204265*^9}, {3.9672972764155407`*^9, 
   3.967297319270093*^9}, {3.9672973494246273`*^9, 3.9672977618279123`*^9}, {
   3.967458413938884*^9, 3.967458427169221*^9}, {3.967458742895645*^9, 
   3.96745874956708*^9}, 3.967458790705991*^9, {3.967460652816461*^9, 
   3.967460653116658*^9}, 3.9674640855701*^9, {3.96747364065193*^9, 
   3.967473640874552*^9}, {3.967473815849801*^9, 3.967473816406728*^9}, 
   3.967473917310505*^9, {3.9674739503718033`*^9, 3.967473953239223*^9}, 
   3.9705937903994713`*^9},ExpressionUUID->"8e74580e-5ec6-49ce-9307-\
d62aa579270d"],

Cell[BoxData[
 GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJx1lmtIk2EUx60owTD1UxmiXYTqi1A4CDJOJnQjsrQGWqhdVLqXZBGmoUWE
iS3zEpWEmpZYoRmCMTuWYFGNrrMP4dQy0W1uEUSiUW3Pc/4bDHp5xwPv+1zO
+f9/57xbuOdoSvb0oKCgUs/PO67vnRk5d5+Tr1prjafS+2m3xbrLYnXyq47D
nz03Zfbvz79jHefTxxM9Mz/R2YFfhQO/xrkyO606O62PjPbkZmp0cUnsxorY
je+ppMFZ1OB08cmDi0wHF72lY8aitTer3PzuZfLF9h89VD2Z6lnh5jw1/xkt
nGqLmWpzc194hOd6Sn/V5eYF3tcVlQlB6vrOenxrxnv1+vagOUbWh0Wo9Vwp
+z/U+/MROT/qlTqfz0p8Jh0fp0j89Tp+Pin59er8eKfkb9L5c5ro49D68FrR
767Wj7+q5w4ONt8sqUkd5C0tq+67Htl5lmfWLtMQL308Wn8pzs7X1XlfuKRs
9oq4F6OckXQ69JthmJ+obUe4XJ0/wur4Wv+I55iHddgH++IcnIs4EBfiRNzI
A3khT+QNHaALdIJuZ8ZqisZq/LpCZ+gOH+BLxmRj5mSj3zf4CF/hM3wHB+AC
78ENOAJXWbI/uAOH4BKcgttiiR9cg3NwjzpAXaBOUDeoI9GXoO/veUp/2iH6
l2p/KF78MWr/qFT8u6z9Jfhr1b7TN/H/gX5Ot4SDAr2OcoWDZXpfAgcb9LkU
Lhx80HHRYuEgQcdNZuFAfCdwYNR5U5NwUKh1oWvCgfhOPg60rtQsHORp3em1
9oEztS8EDqK1b7RJOJjQvlKdGkO7xGcad3kvG7iggH5AFsXBFTPWb1bvQ1Yv
kP0j9P60W84HJyckvmLhRLglEziR/MDJBck/RzhJF33KhRPhgsBJouh7RzgJ
0J+SxR+pUzKIf+DknPibKZzA/zrhxCZ8YJyTE3ZtddaIb16UqpdhWjLfkbS3
cJTOJ6303MN0t+yl5x6lNz3e6yut8U6LHfOduyraEnMowU4pkVXbIquG6EZL
5/WWTjtlBOdvDc4f9OXxXek9QP3b5+e52h0UMqPg+cduG60ztJ7aHOqkwr7Q
phe5/XSvt6ubD/h1KZjW1hw/7KSJbttyQ+snyvE+7fDrCF2hM3T3fWfEF/gE
3+AjfIXP8B0cgAtwMvEfrgK5+/nHO0Z1Yf57tf9Dbvzj/fL4OQbX4Bzcow5Q
F6gT1E1AP/XVGeoOdYi6DOjXvjpGXaPO4Rf6APoC+gT6BvoI+gr6DHhCH0Jf
Qp9C30IfQ19DnwNX6IPoiwHfSwr8P/IPohrL0A==
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138}]},
        RowBox[{
          RowBox[{
            SuperscriptBox[
             TagBox["x", HoldForm], "2"], "+", 
            SuperscriptBox[
             TagBox["y", HoldForm], "2"]}], "\[Equal]", "1"}]],
       Annotation[#, HoldForm[$CellContext`x]^2 + HoldForm[$CellContext`y]^2 == 
        1, "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJx1ln1MVnUUx7E02xyZfxVggUDrZc7NZ9C0YIeCf2xspBYCWlqEGcpSNibm
gEBXViyNAoyXf3TyItkEGQsHO4/oSGEYSJjKFJBCJwrIew8Pz43nnvO9f9yt
u7Efz72/l/M75/M956z6+PNNKU/4+PhULfyZY095/P6kR/xW6xK/5z5x82BD
Wm9D2jBv7ejZ1tHj5qP7vF/u8dbbn2VU9szzrymJRSmJQ/xF30xW38w8l4Ru
KAjdcJc3P4irplMePro7+Nju4H7OOfkw++RDD0+2xR05N97Ne+Oz3y4rNPiE
Of8aF7q8KwxeYT5dHDRXGzhXa7D5uaC/yUcepwyd1u9vzQl5EfideND/o8bK
CzTw2q2frw0bnG5+b6GsGL9bvz0weOBK6oHkxRcpvj0g5Ph9g9P2xLweHNBF
RpdnV069wXliDxWpPc+PXRlw9HfTix2BeyJKDN7ZnJy6Y/QG1eR6/zG43fRP
L3VORPwxEWFwz9etrs6EPmppfzVz/RKDO/Zeqn/Z0U8vVUT+kDvpYbH3Lr2v
/ikU/1G2+u+w+Jc+UP86nXfWhp+9R+neUxrmuVviQZmLaqvD/nZzucSLYjRe
s4b3GaXe9/zTR87N8TtLM95dmjFGfea6OY71K9zoV/iYymsaS2oaXfy9ac84
rTcv6GLnRe8zQbFet4f+y19GrzscvW6Sfslvq8pvm+UgMx6TFOI/HJ2cNcs+
O5cfj9wxTedNN0zzTa/Z5dM0ICPXyXt6WubxSllHr8g+nJO/zLHm8iwlRx/w
/Sd8kmPkXGoTOzhM7KIisZOLxW6Kl3vwX3IvSpB78nW5Ny02cRhjR/jZ/bG+
btr45MHf/3SOcHVrs5NT3XTkum/F5U8fcYb4kcB5qviZhsTvnCBxoFLlXuNE
xcq9ck7gPljiTEMSd74gHNAN4YKvCic0LNxwlXBEpcIVBwpnpNxBFwSdzAun
VCHcsnJMg8I1n/L8tLDCoDrhnt0mDwZNebzDymbVSdQbq2fCWtL7oKMom66i
ONOro9wmrI81XwdEVuj+0NUWPb9EdeVR+75RXU2tSNk1eNog6CpI7zc+Kro6
rffPVV2pjgi6uqT+O6O6ClH/3lRdqY4IusrT+GSrrpI0fpq3aLvkMYKONM9R
peoIPL3QVJZXvHmM4mrePDNS76KnFmZtO/aYHOfvn/hujYugm0PK73bhl8B7
mXn+NN1RPWDEe8zDOuyDfXEOzoUdsAt2wm7cA/fCPXFv+AF+gZ9s+cjyK/wM
vyMOtnxnxQ1xRFwRZ1s+tbgAJ+AGHIErcAbuwCG4/D9u7VyDe6yHLqAT6AY6
gq6gM1t9snQJnUK30DF0DZ1D98gDyAvIE7Z6aeUV5BnkHeQhWz2mOq3XpPFX
Pqy8uEz44VjlB3l0tfKFvIs8XCp8WnkbeRx5HXn+R+X4K1nHScrxWtnXqiub
5FxepByjDj2jHKNuoY4pt1adQx1EXUSdRN1EHQXHudpnHJK+g/Zpn3FV+g6r
roPLVdpnTD1r9h2EPkLsL7D6Cnvfgb4EfQr6FvQx4AZ9Dvoe9EHoi9AngQP0
Ueir0GdZfZf6BxygT0PfBv8uVw40b7DmEcSdwUGexu9D5cAWX76t8ceI95iH
ddjHxpd1LuyAXbDT3m/+Bz+Poso=
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168}]},
        RowBox[{
          RowBox[{
            SuperscriptBox[
             TagBox["x", HoldForm], "2"], "+", 
            SuperscriptBox[
             TagBox["y", HoldForm], "2"]}], "\[Equal]", "4"}]],
       Annotation[#, HoldForm[$CellContext`x]^2 + HoldForm[$CellContext`y]^2 == 
        4, "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxdlgtQVGUUx1eDXaeh1IyH4CtQskkkicYcwfMJjmCizlgODvgolAgTNQ2z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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
          180}]},
        RowBox[{
          RowBox[{
            FractionBox[
             SuperscriptBox[
              TagBox["x", HoldForm], "2"], "9"], "+", 
            FractionBox[
             SuperscriptBox[
              TagBox["y", HoldForm], "2"], "4"]}], "\[Equal]", "1"}]],
       Annotation[#, 
        Rational[1, 9] HoldForm[$CellContext`x]^2 + 
         Rational[1, 4] HoldForm[$CellContext`y]^2 == 1, 
        "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxdlwtQlWUax8+Bc0GFcwRytnVWy8sibaWgm1oxvA+VCuUFHWeN1RHMTF0l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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
          180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
          193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 
          206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216}]},
        RowBox[{
          RowBox[{
            FractionBox[
             SuperscriptBox[
              TagBox["x", HoldForm], "2"], "16"], "+", 
            FractionBox[
             SuperscriptBox[
              TagBox["y", HoldForm], "2"], "9"]}], "\[Equal]", "1"}]],
       Annotation[#, 
        Rational[1, 16] HoldForm[$CellContext`x]^2 + 
         Rational[1, 9] HoldForm[$CellContext`y]^2 == 1, "Tooltip"]& ]}], {}}},
  PlotStyle -> All,
  AspectRatio->1,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "GridLinesInFront" -> 
    True},
  PlotInteractivity:>True,
  PlotRange->{{-4, 4}, {-4, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.967297141227436*^9, {3.967297212485795*^9, 3.967297241989087*^9}, {
   3.967297325093807*^9, 3.96729740184788*^9}, {3.967297775743989*^9, 
   3.9672977960337152`*^9}, {3.967458367190812*^9, 3.967458374852035*^9}, {
   3.967458416062667*^9, 3.96745843021192*^9}, {3.9674587245811462`*^9, 
   3.96745879193141*^9}, {3.967464079888261*^9, 3.967464086907612*^9}, 
   3.967473641305861*^9, 3.9674739723692217`*^9, 3.967475260696147*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"2b31bc84-a66b-49fd-995e-604020cbf62d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"thick\"", ",", "\"cyan\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dotted\"", ",", "\"black\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dotted\"", ",", "\"magenta\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thick\"", ",", "\"blue\""}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "False"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"Sol\"", ",", 
             RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"Planeta A\"", ",", 
             RowBox[{"{", 
               RowBox[{"0.7`", ",", "0.7`"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"Planeta B\"", ",", 
             RowBox[{"{", 
               RowBox[{"1.8`", ",", "0"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"Cometa\"", ",", 
             RowBox[{"{", 
               RowBox[{"2.5`", ",", "1.2`"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"Planeta C\"", ",", 
             RowBox[{"{", 
               RowBox[{"3.5`", ",", 
                 RowBox[{"-", "1.5`"}]}], "}"}]}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", 
     RowBox[{"-", "5"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "5"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", 
     RowBox[{"-", "4"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "4"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.967297141227436*^9, {3.967297212485795*^9, 3.967297241989087*^9}, {
   3.967297325093807*^9, 3.96729740184788*^9}, {3.967297775743989*^9, 
   3.9672977960337152`*^9}, {3.967458367190812*^9, 3.967458374852035*^9}, {
   3.967458416062667*^9, 3.96745843021192*^9}, {3.9674587245811462`*^9, 
   3.96745879193141*^9}, {3.967464079888261*^9, 3.967464086907612*^9}, 
   3.967473641305861*^9, 3.9674739723692217`*^9, 3.96747526069823*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"294b37a1-2c8f-43e3-bfa4-732e68e00c8d"],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/conicas3/conicas3.\
tex\"\>"], "Output",
 CellChangeTimes->{
  3.967297141227436*^9, {3.967297212485795*^9, 3.967297241989087*^9}, {
   3.967297325093807*^9, 3.96729740184788*^9}, {3.967297775743989*^9, 
   3.9672977960337152`*^9}, {3.967458367190812*^9, 3.967458374852035*^9}, {
   3.967458416062667*^9, 3.96745843021192*^9}, {3.9674587245811462`*^9, 
   3.96745879193141*^9}, {3.967464079888261*^9, 3.967464086907612*^9}, 
   3.967473641305861*^9, 3.9674739723692217`*^9, 3.967475261023354*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"7def601c-e352-4026-98d4-9ab44bb7e5aa"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967297141557365*^9, {3.9672972128596277`*^9, 3.9672972423167973`*^9}, {
   3.967297325421565*^9, 3.96729740217844*^9}, {3.967297776080353*^9, 
   3.9672977963598633`*^9}, {3.9674583671934032`*^9, 3.967458374854944*^9}, {
   3.967458416065555*^9, 3.967458430214747*^9}, {3.967458724881624*^9, 
   3.967458792263582*^9}, {3.9674640802173634`*^9, 3.967464087236521*^9}, 
   3.967473641632287*^9, 3.967473972698244*^9, 3.967475261024209*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[20]:=",ExpressionUUID->"0e60d4b9-44ab-4809-beb8-c251d2a04d16"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967297141557365*^9, {3.9672972128596277`*^9, 3.9672972423167973`*^9}, {
   3.967297325421565*^9, 3.96729740217844*^9}, {3.967297776080353*^9, 
   3.9672977963598633`*^9}, {3.9674583671934032`*^9, 3.967458374854944*^9}, {
   3.967458416065555*^9, 3.967458430214747*^9}, {3.967458724881624*^9, 
   3.967458792263582*^9}, {3.9674640802173634`*^9, 3.967464087236521*^9}, 
   3.967473641632287*^9, 3.967473972698244*^9, 3.9674752610245953`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[20]:=",ExpressionUUID->"0cb3de6c-3ab8-4b38-8e3b-50ecc3adcc65"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967297141557365*^9, {3.9672972128596277`*^9, 3.9672972423167973`*^9}, {
   3.967297325421565*^9, 3.96729740217844*^9}, {3.967297776080353*^9, 
   3.9672977963598633`*^9}, {3.9674583671934032`*^9, 3.967458374854944*^9}, {
   3.967458416065555*^9, 3.967458430214747*^9}, {3.967458724881624*^9, 
   3.967458792263582*^9}, {3.9674640802173634`*^9, 3.967464087236521*^9}, 
   3.967473641632287*^9, 3.967473972698244*^9, 3.9674752610250597`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[20]:=",ExpressionUUID->"4602118c-b331-47ef-b070-a956f6798bef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967297141557365*^9, {3.9672972128596277`*^9, 3.9672972423167973`*^9}, {
   3.967297325421565*^9, 3.96729740217844*^9}, {3.967297776080353*^9, 
   3.9672977963598633`*^9}, {3.9674583671934032`*^9, 3.967458374854944*^9}, {
   3.967458416065555*^9, 3.967458430214747*^9}, {3.967458724881624*^9, 
   3.967458792263582*^9}, {3.9674640802173634`*^9, 3.967464087236521*^9}, 
   3.967473641632287*^9, 3.967473972698244*^9, 3.967475261025362*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[20]:=",ExpressionUUID->"f3f33398-2792-47b6-bce8-5e836a2af7a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967297141557365*^9, {3.9672972128596277`*^9, 3.9672972423167973`*^9}, {
   3.967297325421565*^9, 3.96729740217844*^9}, {3.967297776080353*^9, 
   3.9672977963598633`*^9}, {3.9674583671934032`*^9, 3.967458374854944*^9}, {
   3.967458416065555*^9, 3.967458430214747*^9}, {3.967458724881624*^9, 
   3.967458792263582*^9}, {3.9674640802173634`*^9, 3.967464087236521*^9}, 
   3.967473641632287*^9, 3.967473972698244*^9, 3.967475261025653*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[20]:=",ExpressionUUID->"e92eff27-ecfe-4201-985c-dfb7d8282965"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967297141557365*^9, {3.9672972128596277`*^9, 3.9672972423167973`*^9}, {
   3.967297325421565*^9, 3.96729740217844*^9}, {3.967297776080353*^9, 
   3.9672977963598633`*^9}, {3.9674583671934032`*^9, 3.967458374854944*^9}, {
   3.967458416065555*^9, 3.967458430214747*^9}, {3.967458724881624*^9, 
   3.967458792263582*^9}, {3.9674640802173634`*^9, 3.967464087236521*^9}, 
   3.967473641632287*^9, 3.967473972698244*^9, 3.967475261088883*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[20]:=",ExpressionUUID->"ba206f11-e5bc-49b7-a39d-6606a86d31a7"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967297141557365*^9, {3.9672972128596277`*^9, 3.9672972423167973`*^9}, {
   3.967297325421565*^9, 3.96729740217844*^9}, {3.967297776080353*^9, 
   3.9672977963598633`*^9}, {3.9674583671934032`*^9, 3.967458374854944*^9}, {
   3.967458416065555*^9, 3.967458430214747*^9}, {3.967458724881624*^9, 
   3.967458792263582*^9}, {3.9674640802173634`*^9, 3.967464087236521*^9}, 
   3.967473641632287*^9, 3.967473972698244*^9, 3.96747526209568*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[20]:=",ExpressionUUID->"b5428cd8-1e1c-41a1-a65d-6c5aef71eefb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", "\<\"/Users/enriquevilchezquesada/Downloads/conicas3/\
\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/conicas3/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967297141557365*^9, {3.9672972128596277`*^9, 3.9672972423167973`*^9}, {
   3.967297325421565*^9, 3.96729740217844*^9}, {3.967297776080353*^9, 
   3.9672977963598633`*^9}, {3.9674583671934032`*^9, 3.967458374854944*^9}, {
   3.967458416065555*^9, 3.967458430214747*^9}, {3.967458724881624*^9, 
   3.967458792263582*^9}, {3.9674640802173634`*^9, 3.967464087236521*^9}, 
   3.967473641632287*^9, 3.967473972698244*^9, 3.9674752620983543`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[20]:=",ExpressionUUID->"f9b6a3ad-3495-4068-831f-0889b9ba5c9e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"conicas3\"\>"}],
  SequenceForm["Archivo: ", "conicas3"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967297141557365*^9, {3.9672972128596277`*^9, 3.9672972423167973`*^9}, {
   3.967297325421565*^9, 3.96729740217844*^9}, {3.967297776080353*^9, 
   3.9672977963598633`*^9}, {3.9674583671934032`*^9, 3.967458374854944*^9}, {
   3.967458416065555*^9, 3.967458430214747*^9}, {3.967458724881624*^9, 
   3.967458792263582*^9}, {3.9674640802173634`*^9, 3.967464087236521*^9}, 
   3.967473641632287*^9, 3.967473972698244*^9, 3.967475262099893*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[20]:=",ExpressionUUID->"a23bd536-2a13-4a08-af9c-37de8583b67b"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967297141557365*^9, {3.9672972128596277`*^9, 3.9672972423167973`*^9}, {
   3.967297325421565*^9, 3.96729740217844*^9}, {3.967297776080353*^9, 
   3.9672977963598633`*^9}, {3.9674583671934032`*^9, 3.967458374854944*^9}, {
   3.967458416065555*^9, 3.967458430214747*^9}, {3.967458724881624*^9, 
   3.967458792263582*^9}, {3.9674640802173634`*^9, 3.967464087236521*^9}, 
   3.967473641632287*^9, 3.967473972698244*^9, 3.967475262899352*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[20]:=",ExpressionUUID->"b015cd9d-4241-4b0d-8ca4-f3e261e89b63"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/conicas3/conicas3.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/conicas3/conicas3.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967297141557365*^9, {3.9672972128596277`*^9, 3.9672972423167973`*^9}, {
   3.967297325421565*^9, 3.96729740217844*^9}, {3.967297776080353*^9, 
   3.9672977963598633`*^9}, {3.9674583671934032`*^9, 3.967458374854944*^9}, {
   3.967458416065555*^9, 3.967458430214747*^9}, {3.967458724881624*^9, 
   3.967458792263582*^9}, {3.9674640802173634`*^9, 3.967464087236521*^9}, 
   3.967473641632287*^9, 3.967473972698244*^9, 3.967475262899913*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[20]:=",ExpressionUUID->"05776720-27da-4849-9fbe-89b9024ced4e"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/conicas3/conicas3.\
pdf\"\>"], "Output",
 CellChangeTimes->{
  3.967297141227436*^9, {3.967297212485795*^9, 3.967297241989087*^9}, {
   3.967297325093807*^9, 3.96729740184788*^9}, {3.967297775743989*^9, 
   3.9672977960337152`*^9}, {3.967458367190812*^9, 3.967458374852035*^9}, {
   3.967458416062667*^9, 3.96745843021192*^9}, {3.9674587245811462`*^9, 
   3.96745879193141*^9}, {3.967464079888261*^9, 3.967464086907612*^9}, 
   3.967473641305861*^9, 3.9674739723692217`*^9, 3.9674752629116173`*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"a3be0705-2fc7-44e5-8c81-495897ea2875"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 4: varias c\[OAcute]nicas", "Subsection",
 CellChangeTimes->{{3.967295680579814*^9, 3.967295688242674*^9}, 
   3.967295719458274*^9, {3.967474024112656*^9, 
   3.9674740298298483`*^9}},ExpressionUUID->"899facfd-3bb8-4347-8c96-\
cacd304db116"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"x", "==", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"y", "-", "2"}], ")"}], "^", "2"}], "+", "1"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"y", "==", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "-", "3"}], ")"}], "^", "2"}], "+", "1"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "-", "5"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"y", "-", "2"}], ")"}], "^", "2"}]}], "==", "4"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"x", "==", "5"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"PlotStyle", "->", "All"}]}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "4"}], "]"}]}]}], "}"}],
     "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<P. Horizontal\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"6", ",", "3"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<P. Vertical\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<C\[IAcute]rculo\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"7", ",", "2"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<x = 5\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"5.3", ",", "0"}], "}"}]}], "}"}]}], "}"}]}]}], "}"}], 
    "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", 
       RowBox[{"-", "1"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "10"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", 
       RowBox[{"-", "1.5"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "6"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportConicsToTikZ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "==", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"y", "-", "2"}], ")"}], "^", "2"}], "+", "1"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}], ",", "5"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y", "==", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"x", "-", "3"}], ")"}], "^", "2"}], "+", "1"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}], ",", "5"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"x", "-", "5"}], ")"}], "^", "2"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"y", "-", "2"}], ")"}], "^", "2"}]}], "==", "4"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}], ",", "5"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "==", "5"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}], ",", "5"}], "}"}]}], "}"}]}], "}"}], 
    ",", "\"\<conicas4.tex\>\"", ",", "grid", ",", "estilos", ",", "ejes", ",",
     "texto", ",", "xmin", ",", "xmax", ",", "ymin"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967458949134716*^9, 3.967459027720326*^9}, {
   3.967459071759989*^9, 3.9674590970531263`*^9}, {3.9674594354664183`*^9, 
   3.967459437241929*^9}, {3.967459508130843*^9, 3.967459508712741*^9}, {
   3.9674595408130283`*^9, 3.967459548251939*^9}, {3.967459585390415*^9, 
   3.967459604549168*^9}, {3.9674596658040037`*^9, 3.96745967875946*^9}, {
   3.967459741950267*^9, 3.9674597424546623`*^9}, {3.9674598092151203`*^9, 
   3.967459818772814*^9}, {3.9674598852880297`*^9, 3.96745993122128*^9}, {
   3.9674599822112093`*^9, 3.967459999188642*^9}, {3.96746004716756*^9, 
   3.967460061048337*^9}, 3.967460111844652*^9, {3.967460645996541*^9, 
   3.967460646313993*^9}, {3.9674637056068563`*^9, 3.96746386085017*^9}, {
   3.9674736137413*^9, 3.967473613978505*^9}, {3.967473822181622*^9, 
   3.967473822795788*^9}, {3.967474051208601*^9, 3.967474061538557*^9}, 
   3.970593797585946*^9},ExpressionUUID->"b010f8d4-e000-4621-be90-\
3bd298132c1b"],

Cell[BoxData[
 GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJxVVwdUVEcX3qUviGyhCkhZEKRGokSDOlc9AUFEVFARQQjYEBCjWGIHQQkB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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
          180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
          193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 
          206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
          219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 
          232, 233, 234, 235, 236, 237, 238, 239, 240, 241}]},
        RowBox[{
          TagBox["x", HoldForm], "\[Equal]", 
          RowBox[{"1", "+", 
            SuperscriptBox[
             RowBox[{"(", 
               RowBox[{
                 RowBox[{"-", "2"}], "+", 
                 TagBox["y", HoldForm]}], ")"}], "2"]}]}]],
       Annotation[#, HoldForm[$CellContext`x] == 
        1 + (-2 + HoldForm[$CellContext`y])^2, "Tooltip"]& ]}], {}}, {
    GraphicsComplexBox[CompressedData["
1:eJw9WAlYjOsXn6WapqaZb2YsqStCUbqytBDXOYWuUJKsEddSipJE4WpBERNZ
blxr8VeK6koJKbooSxvJEiqJCrdmampqpqn/LN/M97zPfM88M+/5zvmd3/md
837m67Z6baRRKJQhVApFeVdfg1BzvyDQGbGmgo8/fjvksMKFjxWR5ktPlfDR
7cQYxeJjua79wzuFfOx5mtFe3sdDJ/fMZkY+H+c3ePx5pZGH9jMnx9Sl8zH4
w+2gD7d5SPko9w6/yMcn1f88Sd/Pw8KikriR5/nomlsqatvNw3NylxvjEvio
Mu/Gw8SoH5LRsXwsudfcNsaCh8H1SU7DdinshYfkTenhIq1w8dvQED4qrQd9
4OLI0e/PVm3mY2mKmXFyieI7xb+Nu5SPyl0RO7gY8OcGxRY+qtwJ4pLP4ePD
F1YR0+ZwsaBlO233VD6aLvvWPsDk4pKcGGMrez6JBxdlux8czZ3ERzjbIG8X
ERj53aeVY8bH51PvLR11g8DPq1MEewfzUWX2BIHnhYYmx1h8lFgxdrYHEYg/
Z1VdpfNxl8nRwtkeBAYxiymvung4V+UIgS+9ecWrm3jI6UmW21dxsDe3Iczy
DQ9rVf5ycGrFbI/gch6OGzppZ6ElBw+HDA2NeMDDqrr+5pinbIxdS2ndrcB5
tOr5bDRLpAW/vslDSee2suAtbOS2ubDbT/NwVPCYuMuFRkiwRq6uTOLhFhUg
Rkj3epjgpPheUpUzamSOERkHDxsH3T+/77QR7ohfYagbxsM8Fd4sDBxfTOEG
87BmyG4LSTYLf2/oPX5hlYIHTbf/9EcWMpddjD3sxcP+AeVliPcOXY6pnMXD
YcMyt75OMcTg6IKl+cDDJbcFqWkHDVFl1oGHpYp06C40RPkrW8XS4GOI+/aZ
Nlab8zDuxtusoVUGODv2knz9UB7qh9k1Gx83wMTvvFtDDHh4XOW4AZ6JbD0d
2cpF5efpSCaeyfPE0m9cEk8mluXdkAubuCg4GRq3YB1TyyMLxeNtxzJxOS/d
5ukTLibtVzJTH2+f/DHR5yGXxEUf77VcPjLhHhePpccUrg/Ux28j3t38fJWL
lC3eRsMlDCzxed+ceJarjus2A/+8bvfENp6LKzvMc6y9GbjjV4ajLJaLqr87
M9Q8i+aq7yMZeIc6y374di7plx46+P7jk76Bi1NuTHGKPaqHXyiRTYXeXMw/
cPG/8ml6GOj0jffZjYsquAd0MaHX8ip9Fhezhssl4R908fGbfIVFjf+6ZB1z
0aNYWQC6eGyJhf8Ecy4edS4sujJOF/0XV55fNZJL4q+LAvFHQncEF/2mb3rV
MlwXXZ9xXrsYaOLTwQPOneGZNC7mZu4B26M6uCmZMmpMP4HTM2tXuoTroAV4
GlqJCbLudNCr76fzvSYCA3+rvn+wj446eYkunDqCjJeOHivtP/W9J7CmRNDt
UEpX73tGoIqO2+kYevmr9FMpQdYzHa/Yln6ckUfgT4vK941D6di87nKwYxqB
fk2ONW5vaWiSaMxISyLI+Gm472Nb6vZjBK7aZy0vC6Dh2vHmn7ZEEyQuNPyo
skvgUmGogW8FFUMT3OP8Agj0xoxk/ftUpBQLbk/YRJD6RsUXD9MPU/0IFJhM
3n4uk4reyn0emnip2GZQtnm0M4EpNfSQHwQVr41Y4ZtgR2C+Kl4K1obatnHM
CFy40Prsuz0U7POAnPsmBOkHBQMPzVvUYEygMHA1VGykoIVKJglk+Soy6EbB
Hw9Ywdf6OaReUdBzkU1ibDsHk+czRy17OACO1/wWP/ik0JVw/ZBjuwbgpApP
DrYoAR07AM221SW+Tzlk/APQXatTm5zDwcdTtjbVv+yHq+P1XtRf4OD+vX7z
2/f1Q/2d6Yd/JnDI+Poh6EXktSVxHBwKFfZ/j++Hj6Ru7TBQOiiHiAVGP4cv
5pD5ksOR2PGKxcHY/M8H8j/3wTRvm03swRwyP30QkbXpXUwzG3kguDdDJAOZ
z/ym/jdskm8yMK2tMKmtYKMjcVaxZKDOAxv/Vem5DJ7NW5pz4i82yScprDCf
2HZzPxtfirfk61+UwmPL5+lEMBvL3rXkr1gmhTnjXLiHPdkkflIgOpe83cNj
o1VrUeRDp1449Gzw4yYDNolPL7TcvGi3Up+NU0b7hQhMekG9T7O/F7zivzV3
nzPC+jqLJ8VfJfDFsqw9cJsRmU8J7P4+NNHAzwhtknbMZs6XgBpHI5yQ1vB1
UF83XNxVbtplY4SRbg9zTHO7wfTYN46DmZE67ye6QeAh3SmTsvDAHopjpF03
SGbMzY3qYOGjZWYRr826IWndvjbrJyySn11wQuTd5ZPHQi/u2fePBV0QGN1+
svEMi8xfF6jtsnChSg+6oPTRcOmZnSwUo//+tD4x1FQyN0f4s0i+itV4O7Bw
l0Iu00LEMEWQlCKyZ2FhozSgMlgMKXFpCbOmsDAqv5jqHyCGm8/LZ8fKDUl8
xHBHZccQ1yoF6E4nAFFBrcswxDDauSXvfDuhynLQ6KGKvqDGuxPmkX1gjUqw
OsDOdPfrrTxD5LtnH2j27YBfq2iKZUjG00Hyz0Adzy4RHLkb9jZskwHOcN/I
1wsTQW9wz6LV6wxIPopI/jDRVon/fSFUx5y3vpjCxOu5kR+eXBfCqbeevrN2
MUl+Csl8M9XxoBAybmaafMjQx9eXhuUyhgthTI7x51/O6mOL2ZeNusZCMr/6
qJZbIaQnG2QkG+ijWQNVsYSwcEURd9UrBgYduiMsoiv2q57DwO3K+jEUwq14
zIpHBqnHQkj1efGscioDBSeu5H+3FMK3nuUBjyYz0OyyrHmPlRDyyb4xWKmX
i4VA/zJq0v27erhghumB2gDS/2g9tf+JQriUIK1w3aunjS98U43NIDc9LP5S
Zm9cJCTx18NUJTwfhTBi4p6HP6nkfooIrJa0PZryRRfdnUqC54wQwd64mbMu
pehq8VXnQxeV0dumieBgbvbclxN0cU1Bf1aGXARjxpWnmg7oaPMXTPYVlfc5
HfCvVfkROK6DgwuvVodIOiBCdelo+aH2Q0fLry8nzJf/fo6u5esMIodjGknH
720d32QmXWQ+6GqdPtoFW+8aV9lMo2vrZWKcblcinY5DjqTZvZjZDRey9pZd
aaRp60/TR/5erDQggZVrIsvCjtLwu+P9bWYBEqg45Di6TkDT1jtvUqpIL56G
ig/j6ggJEDrOikUj4+0Bl3JP6+mjafh6ItPT41IPLI6aJ7fqomr1Rq1jVKxQ
Ari1F45b5nu+v0dFBjc4tvldL0TB4acvs6ha/Wp1+6Uj9xQVrX2/3vnkLYXf
C1wT3TdTtXro0lV0y2k5FefePEXfPEwG6udQUaRsW8UysPq3cPawXgpuWLjX
y8y3Dz6EjxVd/k7R6vOxljWWAc8pSJ8bGbO7vw/SXHv0Hz+j4IJjU30eUOTg
vlDCqMikaPVeapdU8995CvrFvHRakyqHmfOmuW8JpWAMFjAjZ/XDA8tSs94Q
iraffCD7HkNZkN794BQ9R7EoWOApvucp7of4UDvnpFEUrN97ftPdyAEYmfyc
K6VStP1vkOFnvuHnAZj99yjFoqD3NBfAvwZA00/V9gdAT2n/FAVnv410v+g0
ACESV8GwMgqWqYg6AJr+zCxfKfLmDwCnOXPIkW4K1mWenpl2rh8K3qUXvQmn
ok6wzX6vP/pBMw+o3ehX83IkDcMHX7j5pU8Oi3OqN1xR5Bk4V+cVSeXgmSYY
sLBU8GLZNpd5F+VaXmWbcgdO+cuhxTx2gesrGkq/n3bbosDZQ+9n6xx3Oq47
W9CQ3dgHmvlH/b8++PO4g11rNF2bpzBV/6Xj4SpvWU1sH2jmq6uTYgS1zn3g
FZixgT5JB+ceSK3NntAHmvmsOWon6yCnD0QN+WW+IYr5bu562rA8GRjz/jF0
bNTBC1O3NT6Ol4FmPrxbP2fdLWsZLDSuCQhN1MX1a+ZELBsng/q7eTmBJzXz
pgyU3lid0UVHX9PshLdS0Myry90bLlGvSMHmMri8c9XDBxGpVW+XS+FAUcnk
mgw9PDn696O/TJOCZh62vrSHaBguha3X3GKWSPXIuu0Flb7GMjA8wKiGeq4X
fpuWL4jOYuD/HHILfP/qBc08vneKn229oBcqjSq/bX/EwP+ylm30ovaCZr6f
wE+qW/S8By78aLGH9/qYlbHL+faFHnhdXNzsO4yJU8fK2K5BPaA5T7yPXTto
p3kPGM/Mto6rZCIvR1JgxO6Bjx87H439j4lme7eLy19KQHM++eNqHWt5ugQy
TOfVf48zwE92aesn+kjgPjNm7sx+Aywb6rLu1zkS0Jx/1DzsBtVYWWyIcf5S
07CCbmifF79oU7fi9zcrN2fmdYPmvJVZE5i3MrMbqKeCo18ZsXDcjOr65A9d
IJ5MlQ4PNMKsPOWGLtCc/1ZlLr1eE9gFB/eM37bVgo3PiRtXymVi6DXZdbn6
Exsfye22Gv0rBs15lBXrkuI5Tgxxk8QT4xRza9DXAwqPxBAVE3H18ThCq8Pq
aiRQX5bpEJfaCZrz8bmVuQ7RCzphQ63/dP5XAv+4VXH+kF4nfJ00aN9mCy66
/nVoTXRZB2jO63W2wkafqA646bwgqiCFizMd3RuDWkWQ/G7h9AvjeWh7pEfH
65kINO8Prjvd9vLKVvT103dOilfzcCC2Inv5ChHsSvSsE2bxcJpqg6bv80h+
ikDVnhp4mFg4RiBpFcLayf31paZ8jGyfbeT8WQia9x/LE/bERNUIgbG46Vbw
RD7GPzholWIjhPUNbP3KWj7mLXPc/pihmRMG4f8By8+LtQ==
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[CompressedData["
1:eJwl1FV4EAQUBeANGIwYMAbSJV2ClKB0SIOMlkY6NiVEpbu7G6S7pTtFSulO
UTqVjn8fD/+5b+ft3PTNIsMjAgMCAj4RUTca0YlBEDGJRTCxiUNc4hFCfBKQ
kFASEUZikkT1kpRkJCcFKUlFatKQlnSk51MykJFMZCYLWclGdnKQk1x8Rm7y
8Dl5yUd+ClCQLyhEYb7kK4pQlGIUpwQlKUVpylCWrylHeSpQkUpUpgpVqcY3
VCecGtSkFrWpQ13q8S31aUBDGtGYJjSlGd/RnBa0pBWtaUNb2tGeDkQQyff8
QEc60Zku/EhXfuJnfqEb3elBT3rRmz70pR/9GcBABjGYIQxlGMMZwUhGMZox
jGUc45nARCYxmSlMZRrTmcFMZjGbOfzKXOYxnwUsZBGLWcJSlrGcFaxkFatZ
w1rWsZ7f2MBGNrGZLWxlG9vZwU52sZs97GUf+znAQX7nEH9wmCMc5RjH+ZO/
OMFJTnGaM5zlHOe5wEUucZkrXOUa17nBTf7mFv/wL7e5w13ucZ8HPOQRj3nC
U57xH//znBe85BWvecNb3vGeqPEHEo3oxCCImMQimNjEIS7xCCE+CUhIKIkI
IzFJAj/+lQ+JTYJf
          "]]},
        RowBox[{
          TagBox["y", HoldForm], "\[Equal]", 
          RowBox[{"1", "+", 
            SuperscriptBox[
             RowBox[{"(", 
               RowBox[{
                 RowBox[{"-", "3"}], "+", 
                 TagBox["x", HoldForm]}], ")"}], "2"]}]}]],
       Annotation[#, HoldForm[$CellContext`y] == 
        1 + (-3 + HoldForm[$CellContext`x])^2, "Tooltip"]& ]}], {}}, {
    GraphicsComplexBox[CompressedData["
1:eJxdV3s8VVkbPoTOOZxzXA/OTuU2FbqiKGa9SMmYqL4hvvqSrp9Qwmh0JSLD
JM103LpPQkaim0Z9ptOQSwqVexc+XVxSUi65fNvZa+0/vv1bfn7r7LX2ftfz
vu/zPNvQb+fqLYocDqeL/pv4v8rJw+bASR7wgqxWrzTqQ0HNNwKbb/Dg32mZ
9PiIFM/lzPJw40P69ap5iQa9qH574rPtiXwIlK/rQbG7uPRQhaqshIqshE6k
vylhfqmeKngUZnk/sehErskmK5JNVAG+2/q5uesdui+buFThhvwBr9E1UKWH
GoR6S8O8pR3IdMXEBjXYbe0VYu3VjgRdrqes9QUwe+qfhjVOr1CwPb/+wi4B
jMuvF4gjv4QwaHVvt7txCzqKFFabLhcCP8nMVjOiCSm7HFJyOSQEF3kcjahF
/mIR9Ne5o9H+OsTb2Oi5NFUEGXFvdBZI6lD5mig70wcikC9fUYvXq4OjoNtg
zaRKdN9caocS1EEynmSZZVqOGBzU8XlKkTx8Ew1AVs9iS4dL0MGqVbf3b9GA
/NznpiKVYrQ0Nf5N2lMNcHhkfVk2sxAx+zQg+DPPb/LNArQl/MmLwFYNaBnb
FT3wWwHyiCvs02rTwPEUMO9bqAnvT9vv/dKdjXLC6zxjfTWhor6o5uPvF5F8
WbImvFJbtVj68Cwq/qGHHpqw3v+wpv/hZPSPmrabffR86tm+b0WByYh5rhYc
mnJu2tmKSDS8xHv2zgQtmJ4d/nlHYBCaHFCiElCiBWCRfrDUyhvjrQ0medvy
9KtN0NCJiaHN3le5n1mbFKLN7mfqSZt9fu4cAxeBpg77/qU5mk459JzEx+Ct
w8bvGWeRveeMDnu+OgeDJw4GYhaP9Djz6clGYhYvpt7ELJ7FW8P0tpiJWbwj
LfOco9LEbD5uygEVs/k6IX+uLptPuyfbZSUhumy+GXx12XqY8uzuxh5Kj62X
fe4nnqy31GPrifldj6230eb/0EOPrUc733HPwBY9tl4ZfPXZenZ5FaGdt1yf
rfef4n3mbwnRh7m4Hxh89WGvZdvDuEXtKNX9Tor7HX2Q/xzYjjI3DF/cMKwP
4bi/psovCdt/DN4ScMX9GTPrcKQsRALzx/KEFN2/m7xMB+b8KMHn60Qh7Trf
X94ngcrZ9pKepE7kNlCk4p0tAaNMnZpTKd2oV/XoyIe7EpYfgu8177rXLIGr
PtpXfLR7kbg5XS+lVwICc9d2Y60PSO1lhf7fHAoYXD/g/FFQzj/1F//URxQc
kRpkbk1BhlnF6ZWGfWjlX5Wz9thSOJ4+9Guy5bIRBwrU+2x/Lj7Wh246jqeo
rKPA1/RT49uIT0jS5bRp/3YKGFz7UWxHvPH9gxSUls1Ue97Uj5yHlBKb6Hmu
a4a0rLkfVR4xzrQ/TgGD62d0J8nrxoEcCjyCNwuWDX5Bvr/6990qpIDBbQAV
Vpi/HiiiYGXwssdKdwfQixNZ5Z7VFFy63SqaqTyEmrT0XXofUcDwwhC6JQeG
glTpmg+7+cPobNj7lyr/paA3MaKronQY7dt9S22QnjP5GUYKzv3+ZR0UpFzM
5zj3D6Pfhw4nLv9E8BpBl2V7Dzp8pqB2/08Bzo9H0HX3r9fcv1JQdWak/MzI
KDK6Kr3U+pXgNYbcov27to5ScGzG4tY/0sZQzmy7ZttxCrqrdEXinHE0kPLJ
5/YYwYsD5H68fuhgvxkHyH6bbj+N7AIOjPqVzz05QgHTRxwg75fkK1D5CgpA
4tN1kK1olSoAiZ/BVwHOhSpwLfro94sPWH9TqwB+1bG2015TsJa73jA0RhEI
Hsx5FeGfnGojJ3ouGVrZ2JahCARPS3n/KgLBm6n/SUDykWukMbhj/yQg+fIu
a5GOTlcCkk8GHyVI+PFa0IZcun4OaUzJiFQCmd18ac5pCjxNTI2zmpWA1AfT
v8pg59Mg27mfgkVRc7OtjykDqTemX5Xl6nYNKEi/XJR2uUgFtNtyR6JtSH5V
YO3z+vYSKwqGH3Q8a3ivAqT+HxRYVBZYTIZDV8y66hslkFJbVZhhwwXSXwwe
XLhTtre4bK8Eqp6ue/h0HQ9Cq23fZND9a1b327uKUB6Q/p4TmKnIi+HBNNz/
x+UP4APhh3Oz0s7PSuMD4Q8XrNuEXwxDYqsMFqhCBOafEJvjN1WvqMIKzE9j
8vOqAuGvjUWXNE7uVYMTFyZpB7XqQWrli+qPV9VgHPPfdfn51YDwY5SyeK1v
pABMurJlBQvo+cn7Yd3pAjDA/Bogj0MAhH8tkGF1hbsQ7DE/Cz+U7rsYKITa
aKQ15qYLxvJ1Qib+hbrYzwhhRpnv4Fm+LuS8qVTrqRAC4f+GPVYH8z8KwXXi
PGVifB4hRGG9SOPXHHk0TQRFWE/iVmW2FW0VAdGbH/J77y/3n/ARjB7x9rQ4
eewQQWG4G60UYmjCvkOuL+U6EM3T+sYtRQReWN/O6RXZBGSLgOhf1Z/iC+XF
InDE+mgx1GQ+1CSCPKyfJZKoV6bNInilTAuuug7GUwREb9crH5Xt6BUBF+ux
+Lzixc2DIhjEep2uNm9b44gIiJ53oerTeWP0eqz35P4g9gNkP/EL7f96ucH6
vQhWYz9B4rmL/QaJl/gRcp5s7FfIeYmfIXh8j/0OwWsz9kMET+KXCN7LsZ8i
+TiA/RbJF/FjxRlRNOMKcR2ps/Uhw36O1A/xe6S+/sZ+kNTfZOwXu4VOd4oy
BED8JKlfRew3SX033RqsN3YWsvVP/CrpjyDsZ0n/LC3LfZuiI4CpkZ7xC6+q
AvHDRrj/qn1j6KHG9ifxz+dx/8qwvyb9Tfz3PNz/etifm2N+iMH+vQLzxzPs
7wm/KGD/n4r5h3wfVGJ+It8PXzF/NSzJVPnyC4/lt3fSA/TgQRrmvwn1Vp7L
Y/nxg1XnrXAOD6iMrqGkZGUIE3zpcKXnOU3zrabQ8wl2jm7lsnwbceRUTc49
LnhhPn6rKTVyuMSFDZivod6M+iWFy/J5mn+WpXoCF3ww3zs05AWs3sSFHKwH
3zU83Gnoy2X1gtnHBXusJyXaxt/2LeICt8gxPo3Wm/EwXbNgKy4s+OPSwVZa
n06eUd/WMYPL6tkk8+Fjs1W5AI/5MekcBZinIU23m8wFsZ/90bZCDmhW67n+
rMhl9ZXcf7okpmdxyhgi+w9t6Pz8YGwUkecTvSfvT8N+gMTXg/0DiT8W+ws3
fD7iPxzx+bOxPyH4uGH/QvAj/obg6zjeUlY28gUR/FfdvF50xeUL2oHzQ/wS
mz/sp0h+K7DfqsL5J36M1Eel/PuxD5H6If7u/79P/wdeHnFz
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
          180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
          193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 
          206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
          219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 
          232, 233, 234, 235}]},
        RowBox[{
          RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
               RowBox[{
                 RowBox[{"-", "5"}], "+", 
                 TagBox["x", HoldForm]}], ")"}], "2"], "+", 
            SuperscriptBox[
             RowBox[{"(", 
               RowBox[{
                 RowBox[{"-", "2"}], "+", 
                 TagBox["y", HoldForm]}], ")"}], "2"]}], "\[Equal]", "4"}]],
       Annotation[#, (-5 + HoldForm[$CellContext`x])^2 + (-2 + 
           HoldForm[$CellContext`y])^2 == 4, "Tooltip"]& ]}], {}}, {
    GraphicsComplexBox[{{5., -1.}, {5., -0.5714285714285714}, {
     5., -0.14285714285714285`}, {5., 0.2857142857142857}, {5., 
     0.7142857142857142}, {5., 1.1428571428571428`}, {5., 
     1.5714285714285714`}, {5., 2.}, {5., 2.4285714285714284`}, {5., 
     2.8571428571428568`}, {5., 3.285714285714285}, {5., 
     3.7142857142857135`}, {5., 4.142857142857142}, {5., 4.571428571428571}, {
     5., 5.}}, {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}]},
        RowBox[{
          TagBox["x", HoldForm], "\[Equal]", "5"}]],
       Annotation[#, HoldForm[$CellContext`x] == 5, "Tooltip"]& ]}], {}}},
  PlotStyle -> All,
  AspectRatio->1,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "GridLinesInFront" -> 
    True},
  PlotInteractivity:>True,
  PlotRange->{{0, 10}, {-1, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.967463869091919*^9, {3.967463904996344*^9, 3.967463913393375*^9}, {
   3.9674731626111727`*^9, 3.967473187819058*^9}, 3.967473614904402*^9, {
   3.967474035308947*^9, 3.967474062254779*^9}, 3.967475272060753*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"891a55a7-a7a7-466a-9efd-9ad2021d1df7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "False"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"dotted\"", ",", "\"orange\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dashed\"", ",", "\"blue\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dotted\"", ",", "\"yellow\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thick\"", ",", "\"cyan\""}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"P. Horizontal\"", ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "3"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"P. Vertical\"", ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"C\[IAcute]rculo\"", ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", "2"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"x = 5\"", ",", 
             RowBox[{"{", 
               RowBox[{"5.3`", ",", "0"}], "}"}]}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", 
     RowBox[{"-", "1"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "10"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", 
     RowBox[{"-", "1.5`"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "6"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.967463869091919*^9, {3.967463904996344*^9, 3.967463913393375*^9}, {
   3.9674731626111727`*^9, 3.967473187819058*^9}, 3.967473614904402*^9, {
   3.967474035308947*^9, 3.967474062254779*^9}, 3.967475272063137*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"79aab704-1cd1-4f46-b4e2-4260d32cd368"],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/conicas4/conicas4.\
tex\"\>"], "Output",
 CellChangeTimes->{
  3.967463869091919*^9, {3.967463904996344*^9, 3.967463913393375*^9}, {
   3.9674731626111727`*^9, 3.967473187819058*^9}, 3.967473614904402*^9, {
   3.967474035308947*^9, 3.967474062254779*^9}, 3.96747527223201*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"9c69ecbe-0e01-4dc8-9f6f-cb412701fb33"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967463869282833*^9, {3.967463905187648*^9, 3.967463913585664*^9}, {
   3.967473162829067*^9, 3.967473188011239*^9}, 3.967473615076769*^9, {
   3.9674740354835777`*^9, 3.967474062427031*^9}, 3.967475272232685*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"bbb65395-3394-4a3b-af81-a2575d7a8b67"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967463869282833*^9, {3.967463905187648*^9, 3.967463913585664*^9}, {
   3.967473162829067*^9, 3.967473188011239*^9}, 3.967473615076769*^9, {
   3.9674740354835777`*^9, 3.967474062427031*^9}, 3.967475272233061*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"d11af9d5-ef57-45b4-8571-ca1f1cc07e94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967463869282833*^9, {3.967463905187648*^9, 3.967463913585664*^9}, {
   3.967473162829067*^9, 3.967473188011239*^9}, 3.967473615076769*^9, {
   3.9674740354835777`*^9, 3.967474062427031*^9}, 3.967475272233519*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"0acf16c0-6afb-4e3c-b5a8-caeb77a4bf22"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967463869282833*^9, {3.967463905187648*^9, 3.967463913585664*^9}, {
   3.967473162829067*^9, 3.967473188011239*^9}, 3.967473615076769*^9, {
   3.9674740354835777`*^9, 3.967474062427031*^9}, 3.9674752722338037`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"6f8086ec-ce44-4767-b8a2-2b011c44a6e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967463869282833*^9, {3.967463905187648*^9, 3.967463913585664*^9}, {
   3.967473162829067*^9, 3.967473188011239*^9}, 3.967473615076769*^9, {
   3.9674740354835777`*^9, 3.967474062427031*^9}, 3.9674752722340927`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"cb002607-3004-4e22-a287-9f896cc5da97"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967463869282833*^9, {3.967463905187648*^9, 3.967463913585664*^9}, {
   3.967473162829067*^9, 3.967473188011239*^9}, 3.967473615076769*^9, {
   3.9674740354835777`*^9, 3.967474062427031*^9}, 3.967475272319907*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"e368719d-b635-4db1-82ab-59292b895292"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967463869282833*^9, {3.967463905187648*^9, 3.967463913585664*^9}, {
   3.967473162829067*^9, 3.967473188011239*^9}, 3.967473615076769*^9, {
   3.9674740354835777`*^9, 3.967474062427031*^9}, 3.967475273326371*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"0f3f93f6-3912-486b-9624-8ec27d08facb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", "\<\"/Users/enriquevilchezquesada/Downloads/conicas4/\
\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/conicas4/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967463869282833*^9, {3.967463905187648*^9, 3.967463913585664*^9}, {
   3.967473162829067*^9, 3.967473188011239*^9}, 3.967473615076769*^9, {
   3.9674740354835777`*^9, 3.967474062427031*^9}, 3.967475273329733*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"b7990e1c-0874-4634-a198-f026a9e310c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"conicas4\"\>"}],
  SequenceForm["Archivo: ", "conicas4"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967463869282833*^9, {3.967463905187648*^9, 3.967463913585664*^9}, {
   3.967473162829067*^9, 3.967473188011239*^9}, 3.967473615076769*^9, {
   3.9674740354835777`*^9, 3.967474062427031*^9}, 3.967475273331407*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"acd7775c-98b4-4f4d-8a8d-76058dd8f9ff"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967463869282833*^9, {3.967463905187648*^9, 3.967463913585664*^9}, {
   3.967473162829067*^9, 3.967473188011239*^9}, 3.967473615076769*^9, {
   3.9674740354835777`*^9, 3.967474062427031*^9}, 3.967475274033017*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"2e7e49b0-c82c-44fa-85df-c1961a55c1c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/conicas4/conicas4.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/conicas4/conicas4.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967463869282833*^9, {3.967463905187648*^9, 3.967463913585664*^9}, {
   3.967473162829067*^9, 3.967473188011239*^9}, 3.967473615076769*^9, {
   3.9674740354835777`*^9, 3.967474062427031*^9}, 3.9674752740336*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[26]:=",ExpressionUUID->"1f2c75f6-a28b-4ff7-98f5-e326a9c0c885"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/conicas4/conicas4.\
pdf\"\>"], "Output",
 CellChangeTimes->{
  3.967463869091919*^9, {3.967463904996344*^9, 3.967463913393375*^9}, {
   3.9674731626111727`*^9, 3.967473187819058*^9}, 3.967473614904402*^9, {
   3.967474035308947*^9, 3.967474062254779*^9}, 3.967475274050023*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"b185fedb-6e4e-4b92-afc5-3d0369f47b0f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 5: familia de par\[AAcute]bolas", "Subsection",
 CellChangeTimes->{{3.967295680579814*^9, 3.967295688242674*^9}, 
   3.967295724306283*^9, {3.967458940874803*^9, 3.967458941970394*^9}, 
   3.967464073853581*^9, 3.9674739970805483`*^9, {3.967474078399375*^9, 
   3.9674740800449266`*^9}, {3.9674742622081127`*^9, 
   3.967474267247254*^9}},ExpressionUUID->"aa294ed9-0072-424d-8b67-\
43d0ff09ece9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"y", "==", 
       RowBox[{
        RowBox[{"0.5", "*", 
         RowBox[{"x", "^", "2"}]}], "+", "1"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "4"}], ",", "6"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"y", "==", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "0.3"}], "*", 
         RowBox[{"x", "^", "2"}]}], "+", "5"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "4"}], ",", "6"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"x", "==", 
       RowBox[{
        RowBox[{"0.4", "*", 
         RowBox[{"y", "^", "2"}]}], "-", "3"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "4"}], ",", "6"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"x", "==", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "0.6"}], "*", 
         RowBox[{"y", "^", "2"}]}], "+", "2"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "4"}], ",", "6"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"x", "==", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "4"}], ",", "6"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"y", "==", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "4"}], ",", "6"}], "}"}]}], "]"}], ",", 
    RowBox[{"PlotStyle", "->", "All"}]}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "6"}], "]"}]}]}], "}"}],
     "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<\[UpArrow]\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1.5"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<\[DownArrow]\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "4.5"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<\[RightArrow]\>\"", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "2.5"}], ",", "0"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<\[LeftArrow]\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"1.5", ",", "0"}], "}"}]}], "}"}]}], "}"}]}]}], "}"}], 
    "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", 
       RowBox[{"-", "4.5"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "4.5"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", 
       RowBox[{"-", "4.5"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "6.5"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportConicsToTikZ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y", "==", 
         RowBox[{
          RowBox[{"0.5", "*", 
           RowBox[{"x", "^", "2"}]}], "+", "1"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "4"}], ",", "6"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y", "==", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "0.3"}], "*", 
           RowBox[{"x", "^", "2"}]}], "+", "5"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "4"}], ",", "6"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "==", 
         RowBox[{
          RowBox[{"0.4", "*", 
           RowBox[{"y", "^", "2"}]}], "-", "3"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "4"}], ",", "6"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "==", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "0.6"}], "*", 
           RowBox[{"y", "^", "2"}]}], "+", "2"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "4"}], ",", "6"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "==", "0"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "4"}], ",", "6"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y", "==", "0"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "4"}], ",", "6"}], "}"}]}], "}"}]}], "}"}], 
    ",", "\"\<conicas5.tex\>\"", ",", "grid", ",", "estilos", ",", "ejes", ",",
     "texto", ",", "xmin", ",", "xmax", ",", "ymin"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967474183575549*^9, 3.9674741947496767`*^9}, {
   3.96747425278998*^9, 3.967474518152419*^9}, 
   3.9705938056251907`*^9},ExpressionUUID->"829104e8-6ca1-4dc5-b23e-\
472255228763"],

Cell[BoxData[
 GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJxdVmlQFFcQXnZhOQWUU40HBiVUYjSl8YhKd3lERaMgRNQyBtegETEmeFY8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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155}]},
        RowBox[{
          TagBox["y", HoldForm], "\[Equal]", 
          RowBox[{"1", "+", 
            RowBox[{"0.5`", " ", 
              SuperscriptBox[
               TagBox["x", HoldForm], "2"]}]}]}]],
       Annotation[#, HoldForm[$CellContext`y] == 
        1 + 0.5 HoldForm[$CellContext`x]^2, "Tooltip"]& ]}], {}}, {
    GraphicsComplexBox[CompressedData["
1:eJw1VgtMU1cYLqWl5dGWthjqnCAOVNxQtoBR3HZ+lCkPwUl8zrhMhoq6Ajqt
MiEmTjGKG8yKE2EGFQcqQ1xAEJV7EJ3iYxhBlAFWLQE2kWGRokLH2vuf++e0
N7mPc//H97h+CSnxa8QikWiX/ec4YnjSwjxHNJApaa1nlzSq6NQnNyIzEu6R
ypTlw5mVKlrgH3XQP+o+We3rbd20WkVb/lk9WP7dI1JUYB7KlqhoTbn89Yfx
JlKlb7ugb1NS3amjH/d98JR4h+t/q92hpIGOxw92kr909cq2UCWNSG+Mmq/o
JsmO2y8oqE487/Sk7OdkTsv9VRMTFTSwK6s8IaGPLHMZ3TfrIwXFXPuJ+eXS
4qnZHvSQ9kbG8SYLca4cmPzfHg+qerJuWuBbC3E6fzqks92dpvL7DpK/x4xf
31zhTtVRLxaeSrKSdsdpvTtNd3c6udg4RLT91XsLW9xoz/VAt9GBNyS1c/aa
rG/d6GP+vmFyzdi3Y/ErV5pds/aLd7faSLSjDH9XGmHPdnaMCCal7J6Qp3Cl
s8bfOv/TVhF8etbPqrPJ6SS+XhEUDWxUXSyVU4P9XzfFCfoy8hvG+cnphlXi
ywmBYmhdlJXDrZXRDv59zvD5nf7E+9NkdJxeXvnqgTNU8/10obrnc7/OSJKA
YVu1qWuGC61LXSVN3yGFiHyNPrpCSg/x83GB7TPDt7TMlNJLjebQJWNlgHlI
aFjMo7spfnKImy5WKUMk1LYpOPlmmRwubX5iX840BuuCsuOh57onO9Oz0xYE
ucx2A9xXTEsazH9qDO6QtTMrvFgrplUvNSvfu+IO7R2OcGLz8QDf1upmg1VE
16m693mFKIBhjCaudYQSenytI/XHRrni8MGQkmNKaLMEmSxBo9xFxA2ow5oN
hWE2rnrncNXOYRWYcA5clWdwdGiaJwydE8tGrrzlsofTFn9f5AmakL37pXff
cNgnT3C1PtD3BLzmFlW7elbMUUMNf97K2ZtXqvpBDVOXNDS+TR7kutO1Z+Ch
GuqCPeqDPQY4I1+nBqKlN6uCcy3c7VuiL3u+0sBh/ryFC01rX3E1WQMrFzni
JZd72BEaeBypky8f/y+XcHtuXW67Bsx8vs+5IMmB+FgfLeTXlhypLenhTnpF
2pcW2jJ9BvMjzJzX7s/+yMnWwlF+/2dcrM+2w+X5WhBlbjzWe/kp92tYwTlL
oRaSTEMZpqEODnmihf6ZTROWL23mJKdat5hNWjiBvOSMN34J6O3Swou8awVX
ZjRy8zslT5N7tWBcWCI9EFXKhYiuxxht9v35uHcZj15gjOOvE+F6Hj5PItnz
uxjvD7H92/D9RMren4n5ESG/wT18/qSY5b8f6yNxrL46rJ+MYfWX8fPpIit8
37EjXAsHsV+kiPWrCftJprN+NmG/idDvWJwH+ZnN40ecF5nB5hWB8yR32Dz7
TnsP2BcR5j2B58crkuR66U2QRAP+iA8i4MOrN7W8vs5KkEdq+B3xRBIZniSI
NxLP8KZGPBIBjxbEK8lheH3IdOUiw7MC8U5qGN7bkQ9E4EMn8oWcYXwZGeWD
rGd88kG+wQbGtw7kIwh83I98hRrG1xzkM5QxPpci36GM8Z3pAQh6sAD1AkSb
US8mop4AMD0xoN5ALdMbpkcg6NEW1Cu4xvSqAvUMfJmexaHegQ/Tu/XLThgC
NshA0EMbX64MNvL1iqEX9RP0TD/LUF8hkekrQf0FQX8DUJ/hE6bP81hdsUy/
r6K+Qy7Td6b/IOi/Bv0B+pg/PEL/gAPMP3rQX8Cb+QvzHxD8R4b+BDYT+tMz
9C84wvxrKfobCP4Wjv4Hwcz/vkF/hCnMH1vRPyGS+efDkfLIsduVIPgr82Oo
ZX7M/BruMr9mfg6CnzO/h/eZ37PvARC+B/4Hq0mzGw==
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130}]},
        RowBox[{
          TagBox["y", HoldForm], "\[Equal]", 
          RowBox[{"5", "-", 
            RowBox[{"0.3`", " ", 
              SuperscriptBox[
               TagBox["x", HoldForm], "2"]}]}]}]],
       Annotation[#, HoldForm[$CellContext`y] == 
        5 - 0.3 HoldForm[$CellContext`x]^2, "Tooltip"]& ]}], {}}, {
    GraphicsComplexBox[CompressedData["
1:eJw1Vws8lFkbn/tgzBjUbhtK5bPSuiRSoXO6EFHJbukiW31SSkiWXNp2S31L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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
          180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
          193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 
          206, 207, 208, 209, 210, 211, 212, 213, 214}]},
        RowBox[{
          TagBox["x", HoldForm], "\[Equal]", 
          RowBox[{
            RowBox[{"-", "3"}], "+", 
            RowBox[{"0.4`", " ", 
              SuperscriptBox[
               TagBox["y", HoldForm], "2"]}]}]}]],
       Annotation[#, 
        HoldForm[$CellContext`x] == -3 + 0.4 HoldForm[$CellContext`y]^2, 
        "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJw1Vwk4lGsbnhljzKAhtOlkKYrSqtJCz3ciKjqhjmhRSR3K0qIcUcpSckRH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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
          180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
          193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 
          206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
          219, 220, 221, 222}]},
        RowBox[{
          TagBox["x", HoldForm], "\[Equal]", 
          RowBox[{"2", "-", 
            RowBox[{"0.6`", " ", 
              SuperscriptBox[
               TagBox["y", HoldForm], "2"]}]}]}]],
       Annotation[#, HoldForm[$CellContext`x] == 
        2 - 0.6 HoldForm[$CellContext`y]^2, "Tooltip"]& ]}], {}}, {
    GraphicsComplexBox[CompressedData["
1:eJxd1E0rhFEYxvFhMHmfyMtCaTJGs7azMQulMbFQvoCSBWNY+A7KAmNk40PI
YpgIn2F2moYFKStS8tYY5r6bS/1PPd396ul5zrnOfU5kMTO/1BgIBBb+nlr1
sV7wGr6uu1KtjW45lY0ms9FOOQlPwwc1JtvkLLwDl/PpUj4dkkvwDTxmE2iS
o3AEztgHG+Q0vAJvmCtXda/Cy3DQ6of8Y/m9y5+w5/Mq78Lb8JwF+CRPwRPw
o+VVkovwJXxh/zv5Xy88BG+Zi5N1H8HH8LDtx4Mch8fhL8vrWfZefZFDsO/f
m7wOb8LeT9/yLXwPj9j8Aom6Y3Ac9v4NymX4Dt6zvFrkHHwI+/lrlVPwLGxx
Vttlz7NDboZPrT265AJ8Dvv7YfkMLsB+H/TI+3AO9vPaK6/BGdjz6ZNn4BTs
90e/PArHYM9zQPY6mPgFFLqaYA==
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 
          85}]},
        RowBox[{
          TagBox["x", HoldForm], "\[Equal]", "0"}]],
       Annotation[#, HoldForm[$CellContext`x] == 0, "Tooltip"]& ]}], {}}, {
    GraphicsComplexBox[CompressedData["
1:eJxV1E9IlEEYx/FNSy37Y8ie0sSQEKRTBBGJu4eEFQMNQoRyRVghaI0OdZIO
eWohEVFBj4HgRVZFJEKti9BFEHdDYQNl14uIiEatpPhnnp/7fXF4l+HDzvvO
zDPzPJUdb55F8nw+3/PTn+vVSn6sJ4LlyWDt48n9WHw/dgPPpWvm0zXXcVdq
JpqauYYrkq737EbPp4vxbzc86vlz3E1wBQ9bu4wb+qtC/VWeD9xy4kW48F2T
e/BX9/lUAX7V6ZpnDb+E74bcBBfxiuvKPWdsA3l4wC0n5PmJG568gJttQT58
FlMc2fWHd/3H33P+sNDSvdByiNcsPgc4MNbzaKznP27tdi9k8Tfb7z98K+wm
+Isf3HftDx6y9e/hrN9ewJV2fts4Y+vZwqN2Ppt41eK1gUfs+2n8wuKxjm/b
dL/wFxu/jBtt/kXcbh7HCufSLP9bP16X81W9jz/q+/iozebHjVofjmn9+Kf2
hwe1f5xQfPBNxQ/vKL64V/HH93Q+uFTnh6d0vrhZ548f6n7gFd0f/F73C7/U
/cOHx9bwU93fQM5B3W/cp/uP15QfOKH8wXeUX/it8g9HlJ94WvmL85WwOKv8
x/WqD4Hz5+P5k+oLXlX9wdWqT7hM9Qu/Vn3Ds6p/eEL1EZ/VT3wCeUFzaQ==

     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 
          85}]},
        RowBox[{
          TagBox["y", HoldForm], "\[Equal]", "0"}]],
       Annotation[#, HoldForm[$CellContext`y] == 0, "Tooltip"]& ]}], {}}},
  PlotStyle -> All,
  AspectRatio->1,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "GridLinesInFront" -> 
    True},
  PlotInteractivity:>True,
  PlotRange->{{-4, 4}, {-4, 6}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.967474104544298*^9, 3.967474196309712*^9, 3.967474461688683*^9, {
   3.967474499616082*^9, 3.967474537289119*^9}, 3.9674752875329723`*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"399a88ea-3380-480b-82f5-35258158c9f7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"thin\"", ",", "\"black\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dashed\"", ",", "\"orange\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"solid\"", ",", "\"blue\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thin\"", ",", "\"black\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dotted\"", ",", "\"cyan\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dashed\"", ",", "\"black\""}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"\[UpArrow]\"", ",", 
             RowBox[{"{", 
               RowBox[{"0", ",", "1.5`"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"\[DownArrow]\"", ",", 
             RowBox[{"{", 
               RowBox[{"0", ",", "4.5`"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"\[RightArrow]\"", ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"-", "2.5`"}], ",", "0"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"\[LeftArrow]\"", ",", 
             RowBox[{"{", 
               RowBox[{"1.5`", ",", "0"}], "}"}]}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", 
     RowBox[{"-", "4.5`"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "4.5`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", 
     RowBox[{"-", "4.5`"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "6.5`"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.967474104544298*^9, 3.967474196309712*^9, 3.967474461688683*^9, {
   3.967474499616082*^9, 3.967474537289119*^9}, 3.967475287535152*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"5eefa6f5-26bc-4e0e-a755-5370bb506772"],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/conicas5/conicas5.\
tex\"\>"], "Output",
 CellChangeTimes->{
  3.967474104544298*^9, 3.967474196309712*^9, 3.967474461688683*^9, {
   3.967474499616082*^9, 3.967474537289119*^9}, 3.967475288318104*^9},
 CellLabel->"Out[36]=",ExpressionUUID->"43b46bf7-ed91-4849-81c9-e5c44950f35f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967474196310422*^9, 3.967474462456325*^9, {3.967474500403665*^9, 
   3.9674745380788603`*^9}, 3.96747528831885*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[32]:=",ExpressionUUID->"4e8b17bd-1954-47cc-b2fb-4f5891bb5fd2"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967474196310422*^9, 3.967474462456325*^9, {3.967474500403665*^9, 
   3.9674745380788603`*^9}, 3.967475288319255*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[32]:=",ExpressionUUID->"3b414e80-95e1-4cf2-b0bc-15583678fd90"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967474196310422*^9, 3.967474462456325*^9, {3.967474500403665*^9, 
   3.9674745380788603`*^9}, 3.9674752883197327`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[32]:=",ExpressionUUID->"637c55a9-b35d-4b7d-ad5c-c2de1c344811"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967474196310422*^9, 3.967474462456325*^9, {3.967474500403665*^9, 
   3.9674745380788603`*^9}, 3.967475288320034*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[32]:=",ExpressionUUID->"7ca49824-75cd-4ba8-8989-a29538e0160d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967474196310422*^9, 3.967474462456325*^9, {3.967474500403665*^9, 
   3.9674745380788603`*^9}, 3.967475288320334*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[32]:=",ExpressionUUID->"09b1d4b0-9109-42da-af0a-6ec4482a1236"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967474196310422*^9, 3.967474462456325*^9, {3.967474500403665*^9, 
   3.9674745380788603`*^9}, 3.9674752883874073`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[32]:=",ExpressionUUID->"c2e08027-42af-48f2-a3d3-d394189857a0"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967474196310422*^9, 3.967474462456325*^9, {3.967474500403665*^9, 
   3.9674745380788603`*^9}, 3.9674752893936567`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[32]:=",ExpressionUUID->"3c738d05-b5d1-4596-8172-85edacf2ce8d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", "\<\"/Users/enriquevilchezquesada/Downloads/conicas5/\
\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/conicas5/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967474196310422*^9, 3.967474462456325*^9, {3.967474500403665*^9, 
   3.9674745380788603`*^9}, 3.9674752893968678`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[32]:=",ExpressionUUID->"0c27c3d1-1d38-4db8-afe7-7eda57195041"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"conicas5\"\>"}],
  SequenceForm["Archivo: ", "conicas5"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967474196310422*^9, 3.967474462456325*^9, {3.967474500403665*^9, 
   3.9674745380788603`*^9}, 3.9674752893986*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[32]:=",ExpressionUUID->"fc267e85-e3ba-4757-b202-bda2de066d5f"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967474196310422*^9, 3.967474462456325*^9, {3.967474500403665*^9, 
   3.9674745380788603`*^9}, 3.9674752901434*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[32]:=",ExpressionUUID->"80d60953-cde3-44d9-9eae-86a9c12c30fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/conicas5/conicas5.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/conicas5/conicas5.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967474196310422*^9, 3.967474462456325*^9, {3.967474500403665*^9, 
   3.9674745380788603`*^9}, 3.96747529014396*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[32]:=",ExpressionUUID->"92360db6-92a3-472c-ac93-8a828e6185e3"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/conicas5/conicas5.\
pdf\"\>"], "Output",
 CellChangeTimes->{
  3.967474104544298*^9, 3.967474196309712*^9, 3.967474461688683*^9, {
   3.967474499616082*^9, 3.967474537289119*^9}, 3.967475290155603*^9},
 CellLabel->"Out[37]=",ExpressionUUID->"175d5a5e-1b5f-4754-ad20-455b83388c73"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 6: elipses e hip\[EAcute]rbolas conjugadas", "Subsection",
 CellChangeTimes->{{3.967295680579814*^9, 3.967295688242674*^9}, 
   3.9672957265229673`*^9, {3.967474738430184*^9, 3.9674747600381727`*^9}, 
   3.967475004512871*^9, 
   3.967475314647735*^9},ExpressionUUID->"178cf152-119a-4333-b58b-\
905fec096e5a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "/", "4"}], "-", 
        RowBox[{
         RowBox[{"y", "^", "2"}], "/", "9"}]}], "==", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"x", "^", "2"}]}], "/", "4"}], "+", 
        RowBox[{
         RowBox[{"y", "^", "2"}], "/", "9"}]}], "==", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "/", "4"}], "+", 
        RowBox[{
         RowBox[{"y", "^", "2"}], "/", "9"}]}], "==", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"y", "==", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3", "/", "2"}], ")"}], "*", "x"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"y", "==", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"3", "/", "2"}], ")"}]}], "*", "x"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "==", "13"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"PlotStyle", "->", "All"}]}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "6"}], "]"}]}]}], "}"}],
     "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<H1\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "2"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<H2\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "3.5"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<E\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"1.5", ",", "2.5"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<a=2\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", 
             RowBox[{"-", "0.5"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<b=3\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"0.3", ",", "3"}], "}"}]}], "}"}]}], "}"}]}]}], "}"}], 
    "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", 
       RowBox[{"-", "6.5"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "6.5"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", 
       RowBox[{"-", "5.5"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "5.5"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportConicsToTikZ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "2"}], "/", "4"}], "-", 
          RowBox[{
           RowBox[{"y", "^", "2"}], "/", "9"}]}], "==", "1"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"x", "^", "2"}]}], "/", "4"}], "+", 
          RowBox[{
           RowBox[{"y", "^", "2"}], "/", "9"}]}], "==", "1"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "2"}], "/", "4"}], "+", 
          RowBox[{
           RowBox[{"y", "^", "2"}], "/", "9"}]}], "==", "1"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y", "==", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"3", "/", "2"}], ")"}], "*", "x"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y", "==", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"3", "/", "2"}], ")"}]}], "*", "x"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", 
          RowBox[{"y", "^", "2"}]}], "==", "13"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], "}"}], 
    ",", "\"\<conicas6.tex\>\"", ",", "grid", ",", "estilos", ",", "ejes", ",",
     "texto", ",", "xmin", ",", "xmax", ",", "ymin"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.96747457233322*^9, 3.967474592235716*^9}, {
   3.9674747908434353`*^9, 3.967474791201354*^9}, {3.967475009129504*^9, 
   3.9674751929244413`*^9}, 3.9674753190008163`*^9, 
   3.9705938126313963`*^9},ExpressionUUID->"411096f6-7043-4c79-9b18-\
d6d1eebdb479"],

Cell[BoxData[
 GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJxdlntQVGUYxg/swnJnUQHRSgVRjNTQFNDc84aUplZKkDcItIlRAy+YaN4w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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97}], 
         LineBox[{98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 
          110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 
          123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 
          136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 
          149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 
          162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 
          175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 
          188, 189, 190, 191, 192, 193, 194, 195, 196, 197}]},
        RowBox[{
          RowBox[{
            FractionBox[
             SuperscriptBox[
              TagBox["x", HoldForm], "2"], "4"], "-", 
            FractionBox[
             SuperscriptBox[
              TagBox["y", HoldForm], "2"], "9"]}], "\[Equal]", "1"}]],
       Annotation[#, 
        Rational[1, 4] HoldForm[$CellContext`x]^2 + 
         Rational[-1, 9] HoldForm[$CellContext`y]^2 == 1, 
        "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxdlntMFFcUxpcF7S6gsGAiUoqgoNHaCK6iY7D3aB88RGuqWKNtIyi1UYma
tqaiUh/IwwqhPESlShWrtbVUrYKi5p6msSEhQLExVbEgRhDaQFFoQJCly5xz
/2Ams5mcnTsz95z7fb97ghO3vJtkNplMPzh/w1fv+DOVQ8tGgUk/xmFck+uS
JtdRMOH8787TFyfH5IXE5LnBT30Hnacv7r22fW3ZK24w/G9IjC8+r187Wha5
QnBu/Zof+31w0a4zdTktZtBv5/lgeXKD8zTDhsBDztMHTUV7FmOoGfZ9fbg0
aKoP7nOrvJF33AVonA2j9Re7wKzcxpJNhTb85mbH+qzzJtAwd7BwpQ3r0oSv
I84E+utDbHhZf84htkxc+qzie28MmDnms+IVDtHiWru8JssbS1oiFuc2D4oG
/QPeeFe/DohLWvHPWrEXfmXX8u3agNCO7HeeXmhfkzK+wDLA471wW37XhaCT
zwXWfhjZLsdiqF6nPmHTr2PRxLGJY8fQ8NEr9MvQGHzBsYPjI7Er/i051yOo
Pp6YkNrVmHeiR5R8AJunZ3tisP5/j9hZlbGrKsOT83smqD4e+Lae91NxJF87
mq95oGdB+PJwy1PxZX3M6qQwD4zOmaFdetwlqI4eeEF/rlPYMv5sXH7aHV8N
TmmKfrNTBL04+Zc92x3v1lUfTNneIe7rH3DHO/r1H3GzeVrl/Zfd8fTjxltl
sX+LuVFNAbu7rbgsq3BVVmGb0F9bbsV+Pa8nYn3UUGzmSSsevJ5avmpCq1jU
2X8vMcmKgXo+j8XsxUvbxsyxYtroO+bew4+4Xlac4r/94bVTzWJN2Q6saLFg
9+sLtn1yqUlsStbm9lVasI4SF/ERAeEdWRYM3xO5MqrstiD9WbC1QQ42yBpR
Omu687Tgr/r4ajFJPyyYk95+58rYKpFUNHQvPMCCcvPDlAWB34qd81bfkmYL
r1/VjSu3ZvjMd7yEXyTr96W6X03PS/V8N71fZvi/NbPC+X73B/r3pfp+GM1P
qvk9ofnLlTz/8ULPTyZzfmGUv3yf859O9ZKz7cOHFb3TE/zSE9qkqvd5Wg85
j9ejmdZLnkuoXbHb37m+8ft+C23ukmr9vUgf8hDrI470I4+xfsZXDD/fLY8P
f8bPE6eS/mSKJeX6Xqf+0k69s3XDiR7Zts71QKRTn6mxg9P+O9sjlX4vkr5l
I+ub/SCVH1wMsZljF47Zb1L57UT1R5m3tQEZ0TnKEe/0YyP5VV5hv7KfpfLz
RPK7bGW/XyMeyK3MA+YFKl6cIp7gfOZJLPEG7cwb5hEqHrkQr1Dx6irxDD9m
njHvUPGun3iIiofMS1S8nEI8xYvM0yXEW/Rn3jKPUfHYEINhPKj35Xxuf1ST
6QuG78MbPL9Qmh8Y5g9mzm8/5QfpnD+Ns4GhPlA6sn5Qz/WlcTYw1B+CR64P
qPUMqpm4OfKYFxQRf2Uk8Rc01gON8wI/1osH6QXcODZz7DpST5DG+iQde0Im
67ed9AtK3ztI33CznPS/k/QPyh/F5A8Yx/7JIf/AHPYXjfMAg//gMvtTI3/C
FPbvVvIvGPwNESP9D33EP8n8A8WP94gfkMh8KSC+wCTmz2niDyg+TSb+wdmR
/IJe5tsu4hso/pUT/2Au3Rfq/saR/AQDX8HB/FXfX8d8VvNT/Gb+wR/M942c
32vMf5W/2i/sXJ8Qqp9Q9WP+CVVftV99x/WPoPURan1svD9m8/qp/fMor288
76/5tL9CJcdXOTbsx3CA9CSYh1DC+7nSm2G/B0N/oPQrlH6XcBzC8afcb/xC
/Ybyg1B+KOB+ZT77xdDPQCn3Ow+IjxDI/ZDyn81tobfbQhMovzIPQfnZ0H8p
HoDiAfMCFC8M/Z3iDSjeGPpDMPSPYOgvwdB/gqE/hf8BWSHXuw==
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90}], 
         LineBox[{91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104,
           105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 
          118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 
          131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 
          144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 
          157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 
          170, 171}]},
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              FractionBox[
               SuperscriptBox[
                TagBox["x", HoldForm], "2"], "4"]}], "+", 
            FractionBox[
             SuperscriptBox[
              TagBox["y", HoldForm], "2"], "9"]}], "\[Equal]", "1"}]],
       Annotation[#, 
        Rational[-1, 4] HoldForm[$CellContext`x]^2 + 
         Rational[1, 9] HoldForm[$CellContext`y]^2 == 1, 
        "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxdlwlQlVUUx58P3nuUtGiYEYmijJLiOClCo8K5A8riggpYpk0piJYGtFmT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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
          180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
          193, 194, 195, 196}]},
        RowBox[{
          RowBox[{
            FractionBox[
             SuperscriptBox[
              TagBox["x", HoldForm], "2"], "4"], "+", 
            FractionBox[
             SuperscriptBox[
              TagBox["y", HoldForm], "2"], "9"]}], "\[Equal]", "1"}]],
       Annotation[#, 
        Rational[1, 4] HoldForm[$CellContext`x]^2 + 
         Rational[1, 9] HoldForm[$CellContext`y]^2 == 1, 
        "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxdVV1olFcQXbObn6arMatPFazW9CcPokgrBLadEUFNLRWUthrBB0XQtoml
UIiIIOlDHsQKaSHiL+qDYLXFKoISO9MGpSBtrLZBCBVFm6QGxbp20aix+eac
3Qc/vuUy386dc2buzLkz125avr4ilUptHP8l69F4aj0Vz1RvGzjdOnD6Bf+6
obmroXmKf0x7J+052d652d4aD7Mr5y+/NLJw3dYa37Xi3ue1a3JeEXFquOb8
95WJR7Xv6+ge96j3JFrrQJXH9oZ6/zL5XFvlh06882Z/52S/Gg6V/krikJvs
b/cV8n2FjAeN1jp/q7/zwuiljC/76WJje1OdvxaBMn4m4k7ywak9ezu6074q
iE30hO3cbJp8sx5wayp83dYNx+p2vOjvBo8Jvol5NtNue85upb2Y9ie0iwcT
4s+svalyzpHr1b5/aPP4O2alPMHjqXUwz2vxx2Mr8U7Yrrg3ajv+SwJlHOcx
as/iSfuGwHlkX0UCadb7oe1iHsAp2hLyAk7RUM+Uvx44D+xs+I0Z6lOwleT1
c9SnYFHvrieGfP+1NuIuoL2W9p7I766dIi7i3LES7o0gNGKNxAXfYUPd79vJ
2Ddoixj37+BzsxynKb7fsA8C7x/rDrxrdoL74PcX8QZtCAWw2YF3i/Gu2Ef0
2xn7f7Nvw63fCuF/0eaH/x92K/x77cPw/9W2hf+PdiD8Lxjm4pcerJd7/oz9
2/Pop2/yQbfZ8/TDuu06Vh/ODyO+rEZ8+R58pBd8ZAh8pQV8pQ/5yDTkU/6O
ORmUI6iHnEM9pAX1kk7US3C+NwV9d0emM87x8L8rZ7nvPdRfeD6Cfrov30X/
3ZZ0JPBAkO+IzMB5luOCT1EOox8Ytyg8V9mIfhH2k7CfZDntLbTPo//kDfQf
+ReI81RmEvcH9G8Zl/2tZ4i7FP2vnA/hnGs7cXZjfvQ45kugTxk9h/kTzp9C
fx4L5iGjLeRBndKDmG8BbpVy/mUz5l85h/op9EGpL0p90RLPz2i/T/sL2pxr
XQ99UtQnrZjjrFLfyGuiziJPzOMkpT4q9VEF+qnQnTrFfFZqI/RVqUtK/dVS
XuBdr9RvpX7rWOhSNdd6nQH9V9Q7p/NwP+iruB+UuqmYkynlOvB+Ud4/yvtH
/wcyayyy
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105}]},
        RowBox[{
          TagBox["y", HoldForm], "\[Equal]", 
          FractionBox[
           RowBox[{"3", " ", 
             TagBox["x", HoldForm]}], "2"]}]],
       Annotation[#, HoldForm[$CellContext`y] == 
        Rational[3, 2] HoldForm[$CellContext`x], "Tooltip"]& ]}], {}}, {
    GraphicsComplexBox[CompressedData["
1:eJx1VXtozmEU/nz77GbMPv4ilzFzKaGk1DinlMtGcovC1JZrhikxkksuRaIR
CQtTyyWaGNZ0DotWLhORcslymVnmMpYNm+87z5k/lF/fejt73995nvO85zy/
1JyV0xcGA4HAkshfdD1jTyIH7OmuK5+V5T0rS+D9aZMK0yZ10zyPCz0enlQZ
+cWzhYVh7d2jflzuxng+OOPz6sTssLa2RZ84xpqiD+b0iZyI46NbD0VOpOgV
SxjL9npaitq/E2P5ROnYkU92dtUXUbi8jpwePRDuqmOqGzOqG0NsNPKSNXLo
dsuDEE+5cWfwutHJ2t8ShfiS5e2ib7tXRKBi2GBzO2ulEY5xvklqcNlBztm4
5Fzynk4KHh14Ber8G3vdOvE/8XKPvxnxNlo7uuOwkldxeqy2oKi2oJXKUKfO
Nh6/aQvq1Ke28ZP6gbeWmzAttPt7NFFIT9t9tJDJ1xajqwynmQ5YATHay/T+
QdA7qJcNp4mcl242nCY6bnoGNNVwvtFFO9cqr02fRpoFXnLD9Gl0Pr8E9X8h
6NEsEzxe5vF4j5d6fMTqbSDo3yQzLe9H2gQe8tjqrae+4CE9jP97OmD8vwp4
vSPPKzXG7zVNQx5BXTUEvevkkOG9pFK8J1Pt3AvaYHjvpBrCU0/DeyPPLd8j
ysQ52Wvv36ezduyJPLL9Shpj+/cEfVtSgbU0A3OhFVirMtC/NyswD3d9v8r3
H2Y0I5+sQT66ADypBB59Ah9Z7LxrwVeGgi/lOM9dqIdKUK9cd52yoIegL+ro
A/SSBa77EK9b7HwDlbtOk/3e0qC/HIH+VIP7kcHeJ/Nd9x3eR8W4Xyn3Psv0
e2rvS88r+R7fRj/JIPQTvUe/yTyfg4HeB8jXStu9T06hX9lxJMvnLBX9Lod9
bh1XfB74POZFgqZ/iAXzJHsxT/wS8ybp7hPOQ7a775zEvMo196UfmGdZj3nm
TJ+rdl9sj1d5nPVPPNnjfI+dty6C3/BVwwkq+CfxLfiTQpckroV/6Vz4Fztv
Bb8uPAr+p9Pgf0zwR0Wdyfwc/qkD4J+8zX2nGP7q+LGKOlL4IfxZi+DPDB3j
FWuY+8LfFXWEeQT8H/kLw7zMfXAfvg9/fdS/H35fCV5vN/bvjfr3hv8AotUr
SQ==
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104}]},
        RowBox[{
          TagBox["y", HoldForm], "\[Equal]", 
          RowBox[{"-", 
            FractionBox[
             RowBox[{"3", " ", 
               TagBox["x", HoldForm]}], "2"]}]}]],
       Annotation[#, HoldForm[$CellContext`y] == 
        Rational[-3, 2] HoldForm[$CellContext`x], "Tooltip"]& ]}], {}}, {
    GraphicsComplexBox[CompressedData["
1:eJxdVwtQVNcZhgVZdvfW17jVNp0Y1AATKZoJU219nL/SsZDUFxYbsYNNmweJ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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
          180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
          193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203}]},
        RowBox[{
          RowBox[{
            SuperscriptBox[
             TagBox["x", HoldForm], "2"], "+", 
            SuperscriptBox[
             TagBox["y", HoldForm], "2"]}], "\[Equal]", "13"}]],
       Annotation[#, HoldForm[$CellContext`x]^2 + HoldForm[$CellContext`y]^2 == 
        13, "Tooltip"]& ]}], {}}},
  PlotStyle -> All,
  AspectRatio->1,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "GridLinesInFront" -> 
    True},
  PlotInteractivity:>True,
  PlotRange->{{-6, 6}, {-5, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.967474574057577*^9, 3.9674745930277576`*^9}, 
   3.967474791922114*^9, 3.967475197931141*^9, 3.96747532533412*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"27bb1b89-a13b-4ba3-bec4-123924d82956"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"dashed\"", ",", "\"red\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thick\"", ",", "\"cyan\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"solid\"", ",", "\"purple\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"solid\"", ",", "\"purple\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thick\"", ",", "\"yellow\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thin\"", ",", "\"black\""}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"H1\"", ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "2"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"H2\"", ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "3.5`"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"E\"", ",", 
             RowBox[{"{", 
               RowBox[{"1.5`", ",", "2.5`"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"a=2\"", ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", 
                 RowBox[{"-", "0.5`"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"b=3\"", ",", 
             RowBox[{"{", 
               RowBox[{"0.3`", ",", "3"}], "}"}]}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", 
     RowBox[{"-", "6.5`"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "6.5`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", 
     RowBox[{"-", "5.5`"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "5.5`"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{{3.967474574057577*^9, 3.9674745930277576`*^9}, 
   3.967474791922114*^9, 3.967475197931141*^9, 3.967475325336664*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"114d529f-e4e3-4fe7-a424-d4a373656583"],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/conicas6/conicas6.\
tex\"\>"], "Output",
 CellChangeTimes->{{3.967474574057577*^9, 3.9674745930277576`*^9}, 
   3.967474791922114*^9, 3.967475197931141*^9, 3.967475325708632*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"6655607e-3800-4ead-9399-ac4850081a3f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9674745740590277`*^9, 3.967474593028431*^9}, 
   3.967474791922749*^9, 3.967475198320141*^9, 3.967475325709437*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[38]:=",ExpressionUUID->"744b8394-cbbb-4e6c-b66a-b148f00f0d05"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.9674745740590277`*^9, 3.967474593028431*^9}, 
   3.967474791922749*^9, 3.967475198320141*^9, 3.9674753257098503`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[38]:=",ExpressionUUID->"cc757938-4b3a-4dc2-b3a4-aaae68e30543"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9674745740590277`*^9, 3.967474593028431*^9}, 
   3.967474791922749*^9, 3.967475198320141*^9, 3.9674753257102957`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[38]:=",ExpressionUUID->"1f9884f5-f71f-422f-91c6-908fe8c04f21"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9674745740590277`*^9, 3.967474593028431*^9}, 
   3.967474791922749*^9, 3.967475198320141*^9, 3.967475325710574*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[38]:=",ExpressionUUID->"8a47fa40-a6fd-47e1-8a80-fc94a3535876"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9674745740590277`*^9, 3.967474593028431*^9}, 
   3.967474791922749*^9, 3.967475198320141*^9, 3.967475325710855*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[38]:=",ExpressionUUID->"af916ba7-4475-4607-95f7-a0bd318121f6"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.9674745740590277`*^9, 3.967474593028431*^9}, 
   3.967474791922749*^9, 3.967475198320141*^9, 3.967475325774123*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[38]:=",ExpressionUUID->"7025dd7e-c864-4b37-aba2-6029e2fee632"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.9674745740590277`*^9, 3.967474593028431*^9}, 
   3.967474791922749*^9, 3.967475198320141*^9, 3.967475326780048*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[38]:=",ExpressionUUID->"11960263-103c-4c08-adb0-e2f58e07fe96"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", "\<\"/Users/enriquevilchezquesada/Downloads/conicas6/\
\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/conicas6/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9674745740590277`*^9, 3.967474593028431*^9}, 
   3.967474791922749*^9, 3.967475198320141*^9, 3.967475326782749*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[38]:=",ExpressionUUID->"fdb6b26d-ce9c-4c39-a36e-968f37a8eed2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"conicas6\"\>"}],
  SequenceForm["Archivo: ", "conicas6"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9674745740590277`*^9, 3.967474593028431*^9}, 
   3.967474791922749*^9, 3.967475198320141*^9, 3.967475326784301*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[38]:=",ExpressionUUID->"42cf5950-3141-4fc6-8a7a-18839c47023a"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.9674745740590277`*^9, 3.967474593028431*^9}, 
   3.967474791922749*^9, 3.967475198320141*^9, 3.967475327612405*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[38]:=",ExpressionUUID->"82a939ed-8a4c-441d-af4b-15dd0239001b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/conicas6/conicas6.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/conicas6/conicas6.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9674745740590277`*^9, 3.967474593028431*^9}, 
   3.967474791922749*^9, 3.967475198320141*^9, 3.9674753276129713`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[38]:=",ExpressionUUID->"dd9c843d-9c36-41a4-8f05-d2ad0d36cf03"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/conicas6/conicas6.\
pdf\"\>"], "Output",
 CellChangeTimes->{{3.967474574057577*^9, 3.9674745930277576`*^9}, 
   3.967474791922114*^9, 3.967475197931141*^9, 3.9674753276250753`*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"97a53644-c2e9-424c-92aa-5e76c60fcc96"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 7: varias c\[OAcute]nicas", "Subsection",
 CellChangeTimes->{{3.967295680579814*^9, 3.967295688242674*^9}, 
   3.967295729089666*^9, 3.967475339039324*^9, {3.9674758348595953`*^9, 
   3.9674758413443727`*^9}},ExpressionUUID->"eae0cae2-8037-48b4-9a67-\
7836b2dc3cc6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "==", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "==", 
      RowBox[{
       RowBox[{"2", "*", "x"}], "+", 
       RowBox[{"3", "*", "y"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"y", "-", "1"}], ")"}], "^", "2"}]}], "==", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq4", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "==", 
      RowBox[{"4", "x"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq5", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", "y", " ", "-", "x", "-", "3"}], "==", 
      "0"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq6", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", "y"}], "==", "3"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq7", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"y", "-", "1"}], ")"}], "^", "2"}]}], "==", "4"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "==", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "==", 
       RowBox[{
        RowBox[{"2", "*", "x"}], "+", 
        RowBox[{"3", "*", "y"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"y", "-", "1"}], ")"}], "^", "2"}]}], "==", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "==", 
       RowBox[{"4", "x"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", "y", " ", "-", "x", "-", "3"}], "==", 
       "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "+", "y"}], "==", "3"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"y", "-", "1"}], ")"}], "^", "2"}]}], "==", "4"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"PlotStyle", "->", "All"}]}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "7"}], "]"}]}]}], "}"}],
     "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<C\[OAcute]nicas\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "2"}], "}"}]}], "}"}], "}"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", 
       RowBox[{"-", "10.5"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "10.5"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", 
       RowBox[{"-", "10.5"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "10.5"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportConicsToTikZ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "eq1", ",", "eq2", ",", "eq3", ",", "eq4", ",", "eq5", ",", "eq6", ",", 
      "eq7"}], "}"}], ",", "\"\<conicas7.tex\>\"", ",", "grid", ",", 
    "estilos", ",", "ejes", ",", "texto", ",", "xmin", ",", "xmax", ",", 
    "ymin"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.965835133937374*^9, 3.965835133938867*^9}, 
   3.965835632739957*^9, 3.965837687745986*^9, {3.965837719021818*^9, 
   3.965837759714076*^9}, {3.9658378517991867`*^9, 3.9658378582338953`*^9}, {
   3.965837898665432*^9, 3.965837923520891*^9}, {3.965838059094462*^9, 
   3.9658381510036*^9}, {3.965839576415298*^9, 3.9658395879334908`*^9}, {
   3.9658396397822742`*^9, 3.965839665544257*^9}, {3.965840332671335*^9, 
   3.965840355157179*^9}, {3.9658406865673847`*^9, 3.965840731586532*^9}, {
   3.965840800102819*^9, 3.96584083293956*^9}, {3.965841017971957*^9, 
   3.965841043747196*^9}, {3.965841090447217*^9, 3.96584109223269*^9}, {
   3.9658411230723333`*^9, 3.9658411823417683`*^9}, {3.9658417003315763`*^9, 
   3.965841709991334*^9}, 3.965841748496698*^9, {3.965842736946271*^9, 
   3.9658427458175373`*^9}, {3.965915213957081*^9, 3.9659152163717737`*^9}, 
   3.9672961567589417`*^9, {3.9672968840353727`*^9, 3.967296925464023*^9}, {
   3.967475810491961*^9, 3.9674758189826813`*^9}, {3.96747587069151*^9, 
   3.967476243430314*^9}, 
   3.970593818540415*^9},ExpressionUUID->"656f54e7-e67e-42ce-9173-\
2ba018febfd4"],

Cell[BoxData[
 GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJxdlEFI1FEQh5fMjp5KBSE0t6NLl6RDMoKIrZjK2ha2BiF06CASHUovHrt4
UAMhYxXCkhC0S1FmDGRsB4VVQVlcD4q4UrmuB/FY5n/mu7iwPHjv/2bm981v
XlV3b+zRuVAoFP//P11f9GQ/9WRTurjaMFaeKOjh53SksvajdtX0Dj58U9BQ
8MvcnM9dbbq0VdCFL8G53PfzPbsvP/3+2OVnox9ep6Xxet9m5/cDTQfn67I/
mnx5ZSmvN8Ils9+mMnJ7crryyfO8Xhh+OvGgflPKoyPh6Mi+lrTdXayo3pKV
4h/vVof+aPx0O7wtLZHdWGT3t+4F+ztSt91/cabpl67V9w/MxHMyHeTJ6fva
5cdFyZwM26oLti/z9p3G7J4sWRxNWFypszy6Y3ml0BrUodesLpkcCurUhNUt
R9WBDj02XTJhOrXNdMt54wBXgXOncZOUcdSvxlXgfM/PX80Z55Tfh3Ozx293
znnPD+c7Xl+Zc6b+t1a/bLi+v6ZPml0/nG85nw3nDL8555x0vqzs8x33iENc
8pCXOqiLOtGBLnSiGw5wgRPc4AhXOMOdvtAn+kYf6St9pu/Uhy/wCb7BR/gK
n+E7+OBLfIpv8TG+xuf4Ho7MBXPC3DBHzBkcmUPmkjmFI3PMXDPncOQd4F3g
ncDP3hdtda5Hnh+uHT7npeZHPVOvug/0n3Ptcr1wjTqPrHOFV8a5jjtPVvb5
jnvEIS55yEsd1EWd6EAXOtF99v08AXmc2uI=
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 
          85}]},
        RowBox[{
          RowBox[{
            SuperscriptBox[
             TagBox["x", HoldForm], "2"], "+", 
            SuperscriptBox[
             TagBox["y", HoldForm], "2"]}], "\[Equal]", "1"}]],
       Annotation[#, HoldForm[$CellContext`x]^2 + HoldForm[$CellContext`y]^2 == 
        1, "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxdVwlYE9cWTkgyIQFqVbQCIqug0IIIQhH0XECkKIIrS0VZFJfWhb0CIiKI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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
          180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
          193, 194, 195, 196, 197, 198, 199, 200}]},
        RowBox[{
          RowBox[{
            SuperscriptBox[
             TagBox["x", HoldForm], "2"], "+", 
            SuperscriptBox[
             TagBox["y", HoldForm], "2"]}], "\[Equal]", 
          RowBox[{
            RowBox[{"2", " ", 
              TagBox["x", HoldForm]}], "+", 
            RowBox[{"3", " ", 
              TagBox["y", HoldForm]}]}]}]],
       Annotation[#, HoldForm[$CellContext`x]^2 + HoldForm[$CellContext`y]^2 == 
        2 HoldForm[$CellContext`x] + 3 HoldForm[$CellContext`y], 
        "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxd2AtYjNkbAPBmuk2UJk3XqTSTJLsRhfxjz4u15bbZyMplFwlhE7VisRur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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176}], 
         LineBox[CompressedData["
1:eJwt0NdCDQAAANCbjKhIVgsNe0UpWkqUKCKjbPkAvo2WFbLLVqmUqIyIEiJU
nAcP5wdOwumzZWeCAoHAuf/OU0U1NdRSxwUuconLXKGeq1zjOg3c4Ca3uM0d
7nKPRpq4zwMe8ojHPOEpz2imhVae00Y7Hbygky5e0s0rXtNDL3284S3veE8/
H/jIAJ/4zCBDfGGYr3zjOyP84Cej/OI3fxhjnAn+EpAYxCSCmcwUpjKNEKYz
g1DCCGcms4hgNpHMYS7zmM8CoogmhljiWMgiFhNPAokksYSlLGM5K1jJKlaz
hrWsI5n1bCCFVDaSRjqb2EwGmWSRTQ5byCWPreSzje0UUMgOitjJLoopYTd7
KGUv+yhjPwc4yCHKqeAwRzjKMY5zgpOcopJ/1ApYAA==
          "]]},
        RowBox[{
          RowBox[{
            SuperscriptBox[
             TagBox["x", HoldForm], "2"], "-", 
            SuperscriptBox[
             RowBox[{"(", 
               RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 TagBox["y", HoldForm]}], ")"}], "2"]}], "\[Equal]", "1"}]],
       Annotation[#, 
        HoldForm[$CellContext`x]^2 - (-1 + HoldForm[$CellContext`y])^2 == 1, 
        "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxdVg04lWka5lSo5FRDTOiXBlkmJW3oeWnZiGzGakejUSFMNZWZ6kLRqDXb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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
          180}]},
        RowBox[{
          RowBox[{
            SuperscriptBox[
             TagBox["x", HoldForm], "2"], "+", 
            SuperscriptBox[
             TagBox["y", HoldForm], "2"]}], "\[Equal]", 
          RowBox[{"4", " ", 
            TagBox["x", HoldForm]}]}]],
       Annotation[#, HoldForm[$CellContext`x]^2 + HoldForm[$CellContext`y]^2 == 
        4 HoldForm[$CellContext`x], "Tooltip"]& ]}], {}}, {
    GraphicsComplexBox[CompressedData["
1:eJw9Vws81NkXH/MeRjPlNchjaESLsnqg5d5oYxOJavX6K7SjpBeppIe22Eo2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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
          180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
          193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 
          206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
          219, 220}]},
        RowBox[{
          RowBox[{
            RowBox[{"-", "3"}], "-", 
            TagBox["x", HoldForm], "+", 
            SuperscriptBox[
             TagBox["x", HoldForm], "2"], "+", 
            TagBox["y", HoldForm]}], "\[Equal]", "0"}]],
       Annotation[#, -3 - HoldForm[$CellContext`x] + 
         HoldForm[$CellContext`x]^2 + HoldForm[$CellContext`y] == 0, 
        "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJw9lM1qk2EQhZNaW9RWkiZNmxiN+RrRjXcgfAOCGHXlDRQEV/5UvBGxde8F
uLKU+gPyDXoD4kqMiIgI4kZERZGi7Zx5DCknfX/mnTlz5gyvrF2+OlWr1VZ3
//ZQn5EJ+z7ZvrH7XbGASc8fBRYWsN31m4GF6VzXT4zXR+P1wi7swajrilNY
PXA54w0zXsfj2Hhoutdx3RvavVjvZLzjFjBa9L/xGZiwle8PTNjydxF4YMKW
b0ScYyZc8PMR56gJm1lP34QNPxkP9U3Y8LcR54g9jv3Dfjfi9KyI/TlXXb2s
b85viRd7H/cOZf7LyccBfxPrS7YV8WZcdS1lfjP+RLzY7YizP+tbNOWxz1fi
QtvOxb161tdO/mquHrZtWsRnfQvZnz/V9fjRtIex/rPSetPW4seP6qJ4sdMR
73ulMI2s72t1Lc7N24O4/6lSXfP5/sfqlHix+5HXh0r5Hcz6XlU70bfZ1Nfr
M6pr1u7E/mb5VLzYavz/vFTc6cx/UurclL3Q+6X4qac+PpeXxIu9jPNfcn+n
1PvfyrOx/7t8pvpL5fHrP7LOOe4Rh7i8w7vkQV7kSd7UQV3USd3wAC/wBG/w
CK/wDO/0gb7QJ/pGH+krfabv6ABdoBN0g47QFTpDd+gQXaJTdIuO0TU6R/fM
AXPBnDA3zBFzxZwxd8whc8mcMrfMMXPNnDP3+AC+gE/gG/gIvoLP4Dv4EL6E
T+Fb+Bi+hs/he/ggvohP4pv4KL6Kz+K7+DC+jE/j2/g4vo7P/wP0W4rJ
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95}]},
        RowBox[{
          RowBox[{
            TagBox["x", HoldForm], "+", 
            TagBox["y", HoldForm]}], "\[Equal]", "3"}]],
       Annotation[#, HoldForm[$CellContext`x] + HoldForm[$CellContext`y] == 3,
         "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxdWAdYVMcWvrtL31V6R9gFNWIl1kTFe0RAaUZNs4CFQGz4FJVEY0CeJipi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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161}], LineBox[CompressedData["
1:eJwN0WciFgAAANAPGVEokSIZLWWUELmFIzgA9+mnWVqU0SQrlTQoIqFUthSS
zPfjneCllVWUlgcFAoFrVFJFNTXUUsd1blDPTW5xmzvcpYFG7nGfJpppoZUH
POQRj3nCU9po5xkddNJFNz08p5cXvOQVfbymnze85R3vGWCQD3xkiGE+McIo
nxnjC+NMMMlXvjHFd37wk2lmmGWOeRZYZIlfLPObP6ywyhp/WecfG/xnky22
2WGXgIAggglhH6GEEU4E+4kkigMcJJoYYjnEYeI4QjwJHCWRYxwniWROkMJJ
UkkjnQxOcZoznOUcmZznAllkk0MuF7lEHpfJp4BCrlBEMVcpYQ9VjVYD
          "]]},
        RowBox[{
          RowBox[{
            SuperscriptBox[
             TagBox["x", HoldForm], "2"], "-", 
            SuperscriptBox[
             RowBox[{"(", 
               RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 TagBox["y", HoldForm]}], ")"}], "2"]}], "\[Equal]", "4"}]],
       Annotation[#, 
        HoldForm[$CellContext`x]^2 - (-1 + HoldForm[$CellContext`y])^2 == 4, 
        "Tooltip"]& ]}], {}}},
  PlotStyle -> All,
  AspectRatio->1,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "GridLinesInFront" -> 
    True},
  PlotInteractivity:>True,
  PlotRange->{{-10, 10}, {-10, 10}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.9658351359053583`*^9, {3.9658352646336613`*^9, 3.965835287030897*^9}, 
   3.965835566604816*^9, {3.965835633957131*^9, 3.965835652482273*^9}, 
   3.965836476668298*^9, 3.9658376501339407`*^9, 3.965837689894652*^9, 
   3.9658377260728903`*^9, 3.965837761849053*^9, 3.9658379527222977`*^9, 
   3.96583800762784*^9, {3.965838048006462*^9, 3.965838080978147*^9}, {
   3.965838116922064*^9, 3.965838151925783*^9}, 3.965839609271036*^9, {
   3.965839647278573*^9, 3.9658396663875923`*^9}, 3.965839902785265*^9, 
   3.965840092733074*^9, 3.965840141768217*^9, {3.9658403370376596`*^9, 
   3.9658403560008907`*^9}, 3.965840530396101*^9, {3.965840733535906*^9, 
   3.9658407462348633`*^9}, {3.965840801738523*^9, 3.9658408616646137`*^9}, 
   3.965840946294663*^9, {3.965841070105514*^9, 3.965841093597355*^9}, {
   3.965841125809127*^9, 3.965841184033784*^9}, 3.965841719493121*^9, 
   3.96584174967936*^9, 3.965842162692028*^9, 3.965842251133554*^9, 
   3.96584244345675*^9, {3.9658427387085533`*^9, 3.9658427470852137`*^9}, 
   3.965842960816729*^9, 3.9658430526576853`*^9, 3.965843130153043*^9, 
   3.9658432417349052`*^9, {3.9658433420084343`*^9, 3.96584335954498*^9}, 
   3.965914269289624*^9, {3.965915196056584*^9, 3.965915217592923*^9}, 
   3.9659153608147573`*^9, 3.9672969263780317`*^9, 3.967472143363435*^9, 
   3.967476104734227*^9, 3.967476174531993*^9, {3.967476244896802*^9, 
   3.967476257256762*^9}},
 CellLabel->
  "Out[108]=",ExpressionUUID->"84169b17-495a-4952-bbe2-f7c5c766d034"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"thick\"", ",", "\"yellow\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thin\"", ",", "\"purple\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thin\"", ",", "\"cyan\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dotted\"", ",", "\"yellow\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thick\"", ",", "\"red\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dashed\"", ",", "\"red\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thin\"", ",", "\"magenta\""}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"C\[OAcute]nicas\"", ",", 
           RowBox[{"{", 
             RowBox[{"3", ",", "2"}], "}"}]}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", 
     RowBox[{"-", "10.5`"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "10.5`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", 
     RowBox[{"-", "10.5`"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "10.5`"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9658351359053583`*^9, {3.9658352646336613`*^9, 3.965835287030897*^9}, 
   3.965835566604816*^9, {3.965835633957131*^9, 3.965835652482273*^9}, 
   3.965836476668298*^9, 3.9658376501339407`*^9, 3.965837689894652*^9, 
   3.9658377260728903`*^9, 3.965837761849053*^9, 3.9658379527222977`*^9, 
   3.96583800762784*^9, {3.965838048006462*^9, 3.965838080978147*^9}, {
   3.965838116922064*^9, 3.965838151925783*^9}, 3.965839609271036*^9, {
   3.965839647278573*^9, 3.9658396663875923`*^9}, 3.965839902785265*^9, 
   3.965840092733074*^9, 3.965840141768217*^9, {3.9658403370376596`*^9, 
   3.9658403560008907`*^9}, 3.965840530396101*^9, {3.965840733535906*^9, 
   3.9658407462348633`*^9}, {3.965840801738523*^9, 3.9658408616646137`*^9}, 
   3.965840946294663*^9, {3.965841070105514*^9, 3.965841093597355*^9}, {
   3.965841125809127*^9, 3.965841184033784*^9}, 3.965841719493121*^9, 
   3.96584174967936*^9, 3.965842162692028*^9, 3.965842251133554*^9, 
   3.96584244345675*^9, {3.9658427387085533`*^9, 3.9658427470852137`*^9}, 
   3.965842960816729*^9, 3.9658430526576853`*^9, 3.965843130153043*^9, 
   3.9658432417349052`*^9, {3.9658433420084343`*^9, 3.96584335954498*^9}, 
   3.965914269289624*^9, {3.965915196056584*^9, 3.965915217592923*^9}, 
   3.9659153608147573`*^9, 3.9672969263780317`*^9, 3.967472143363435*^9, 
   3.967476104734227*^9, 3.967476174531993*^9, {3.967476244896802*^9, 
   3.9674762572589417`*^9}},
 CellLabel->
  "Out[111]=",ExpressionUUID->"8adb053c-8cff-4fbc-ab71-f848814b1630"],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/conicas7/conicas7.\
tex\"\>"], "Output",
 CellChangeTimes->{
  3.9658351359053583`*^9, {3.9658352646336613`*^9, 3.965835287030897*^9}, 
   3.965835566604816*^9, {3.965835633957131*^9, 3.965835652482273*^9}, 
   3.965836476668298*^9, 3.9658376501339407`*^9, 3.965837689894652*^9, 
   3.9658377260728903`*^9, 3.965837761849053*^9, 3.9658379527222977`*^9, 
   3.96583800762784*^9, {3.965838048006462*^9, 3.965838080978147*^9}, {
   3.965838116922064*^9, 3.965838151925783*^9}, 3.965839609271036*^9, {
   3.965839647278573*^9, 3.9658396663875923`*^9}, 3.965839902785265*^9, 
   3.965840092733074*^9, 3.965840141768217*^9, {3.9658403370376596`*^9, 
   3.9658403560008907`*^9}, 3.965840530396101*^9, {3.965840733535906*^9, 
   3.9658407462348633`*^9}, {3.965840801738523*^9, 3.9658408616646137`*^9}, 
   3.965840946294663*^9, {3.965841070105514*^9, 3.965841093597355*^9}, {
   3.965841125809127*^9, 3.965841184033784*^9}, 3.965841719493121*^9, 
   3.96584174967936*^9, 3.965842162692028*^9, 3.965842251133554*^9, 
   3.96584244345675*^9, {3.9658427387085533`*^9, 3.9658427470852137`*^9}, 
   3.965842960816729*^9, 3.9658430526576853`*^9, 3.965843130153043*^9, 
   3.9658432417349052`*^9, {3.9658433420084343`*^9, 3.96584335954498*^9}, 
   3.965914269289624*^9, {3.965915196056584*^9, 3.965915217592923*^9}, 
   3.9659153608147573`*^9, 3.9672969263780317`*^9, 3.967472143363435*^9, 
   3.967476104734227*^9, 3.967476174531993*^9, {3.967476244896802*^9, 
   3.96747625771996*^9}},
 CellLabel->
  "Out[112]=",ExpressionUUID->"047e2d9e-a278-4a8d-9dd1-641b66abacbd"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967296926378635*^9, 3.967472143363935*^9, 3.967476105198498*^9, 
   3.967476174996975*^9, {3.967476245359001*^9, 3.967476257720796*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[101]:=",ExpressionUUID->"e92a40f6-09fc-4664-909a-00c768e030df"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967296926378635*^9, 3.967472143363935*^9, 3.967476105198498*^9, 
   3.967476174996975*^9, {3.967476245359001*^9, 3.9674762577212048`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[101]:=",ExpressionUUID->"8ba5725a-0172-47ae-a82a-035d0f71ca3b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967296926378635*^9, 3.967472143363935*^9, 3.967476105198498*^9, 
   3.967476174996975*^9, {3.967476245359001*^9, 3.967476257721673*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[101]:=",ExpressionUUID->"82dac6c7-3153-49f0-859d-a8927836ac0d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967296926378635*^9, 3.967472143363935*^9, 3.967476105198498*^9, 
   3.967476174996975*^9, {3.967476245359001*^9, 3.967476257721966*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[101]:=",ExpressionUUID->"ff6ee03e-5ba7-46c4-9e87-6b4f9ec9753e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967296926378635*^9, 3.967472143363935*^9, 3.967476105198498*^9, 
   3.967476174996975*^9, {3.967476245359001*^9, 3.9674762577222557`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[101]:=",ExpressionUUID->"b33a4c62-2ce5-493a-9079-10b569dea108"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967296926378635*^9, 3.967472143363935*^9, 3.967476105198498*^9, 
   3.967476174996975*^9, {3.967476245359001*^9, 3.967476257806849*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[101]:=",ExpressionUUID->"497f87ca-9397-41af-996b-f5de482b6cd0"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967296926378635*^9, 3.967472143363935*^9, 3.967476105198498*^9, 
   3.967476174996975*^9, {3.967476245359001*^9, 3.967476258813451*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[101]:=",ExpressionUUID->"6715b4e3-038a-4fb5-b571-e576ed8184f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", "\<\"/Users/enriquevilchezquesada/Downloads/conicas7/\
\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/conicas7/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967296926378635*^9, 3.967472143363935*^9, 3.967476105198498*^9, 
   3.967476174996975*^9, {3.967476245359001*^9, 3.967476258816729*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[101]:=",ExpressionUUID->"2b99e203-14e7-49ce-883e-dffd5fbe0287"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"conicas7\"\>"}],
  SequenceForm["Archivo: ", "conicas7"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967296926378635*^9, 3.967472143363935*^9, 3.967476105198498*^9, 
   3.967476174996975*^9, {3.967476245359001*^9, 3.967476258818572*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[101]:=",ExpressionUUID->"f4a77027-ff7b-4920-ae70-436e6c444bb2"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967296926378635*^9, 3.967472143363935*^9, 3.967476105198498*^9, 
   3.967476174996975*^9, {3.967476245359001*^9, 3.967476259688753*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[101]:=",ExpressionUUID->"7bbc74dd-446b-4f93-b5ed-9f76b8d08fa7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/conicas7/conicas7.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/conicas7/conicas7.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967296926378635*^9, 3.967472143363935*^9, 3.967476105198498*^9, 
   3.967476174996975*^9, {3.967476245359001*^9, 3.96747625968935*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[101]:=",ExpressionUUID->"9301b838-4274-43ba-9d96-ce1d0f72283e"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/conicas7/conicas7.\
pdf\"\>"], "Output",
 CellChangeTimes->{
  3.9658351359053583`*^9, {3.9658352646336613`*^9, 3.965835287030897*^9}, 
   3.965835566604816*^9, {3.965835633957131*^9, 3.965835652482273*^9}, 
   3.965836476668298*^9, 3.9658376501339407`*^9, 3.965837689894652*^9, 
   3.9658377260728903`*^9, 3.965837761849053*^9, 3.9658379527222977`*^9, 
   3.96583800762784*^9, {3.965838048006462*^9, 3.965838080978147*^9}, {
   3.965838116922064*^9, 3.965838151925783*^9}, 3.965839609271036*^9, {
   3.965839647278573*^9, 3.9658396663875923`*^9}, 3.965839902785265*^9, 
   3.965840092733074*^9, 3.965840141768217*^9, {3.9658403370376596`*^9, 
   3.9658403560008907`*^9}, 3.965840530396101*^9, {3.965840733535906*^9, 
   3.9658407462348633`*^9}, {3.965840801738523*^9, 3.9658408616646137`*^9}, 
   3.965840946294663*^9, {3.965841070105514*^9, 3.965841093597355*^9}, {
   3.965841125809127*^9, 3.965841184033784*^9}, 3.965841719493121*^9, 
   3.96584174967936*^9, 3.965842162692028*^9, 3.965842251133554*^9, 
   3.96584244345675*^9, {3.9658427387085533`*^9, 3.9658427470852137`*^9}, 
   3.965842960816729*^9, 3.9658430526576853`*^9, 3.965843130153043*^9, 
   3.9658432417349052`*^9, {3.9658433420084343`*^9, 3.96584335954498*^9}, 
   3.965914269289624*^9, {3.965915196056584*^9, 3.965915217592923*^9}, 
   3.9659153608147573`*^9, 3.9672969263780317`*^9, 3.967472143363435*^9, 
   3.967476104734227*^9, 3.967476174531993*^9, {3.967476244896802*^9, 
   3.967476259701014*^9}},
 CellLabel->
  "Out[113]=",ExpressionUUID->"136f17df-4471-4f33-8a4a-eeeff11b00eb"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 8: varias c\[OAcute]nicas", "Subsection",
 CellChangeTimes->{{3.967295680579814*^9, 3.967295688242674*^9}, 
   3.967295731414084*^9, 3.967475341257018*^9, {3.96747584927953*^9, 
   3.967475850244375*^9}},ExpressionUUID->"aef04dee-b0bc-4345-b21e-\
40738ad32ec8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "==", "9"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "/", "4"}], "+", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"y", "+", "1"}], ")"}], "^", "2"}], "/", "1"}]}], "==", 
       "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"y", "==", 
       RowBox[{
        RowBox[{"0.2", "*", 
         RowBox[{"x", "^", "2"}]}], "-", "4"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"x", "==", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "0.3"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"y", "-", "2"}], ")"}], "^", "2"}]}], "+", "4"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "+", "2"}], ")"}], "^", "2"}], "/", "2"}], "-", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"y", "-", "1"}], ")"}], "^", "2"}], "/", "3"}]}], "==", 
       "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"y", "==", 
       RowBox[{"x", "+", "3"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"y", "==", 
       RowBox[{
        RowBox[{"-", "x"}], "-", "1"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"x", "==", 
       RowBox[{"-", "1"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"PlotStyle", "->", "All"}]}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "8"}], "]"}]}]}], "}"}],
     "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<C\[IAcute]rculo\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "2.5"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<Elipse\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", 
             RowBox[{"-", "0.5"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<P1\>\"", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "2"}], ",", 
             RowBox[{"-", "3.5"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<P2\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"3.5", ",", "3"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<Hip\[EAcute]rbola\>\"", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "3.5"}], ",", "2"}], "}"}]}], "}"}]}], "}"}]}]}], 
     "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", 
       RowBox[{"-", "5.5"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "5.5"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", 
       RowBox[{"-", "5.5"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "5.5"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportConicsToTikZ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", 
          RowBox[{"y", "^", "2"}]}], "==", "9"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "/", "4"}], "+", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"y", "+", "1"}], ")"}], "^", "2"}], "/", "1"}]}], "==", 
         "1"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y", "==", 
         RowBox[{
          RowBox[{"0.2", "*", 
           RowBox[{"x", "^", "2"}]}], "-", "4"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "==", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "0.3"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"y", "-", "2"}], ")"}], "^", "2"}]}], "+", "4"}]}], ",", 
        
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"x", "+", "2"}], ")"}], "^", "2"}], "/", "2"}], "-", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"y", "-", "1"}], ")"}], "^", "2"}], "/", "3"}]}], "==", 
         "1"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y", "==", 
         RowBox[{"x", "+", "3"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y", "==", 
         RowBox[{
          RowBox[{"-", "x"}], "-", "1"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "==", 
         RowBox[{"-", "1"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], "}"}], 
    ",", "\"\<conicas8.tex\>\"", ",", "grid", ",", "estilos", ",", "ejes", ",",
     "texto", ",", "xmin", ",", "xmax", ",", "ymin"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967475377921639*^9, 3.96747542685352*^9}, {
   3.967475822716267*^9, 3.967475823352441*^9}, {3.967476280601543*^9, 
   3.9674764524339*^9}, 
   3.970593823791328*^9},ExpressionUUID->"d35b87ae-735c-4063-8570-\
3c194088cceb"],

Cell[BoxData[
 GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJxdlm9oVXUYx+923T3QC0dus94kTFTK64sU/5Skv+dFSLck0YwoCv/OgpJY
loJZvZiUNaXYi0xFeiEM0UFdcJubuN8vNucfelGSIl0iJN1WbK2uTiT/rHme
53Ng57Jx4Jzz+/2e5/t8nu9z6je+u6ahMpPJHJ34f3DtuPLy+dPNv/lHT83t
2lGMwvGtpY6tpcu+tvVCTeuFKJxryDeN9/3oq2fv/qD5ryh8Gz/v9xsO9GVn
34hCxciRh0eO/OD3tI191jYWhUz8O/dM+5l505bej8J8fe54fkf3c+zXq+e5
GjvvvMbjHrF4VrXMKrTMuur84qavdh2MQnfh0InCoWuuc/vbE39ROB2vH3CN
mWP5P1dG4Y+lnz8/XYZc5mp/af/CKDzxzdDo5vZh1xG/lwt7enrLB3b+437J
Hm9u/DQXVsb7/+v2RusPF97Khbp8cVq+WHar6+vW1NflQtf7996sarrpFjW+
8+XT31WF7nifW+6VzqM9j1VXhZ7VL5WnLrvtKsqnDv/0/ZSwaM6mBXM2/efG
4182jE1dJh933nEDGy/tO9iSDY8XHhx41w1sWz64bXk2rGvrntjhvrvWe3Ld
/rWV4aMVX8+42JeR5+K4KsJ47Zaas7cyclev4QW9Lzv1vTCo6+Q13ccP6b4y
U8/xQ3qu/K1x+Mq4PlMkr3H6rMYtHZqHf1XzkhOap39K85ai6uBNF5muOvl9
qpusUB39ZdVVPlGdfZfqLs9uf/GLJ5eM+F1xoXIyI45v2FdoneSi1s2/p3WU
otbVW52lU+sOp9Jq3G6u3Xvl+s+RwK1xJaPGrXEnvw8rp8alwCnPq41T1s/c
opyyP5xyfpdxSnz9xqVxKHBpHErJuPzQ8p+r+Tv0EdXHXTL9moxT41LgdJXp
X2+cLrH6tBunxqXAaaXVt9s4pf7zjNNB46MMp8YPnF43vt4wTlP8yT3jkyv3
eY917JPiPzmXOIiLOFP9luRJ3uiALql+TnREV3RGd+pAXUqT/UNS/pLUmbrD
AVyk/CzhCK6qJ/uhpPwy4ZTno5P9V1L+nPQB59MnxEcf0Vf0GX1HH9KX9Cn6
0Mf0NX1O3+MD+AI+gW/gI/gKPoPv4EPUG5/CtxIfM17wOXwPH4Q3fBLfxEfx
VXwW38WHEy7Np/FtfBxfx+fxfeYAnDInmBvMEeYKcwZOmUPMJebUBuPUuAxw
ylxjzjH34JS5yJxkjjJXmbNwyhxmLjOnmdvM8ZRfJnOf9Xwn8N0Ap3xX8J1x
0uI7ZpwalwFOye9X4xQ98jrHvfVx2G1cGocBLtea3g8Zl4utHuYbcBjg0vwx
mD/6VL29+VIow6XxApfma+F14zLFWzBfTK7c5z3WsU+K9+Rc4iAu4iRu8kj1
W5I3OqALOqX6OdEVnRvMD6hDyi+SOlG3lN8kdabu6e/N/wHmqBjH
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168}]},
        RowBox[{
          RowBox[{
            SuperscriptBox[
             TagBox["x", HoldForm], "2"], "+", 
            SuperscriptBox[
             TagBox["y", HoldForm], "2"]}], "\[Equal]", "9"}]],
       Annotation[#, HoldForm[$CellContext`x]^2 + HoldForm[$CellContext`y]^2 == 
        9, "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxdVwk4lFsfn2HMtChu3KQQWrgoWm65pd5TKooWS665EglZrrT4tJF9p1BC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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
          180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
          193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 
          206, 207, 208, 209, 210}]},
        RowBox[{
          RowBox[{
            RowBox[{
              FractionBox["1", "4"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                 RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   TagBox["x", HoldForm]}], ")"}], "2"]}], "+", 
            SuperscriptBox[
             RowBox[{"(", 
               RowBox[{"1", "+", 
                 TagBox["y", HoldForm]}], ")"}], "2"]}], "\[Equal]", "1"}]],
       Annotation[#, 
        Rational[1, 4] (-1 + HoldForm[$CellContext`x])^2 + (1 + 
           HoldForm[$CellContext`y])^2 == 1, "Tooltip"]& ]}], {}}, {
    GraphicsComplexBox[CompressedData["
1:eJxFVglMVEcYhuUQ2HVPaj1iujTKIUZo01Qt6EytwUrRcCgeCcZaj1TEG1rr
VY3WShqlq1ZawTaQgHgQ8EBAcH5laxe1VkRdkKrUVqsWFWtdFFns2/f/s77M
vpfs7sw/83/XC5uzJHWexsfHZ5Py8TzxCgV8djJH2sb4oQ4LDJtoGzLR1sHe
Sj49aFKhBWI7HC3+j++xzJsVrr6ZFqjPaqvKarvDPP8aMtECFWPfubrlzF+s
ts5W+NRqAX2T82Hw/FusWOy48u8ZMxxX7kHh11jwhgWLrQfM0KDOv8qicosi
c4vM8EWGMzvDeYWpy9nM0Hlx+hsD/2lm4zpTjk8JM8NXo/olDxpTx3aPTIht
ummi/Tri18fsbInca4JZk/5uK553UqjTh5iAB8SUtt++LJ5+dnjmjf4mmOuo
+W2E9aoQXy8sXGsywQGsLxYY8sfMdhmhYU/xkm0nW8WiR1GXpuYZoTE98OXW
0bfEsgGdjX+8bYRKPK9I/olv0AQY4ZedUWklSfeE59uqLAMknzoX9fnoBwIy
7jc+e6AHQ/vg8H5DO0XJar+z9l16SFD39VhkxMU69ef7QnXO7PLB+U+EY3KH
fXKHDrLmROTMiXCJ4dcHJYeX6+CoWs8lEnu+MbNiHfhevmib4XYJ7I8OzivV
AmK6RJP7SX3oci2sPTx1WntKt/hQraMF3azJyo5eiIZPt6yNLgiBN9V5PeK7
T0YrIwSyZ+xWhluoZaqC4WTBxt1pnb1ibH3ugJXPgkC5/Tdsvg/c06Xf1aUH
Aa7rCz5u/bGc8j5gC5s+YU+XL6jHbwuEOnW+Bmq+31exfmYgaIb/+ty03g9u
XPdcAfBSvfygenv72I0v/L1P+T3iGQh5pf6rEvP8YMJr7THVmYEQV2lRhp+3
TuPRvb3Zr2tgZN7URSkX+nj3Fe1pR2kQtCzcrgwf6D0S5j4SFgwr0teNK9j1
0nvOH+8cej+/wy2i94/v0cx91Zf3VL6EwMhnNVudO7pFuTV8mnGHFlqzPcTs
8vbdtdTQpQzxc+JBe+LBVzjFKrND617hKHFNPmE+Fp3yRJRlbL22a19fLw+0
Kj56WHi/ZPH9kociLXJzauRmPZzZxCy9SXdFv8op9lSTwcs7xNsA+epGbnl5
F7zgdoR9Rqvo49pWtqHe4OX1ihBPAQM4Auwll/KahbN46ZgQpwHWrB74cU1p
pajOzSn5r9vg1RE+jfA7/s7k7+04n8n5UrdyfSvWZ7I+7Y/J/aXvb/zzgvkO
800oC98eZ/D6xjk6Twuel4XSeVdiP1gq9SMJ+8VCqF9p2E+2j/q5BvvNGqjf
tYgHG0F4dCNezE54EZ5M4hmHeLNDhPcPiht82fqCSR1FIj/YKOJHEfKHDSP+
LEd+Mcmva8g/3kP8+wj5ySOJn2eRv/xd4m888ptLftuQ/zyB+I8e7c97VZ0E
QC3qhleRfm6ivrjU0QnUH/cl/dXguryW9KlB/fJvSb+kby51xFD/vD/pfyme
i1eRP+Sjf/Bl5B/kL1zqCPHScg35TzP6E19F/lRQW7antkzLM9V1n4sIxIHb
yc+S0O+4uxn9rmL8g8TL5ToudXYacebrSGez0E/5UfJT8lsudUZ+zLXkxzeQ
lzye/DoF/ZyfIj8nv+dSd5QH3E55MB/zgj+ivKA84VJ3lDd8OuVNIuYRt1Ie
UV5xK+UV5RmXOvwA846fprwbinnIjU2Yh5SXfBPl5YH9nsvMpS6LMG95IeUt
5bEyH/OY8prLvKY851KXlPdc5j29D3D5PkDvC1y+L/wP0LQM6A==
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132}]},
        RowBox[{
          TagBox["y", HoldForm], "\[Equal]", 
          RowBox[{
            RowBox[{"-", "4"}], "+", 
            RowBox[{"0.2`", " ", 
              SuperscriptBox[
               TagBox["x", HoldForm], "2"]}]}]}]],
       Annotation[#, 
        HoldForm[$CellContext`y] == -4 + 0.2 HoldForm[$CellContext`x]^2, 
        "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxFVgk41OkfHzMMZsb85sifooMlsaRsIcn7bVPrLNmkntmlyBIlUqFWG5Uu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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154}]},
        RowBox[{
          TagBox["x", HoldForm], "\[Equal]", 
          RowBox[{"4", "-", 
            RowBox[{"0.3`", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                 RowBox[{
                   RowBox[{"-", "2"}], "+", 
                   TagBox["y", HoldForm]}], ")"}], "2"]}]}]}]],
       Annotation[#, HoldForm[$CellContext`x] == 
        4 - 0.3 (-2 + HoldForm[$CellContext`y])^2, "Tooltip"]& ]}], {}}, {
    GraphicsComplexBox[CompressedData["
1:eJxFVwk4lNsbt45hxpglVG6LhJIS/zZLzslehMiS6IrbdNNCixSKdKVS1yVZ
qttiyD9abtaS7jl2yhYiSxcj+zYixJS/Zu43/+8533Oeb57ve895f+/v957f
qHr5OhyQEBMTezd//5iF1wKs03R9U2m/OE7IC7tEa2Rh5SXLjPzPiONFrm4v
xHNZ2Cpm5faYleJYMG1nYZsl//GvbJhD98M2ZqkZszDHON8xL3EO6VpEtvE2
snBzztHWnKNzaIG9tkYNmYW7fpnR2n/kOzrzKHt+MPGKH2Fi+EjC3D30XioT
p+3xyR414iNB+BgmNgiaHGrOnEUmvX6vh5lMbPTF07H1wzSK2vnA5Y9cBs76
Eb51EunK7OAmhTIw65a5w5rDX5Dg85UMXEI1CA5UHEdr6l0/OY3RMfrdse3i
2BjaFVh7Ra2Sji0E742hq/UH5gcdp3q/e+z9bghtjl4+c2gnHfNVVi/mRg0i
29AUfcBVwM8F6/UgyfWP33/KV8CsK51V2Xe7UasgTwXcPZjoVGbfhbJPu+jU
qihgU0H8TtQU2bRKL4+Ga0quWd8IaEO5RxTcltrScLogXiNSs5tlGJbLY/8g
jfh8lzcoOmJE7JSPPPauiojcK/0K5egseDhMkcfCOpUbGURL17kPUjH3x2T2
EAjxomLt1LcLUt8Wg1OH1vFLfqPiGkH8UqCYU7s3fC0VW7+v9rPLrgdfsyPc
nalUXCRcH8Ttf64/3E7Ba9O48juPtQEbxf0pFs8p2E64f2D6e3HD1B0KNgxL
DlhF6gKHI/Ia405S8GshHqB9i2R+lQsF1zxV3rO3ZBA4U2N5Fo4UrCXY1xCw
e9+X1utAwRZOnPS71sNAIXn4s7M9BdsI8Qd7yXaGFDYFf2Slq9DOjYNY27KP
pT4ULCnIdwJ0pBxMOhxAwXqalzIyUiZAD0X1eVwSBecJ6w9afViJ7TUUbK3V
XAU9p4FU28yR0ikKPi4ozFdw0VxGaYkrFfdsC5YZW8IHvL93M5x9qHiVkH+g
fXDg4F1/Ks6Q7Pzz7lu+CM/C8pL91h7fgEf+xf8oj1Jxu5DPoPdUtMJGKI+v
sNX3PTwtBhmaSlNFV+SxtVAfUFgnGl7ZvnrvHZYEPKy0L0ZFk4Zf6W2IWXtY
AirWXOktPknDRgt/otJIkvDk8Q8OLsM0LNSiFLz2ZLX55uUKeJesWVzITilI
8Ktqy9w0LpeCbL3kWcSi4wokdjtZlQR/Jck4lJjS8UsBHiSYtT3FV+xPOuZ+
bz4UPSADCT24JP584PxNWfix70zdVS0GtlxH2zuQJgu/e1C1CtcysJ9gIVlo
Wbi6KhIw8FHDAv/qIVnYXQf9JvMYeKRsT2PoAQocym0yDV3MxJpCnKDbb813
mLZMnFcnuSFnsTwk9BvSdfLTzgZ56O4ClY91MfGxW4zJI29pUH3WrzpFhYX/
EeYFiX5yZJqva9mvAE9o+166H8jC355a9hoY0SHRn7bWjBvVjNPhtpbo+iUj
0+Df3+HRGeM2feo0qP8pdbIykwUJXrybMK6ftWHB/V33pXxrJsG/60DKcefz
Jne+APvLmZ9ZXCac7gm5deLpBFAX7hsSvPPeWkeu3c2E8ERpM19nHKx+dyj0
mAITErytttV3nXFlwMry07vkynkgTYpumWXIgLQ4ZLj5HA/sEOIOd6mR/hvf
NAxU9drSPePosCjBfvOriiHQP6SYWM6mwzZH5YKzb/sAgYfNy7GgGWofmFFb
leaoqgAJnbUqxl0jp9GgS5KftsW+LiDG15a5cVwehkRcMZet7gBEPdbeHQxx
u/ARLDb1i4x8TYGEzs8yPOluvnKwYOrD2YN+DWC9lstGI6n555/Q4JaqOkDU
n+3jOZqwuBx4nHpnruxBhp9KEvO2OJaBWAF+ZPjonEvZPc0yEOe97fh+MzIk
+kzxSfMimhEZhquLvw50zgAEH2NrrPpLT6SC4B2bbiedI0GijwV6NPl7NElD
82/63fk77iNh/tKwtG+fB+1aNtoxNXDC87EUTHja3cFGGBH6uCdcD50uzzU8
qC8JGS0a5nsuv0HDc6c/KldJQOaVR6P6EZVIQ4CHBEx4kLRII78WVaW/NQrq
m9fnVs8K3vdaRO/iXnrZKA6HEmdz6M/qEaFf+66HbO7NBiQmvrS9o1UMEn16
61WnYxpaYtAwydj6aPAHRPQD3axudfmjzWirevqcbcV3sIGjashRbUWRjZzw
Rs43sFCwjzZEP7jun4JEPjDX9poFf7Yhov/0BWeG7JP8B8H2oXtNobPA/bLE
VzeTdhQURm64fmYG1Oz5YvpoYQci+lkuuUw62bIDpSuRbX6x+gqIc+bIHeoK
Bfcp8ACpWhS6dKJDUm7Z0l8mQeVHF3OtA52I0MXxF9TpT36diON28Gez7EmA
TL1uWqziooIPSzVaLkyAz8WfBquduIjQwap1HcZFh7mIrrci/KD7OHjF2aB9
P4WLyLcfGyzqHgNOv3owK8u4iNBFb5upcwXiopmh2MJJZx5IuJQwDPO4KGQr
qWJKcwR8KSt4ofqKi4jz4atSQKh6LBf5F4Ph7BWDwCGv5MJJKy6qvBk8ajvX
C6IYuqG/anIRoYNbRU/YKVJcxDZySHSb7Qan15qxF2l0ojDhDIZf7QxvVO9E
xPl1qD8ZRc0/rzZMrotV6xTh5RSSBVqWdQK3qMgN3rHtiNBJ08KAi1HnP6L4
QjBgvaUWoOuu8UvHmxBfvE6GFhQNVJY/4tSGNyGCx5u1RuIrbJvQ92XPzKYb
gxHBFwXpkT3G5XEoTr7Y6tGjOkTwdnAiwmCdaa1odlvxunm3fhXaecNHPfBx
Pep1XR3EX/NGFIf4rvgEbXnU+2ZkZbknMGJVAXJjkE89921HSmpvn4HUfETk
dcOsu+ebbgZqMxAn1fl0oSEPJbvKmgSUn+e1e3RBD3LX113f3h6OCD+znqLW
7fgyEFVlpuzroPeK8rrDOsY7w+5FhcFnTeqqc8FSYb1Qv6dFp/FaDFyvTTU3
bB1BhP4NNC+8sD/JQ2c3uQY9V3wDCH+l1lrv29RSC0ZO97TkJn8W4WyQkR1i
1jKBZthz+aS2ZsD2dfC3VJlE45yIdemJrYDwd3rbw3W3h3eCmZBLX+cHijky
anBfpQtcs7rD9sqYQWZZhT0wqRsQfnIk/YHvDe0eIKulY5XTzxfxpk89yX7j
3m9I7+8sOSXuAFhjvG5D3wox3Pel9O71+GFA+NsDCQu0ApJHgVO2Lud1lbjI
pyzJ8npGeiKBW54nFFdu+Qy28MwLuf6SOFZO2ebM589gTnBJYsPrNzX6OBPA
mLeivFBFWuRTdoUVPNsWT8Ixj905ncwpsKP6Fs5EJMxfxNcINJgCOcJ+iVcu
lRk7tnsaDJqPOY7Ey+CkYebrrN++gkCV2wObvcjYh0O6YBg0C44K+zXup+td
nZ6eBdemevIuSsqJfM22WbuoHC85fGbbH58afb8Dvs0NszAOBVfzNVLlquZE
PqfaotXl/CkxmBTbquhh8n8fU2B31fvEchoue/lAlpkhDn+O4i3e3EHDT6PD
/ipfKCHyJXfF0qYu8yTgstbOsThjusjHbPorwEZ+iI4DAzN5FTpSUP79G/sn
VAbuSR7SMXWQEvkSlZgmN+QrDReGagQcamFgh0ytiw/PSUPe4MurB7rmfb33
VV/T6ySRr5A4bKAm9xcJhr7xGpmZ/99AnDN61KL11CImvqETwr6XJiPyFQsT
unX7eTKwdiDQxMSfhYlz7HqG3wLOYxZ+JtsQ6lRBFvmM/wH4Ulux
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75}], 
         LineBox[{76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 
          91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 
          106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 
          119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 
          132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 
          145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 
          158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 
          171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 
          184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 
          197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209}]},
        RowBox[{
          RowBox[{
            RowBox[{
              FractionBox["1", "2"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                 RowBox[{"2", "+", 
                   TagBox["x", HoldForm]}], ")"}], "2"]}], "-", 
            RowBox[{
              FractionBox["1", "3"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                 RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   TagBox["y", HoldForm]}], ")"}], "2"]}]}], "\[Equal]", 
          "1"}]],
       Annotation[#, 
        Rational[1, 2] (2 + HoldForm[$CellContext`x])^2 + 
         Rational[-1, 3] (-1 + HoldForm[$CellContext`y])^2 == 1, 
        "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJw1lEtrU2EQhk+uTVPTJCf+gWq8gT9BmAFBjIqCf0AQXWmsutGVe1dq1I1Q
KLh0IUqNl1Zm0I1QxCIoaqyWVgpW6iVpNE3bqJl3zoEw53x5vjnvzLzfGTk+
evRkPAiCI/9//fgXFwV2bebr5UqtXOnRtn6olXinxXU60A/lEn+qVxv16ho9
7IdGyDeN7zof8i6LHedDfmLcbzrTD/Uin7fYpo+Wp+j8ivNFfmx8k0aNK/Ah
W/9F0FXgpOn8STGLBb5o3DJBV55vGbdE2y3vMD+1fIueL8e7bf0LHbS8OR4z
fp522PomvmTcLJ21OMTPbf9bemQxy7eNf003LGY5sEZMOz/IeXueJNSRYfT1
xZ64xQwfs333Zdb0DvAFe34m4NM8b+N4JeDTfAfvF+hN8Uvb1xDUl+SW8Z+d
T/Ib+3/B+QTfQ/0CvXHea+tfBf2IOf/N+RjfNf678wHvQ/8Fc+zRFVtvyjnb
v0HvbH9LIp+AbzvfpQnMXzDHVdowvX8kYXo7zq9K5BPwXefbtAV5BfNt0Sm8
V+C7pvM9iXxyDbp1CnXQftSlc6iTqqhbD6MPzsc18gn4hPMLhOORUPhujrai
77qIOTif0sgn4FM6ZPwMAUvrOOZMHzB3nYAPnB/QyCfgMzplN5MCvYM6Y8/T
Ar1ZvQwfygP4UiOfnIZv9QR8LGX4Wq/C5wK9OR3BOXA+p5FPwA8r5rwkDZwr
Bbcs0JvXdYs/pIZzqZFPoLeg0NWUCs61Iu+K5ysq5th2vqiRT6AvVMy943pC
198V9CfU9/gOOV/SyCfgS4o+9cS/a97fQP8BO8duqQ==
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79}]},
        RowBox[{
          TagBox["y", HoldForm], "\[Equal]", 
          RowBox[{"3", "+", 
            TagBox["x", HoldForm]}]}]],
       Annotation[#, HoldForm[$CellContext`y] == 3 + HoldForm[$CellContext`x],
         "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJw9lctqk1EUhZMmvSSmTZv4Akq84DMI5wy868gXUAQHgrH6JEp0qgOnjiwS
LyBnoxPBiYgIEhURFUWE1kuL2lbbvfbXn4SVnP/sc9a+rb3jzPzJs2OVSuXc
xncT9Ww34Wy+2x8N+6OuzW/CsJ2FXXu7Cf12HvSObny65jCYycd8oWtXfWEm
a71jR3x9Or92u47p3Fa+5hs6tsf3tfIFP3/OtG9b9uXenOmeZq46rzkTNvM9
P2fWLrpdI+veWdvlhlN5JJ4mnAx+bRNO5vtuP2PCifBvOvwdD/6t8K8e57fC
v3pWzFomrEe8muHfWO6Llwmr4X8j/Kvm486jYcJq+DcV/lXyULzsvNuvJfk1
EfzXkuI3YXt9fTUpXuPB70/650/N1h1XkuJbi/tX0hvHmj3we5aT7MYifj+T
8la1K77+PcmviumcpbTb91XshO9bivfrRe+/pZ3iVQ74+y9Jbq0W4eekOvpb
Hrrdp+D/u4jH+3RHvMozBSKpDpaL9r1Kl/yeX+Wxv36ZlOcfRfg0HRKvctrt
FpLyuFgu+4+bqeY8FoPPk/2y+xr3Pyq3xavc8P/Pw6+PRfF5UfY5fii3dH+c
824LWWdfL+z6cc71OJd7uBce8IInvPHjVPiFn/hNHIgLcSJuxJG4EudBxJ08
kBfyVI28kceDkVfyTN6pA+qCOqFuqCPqijqj7qhD6pI6pW6pY+qaOqfu6QP6
gj6hb+gj+oo+CwHc6kP6kj6lb+lj+po+p+/RAXQBnUA30BF0BZ1Bd9AhdAmd
QrfQMXQNnUP30EF0EZ1EN9FRdBWdRXfRYXQZnUa30fHDoevoPLrPHGAuMCeY
G8wR5gpzhrnDHPoPKjTx4A==
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105}]},
        RowBox[{
          TagBox["y", HoldForm], "\[Equal]", 
          RowBox[{
            RowBox[{"-", "1"}], "-", 
            TagBox["x", HoldForm]}]}]],
       Annotation[#, 
        HoldForm[$CellContext`y] == -1 - HoldForm[$CellContext`x], 
        "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxd1F8rQ2EcB/AzW9M0m83eAB1xJ/fEFebPjfIGlFIaLrwMRSNvYlekMdJW
u3G9C8URpaXcoYYM43y/O9+nPafWr8/Zc36/5//AyubSapfjOMv/Pz/yeSkz
ZqYCb3jFnFfsl33lvLQ8lM272bzxgeu/ML7DByl5zm/uGp8hX5/MaHyP75Py
BdonrHy98jD6E5cjiMb76F+PvIXxxeRF5DNm/7vlEupH5UPkM+Z8RGTOrfED
8oWt+Q3J86hvPIJ8jtX+Z7Lz/2/5EfmbMuOnfI7+v8vbyNeQUT77Ji/gxasc
ZZRR3n2WL5H/SR5Dg7rscQPJVfBaLqB+Td6Fj63xXI0HHuX/5cBc35pcYH65
yvoy16suH7H/8gTHJ9txmvMj73D+ZK5XQz7h/MtfLf/5kLnfmvIg11de4/pb
/XcqgWe5f+R17q9KZ/6wjPItY9aLyJzPqMzpM77h+ZB5HmNyjudL3uP5k0OI
cdnl+ZVneL5l3hcJmfspKf9iPManvF9k7teUfMv7Seb+T1v9MW7ff3L7fpQZ
M5U/8LDEYQ==
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 
          85}]},
        RowBox[{
          TagBox["x", HoldForm], "\[Equal]", 
          RowBox[{"-", "1"}]}]],
       Annotation[#, HoldForm[$CellContext`x] == -1, "Tooltip"]& ]}], {}}},
  PlotStyle -> All,
  AspectRatio->1,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "GridLinesInFront" -> 
    True},
  PlotInteractivity:>True,
  PlotRange->{{-5, 5}, {-5, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.9674764644315357`*^9},
 CellLabel->
  "Out[114]=",ExpressionUUID->"e0d54b6e-c2c4-4755-b3e6-be4fe2d89f26"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "False"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"thick\"", ",", "\"red\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thin\"", ",", "\"black\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dashed\"", ",", "\"yellow\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thin\"", ",", "\"orange\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dotted\"", ",", "\"orange\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"solid\"", ",", "\"cyan\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"solid\"", ",", "\"cyan\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dashed\"", ",", "\"black\""}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"C\[IAcute]rculo\"", ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "2.5`"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"Elipse\"", ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", 
                 RowBox[{"-", "0.5`"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"P1\"", ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"-", "2"}], ",", 
                 RowBox[{"-", "3.5`"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"P2\"", ",", 
             RowBox[{"{", 
               RowBox[{"3.5`", ",", "3"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"Hip\[EAcute]rbola\"", ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"-", "3.5`"}], ",", "2"}], "}"}]}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", 
     RowBox[{"-", "5.5`"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "5.5`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", 
     RowBox[{"-", "5.5`"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "5.5`"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{3.967476464435582*^9},
 CellLabel->
  "Out[117]=",ExpressionUUID->"970ba75f-daba-4884-a155-791ade81b38c"],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/conicas8/conicas8.\
tex\"\>"], "Output",
 CellChangeTimes->{3.967476465148226*^9},
 CellLabel->
  "Out[118]=",ExpressionUUID->"b6c4a165-2daa-4e5d-9621-665492e2b2ee"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9674764651489964`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[114]:=",ExpressionUUID->"f13babb0-3c4a-46c3-84a4-d25edc72cfe4"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.96747646514939*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[114]:=",ExpressionUUID->"bc4d9632-30ce-4157-bcd7-b4373231cda6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967476465149858*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[114]:=",ExpressionUUID->"20df4040-6a5c-413a-ab84-59358a147ac3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967476465150165*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[114]:=",ExpressionUUID->"6e82957d-10b7-43ee-a227-270310bc6c17"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9674764651504583`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[114]:=",ExpressionUUID->"1f8026fb-7f01-470c-823f-ebb30270751b"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967476465231632*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[114]:=",ExpressionUUID->"fa17627e-91f1-40fe-b84c-2166a1a84c4d"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967476466237856*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[114]:=",ExpressionUUID->"93fa2bf0-66e7-49aa-b5bf-162ff194c133"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", "\<\"/Users/enriquevilchezquesada/Downloads/conicas8/\
\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/conicas8/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967476466241672*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[114]:=",ExpressionUUID->"c23e7805-511c-4e4d-82c2-7d6183842127"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"conicas8\"\>"}],
  SequenceForm["Archivo: ", "conicas8"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967476466245078*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[114]:=",ExpressionUUID->"ca296857-fefc-48e9-a455-e883c315cb5b"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.9674764671228724`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[114]:=",ExpressionUUID->"76ea2915-947e-484a-8147-ee7fe0b86014"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/conicas8/conicas8.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/conicas8/conicas8.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9674764671234627`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[114]:=",ExpressionUUID->"ffb43973-576b-4830-92f8-16fb7c797960"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/conicas8/conicas8.\
pdf\"\>"], "Output",
 CellChangeTimes->{3.967476467135325*^9},
 CellLabel->
  "Out[119]=",ExpressionUUID->"b484a3fc-d51a-4e80-a9f9-7383b5d21623"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 9: varias c\[OAcute]nicas", "Subsection",
 CellChangeTimes->{{3.967295680579814*^9, 3.967295688242674*^9}, 
   3.967295733602908*^9, 3.967475343508492*^9, {3.967475856991395*^9, 
   3.967475857983245*^9}},ExpressionUUID->"6c5c5f03-e44d-4a8e-8683-\
1a1f5f171e1d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"y", "==", 
       RowBox[{"x", "^", "2"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"y", "==", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"x", "^", "2"}]}], "+", "6"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"y", "==", "3"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"x", "==", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"y", "-", "3"}], ")"}], "^", "2"}], "/", "2"}], "-", 
        "2"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"x", "==", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"y", "-", "3"}], ")"}], "^", "2"}]}], "/", "2"}], "+", 
        "2"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{
         RowBox[{"y", "^", "2"}], "/", "4"}]}], "==", 
       RowBox[{"-", "2"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"y", "-", "3"}], ")"}], "^", "2"}]}], "==", "2"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"x", "==", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"y", "==", 
       RowBox[{"x", "+", "3"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"y", "==", 
       RowBox[{
        RowBox[{"-", "x"}], "+", "3"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "]"}], ",", 
    RowBox[{"PlotStyle", "->", "All"}]}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "10"}], "]"}]}]}], 
     "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<$P1: y=x^2$\>\"", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "2"}], ",", "4"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<$P2: y=-x^2+6$\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "4"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<Intersecci\[OAcute]n\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "3"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<$(-\\sqrt{3},3)$\>\"", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1.7"}], ",", "3.3"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<$(\\sqrt{3},3)$\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"1.7", ",", "3.3"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<Hip\[EAcute]rbola\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "6"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<$r=\\sqrt{2}$\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1.5"}], "}"}]}], "}"}]}], "}"}]}]}], "}"}], 
    "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", 
       RowBox[{"-", "3.5"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "3.5"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", 
       RowBox[{"-", "1.5"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "8.5"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportConicsToTikZ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y", "==", 
         RowBox[{"x", "^", "2"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y", "==", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"x", "^", "2"}]}], "+", "6"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y", "==", "3"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "==", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"y", "-", "3"}], ")"}], "^", "2"}], "/", "2"}], "-", 
          "2"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "==", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"y", "-", "3"}], ")"}], "^", "2"}]}], "/", "2"}], "+", 
          "2"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "2"}], "-", 
          RowBox[{
           RowBox[{"y", "^", "2"}], "/", "4"}]}], "==", 
         RowBox[{"-", "2"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"y", "-", "3"}], ")"}], "^", "2"}]}], "==", "2"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "==", "0"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y", "==", 
         RowBox[{"x", "+", "3"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y", "==", 
         RowBox[{
          RowBox[{"-", "x"}], "+", "3"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "}"}]}], "}"}], 
    ",", "\"\<conicas9.tex\>\"", ",", "grid", ",", "estilos", ",", "ejes", ",",
     "texto", ",", "xmin", ",", "xmax", ",", "ymin", ",", "ymax"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9674754879133*^9, 3.9674756016252937`*^9}, {
   3.9674756474325323`*^9, 3.967475761332703*^9}, {3.96747582654151*^9, 
   3.967475827130096*^9}, {3.967476499383583*^9, 3.967476727737761*^9}, 
   3.967476793318199*^9, {3.967476901367358*^9, 3.9674769317003508`*^9}, 
   3.970593831652536*^9},ExpressionUUID->"4390b575-da26-4f72-befa-\
b85ab8b7f443"],

Cell[BoxData[
 GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJw1Vwtcjmcbf8+kSEqhE59Do1GRYdh1LWdDjHVgh/ikTCnUNGmsUB/pcyjJ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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
          180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
          193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 
          206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
          219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 
          232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 
          245}]},
        RowBox[{
          TagBox["y", HoldForm], "\[Equal]", 
          SuperscriptBox[
           TagBox["x", HoldForm], "2"]}]],
       Annotation[#, HoldForm[$CellContext`y] == HoldForm[$CellContext`x]^2, 
        "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJw1lwlUE0kax0lIEBmOKJAWXXW4RBlRHPFikPoEnRlWkRUvBA9WQDxW8Hgs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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
          180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
          193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 
          206, 207, 208, 209, 210, 211, 212, 213}]},
        RowBox[{
          TagBox["y", HoldForm], "\[Equal]", 
          RowBox[{"6", "-", 
            SuperscriptBox[
             TagBox["x", HoldForm], "2"]}]}]],
       Annotation[#, HoldForm[$CellContext`y] == 
        6 - HoldForm[$CellContext`x]^2, "Tooltip"]& ]}], {}}, {
    GraphicsComplexBox[CompressedData["
1:eJxV1D9oE2EYx/FLNCqSvaUgJfini0Poako7asdKcKxRdCuujdCpGJ2zFAdT
Oqqz5YZSg0EcHCqUglgqRpSLFAx61Vqqsfc+v7vvS48Lxwcu7/2e932ft3Tr
3sydfBAE1eTnnrrOTGXPd3FlI66cxq/KxU656N28cC25T+HacCO5C/h61V3e
593rzZPYht84gb/WW1G95b06t53cedywD3jPu9ejHL5qgbwtTi3AZzuuAO8X
Nv5gMrPFrf7DV1y8+C/+YIEOscWNDvCsfdB78N9d+/iJe73+Gy9aPd6anz1s
cYsxfvrMXT+x6v2BLW6ljx/b977j95Z/Fw/Z/PTwZxWES5bnC75p9XXxZRev
8wlvacGw1n8Lf7P13vR57f23eMnyruP+A5cvxHqGa5lHLX/4MvMb/R9HGh//
0vfxrPLhrvLjcdWH76p+PKb5wT3NHz6n+cUfNf94WeuDN7V+eFrri59r/fFr
7Q98SfsHP9T+wivaf1g9/wff1v7FC9rfeEf7H0+oP/AN9Q8O1V+4qP5rZx5R
f2LVm8P31d/4kfq/fXx870jnB9Z6e1/U+YPV7wWs+r3T8w2n5x9Oz0ecPvER
Zq5o5g==
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 
          85}]},
        RowBox[{
          TagBox["y", HoldForm], "\[Equal]", "3"}]],
       Annotation[#, HoldForm[$CellContext`y] == 3, "Tooltip"]& ]}], {}}, {
    GraphicsComplexBox[CompressedData["
1:eJw9Vwk8lNsbNpaxJMxmJpFE1L1y21Qqzlsopdw20UaFpLq2FurPlSSuLGW9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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
          180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
          193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 
          206, 207}]},
        RowBox[{
          TagBox["x", HoldForm], "\[Equal]", 
          RowBox[{
            RowBox[{"-", "2"}], "+", 
            RowBox[{
              FractionBox["1", "2"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                 RowBox[{
                   RowBox[{"-", "3"}], "+", 
                   TagBox["y", HoldForm]}], ")"}], "2"]}]}]}]],
       Annotation[#, 
        HoldForm[$CellContext`x] == -2 + 
         Rational[1, 2] (-3 + HoldForm[$CellContext`y])^2, 
        "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJw9VwlcjNsbnmmZds3aDCItxJWELPnTeygVuVkSEeUWUigt6Ha5LVREWrRc
XV1ErhZLm6JyPku0uCqVSnuhvaY9bfNvNt9v5ndmvu+c877P+z7nfZ9P3d51
91EJEolUMvPlj8JLloCP3E+Fj9/inML6ry7uMkSE3fsnrVWvsPZ18iHLFAoB
ttnm1nk5OEJr68yHQlDIdhefH8nCf7tM/tElSyHuPQ08Z7I8Ez9o+sbMrZMi
LgvmxePoV97zpm5LEdZDa89amMfihfzbEVLE641t8k9vx+Dgy08u3jwvRYxW
+HmHWUTirIsxm9sNJAnmXKgo0boL2adqn52qlSAKztx28dmfBKZ6rmntWySI
kYFFV22/pkHVlgzH8nIyocP5z+1eVhZsEzhIJiQDzudtUscggEed+S/4QcA6
K3qcmyuJCAitkzCIeQPHE3cOVsmTiOmr5m26Vfkie9O4zDE1SiG5EJ5ZzPtg
MGcasysfan65WAy+HsfUeZET+HW2Z6/7oTKof8ZfMIENXdfdSIkqg6kBlm2Y
1QS2DFkfvzG7DF7e8o+x5I7jSEE8PoH81JTucMwYfkPfmNJaXQnCHIzhc9/O
PH+IP0PJ/nJVJfIofi9n9a1yczVkbXaQD6odxhP8ZaQvsEgQvyH8Q85t75+b
6+Cr51BkqMYgXu65eD9zYwOUjb7vL7YbwOGKMm8YXo2iePRjDefng09Km2BH
Q7K7visXd8ZKWsf92gz3+fm61YXrBDha4UiHp+8Gry6c4D+22+dCKzQI7nfh
Gp+7l9/7t0IjHpZKPtCFbRLV48yCW0Hhy86Auwu/41VhV0/mFH0DbYF/X3F2
ie6CNVHf4e/tJjK62c34SapdUGNGG6QX6QRTypswETc/cJTdDk/58TndiIW4
2qFZYK8W/1vpm1jp2wG9vJrRvVpV2IAue7HcpxOe7FlEa7AvwcZ3wp93r++G
NsH8YnzWdesOxotuiHc321C7rxBXNsvSE3u7IUyA7zV25e/6rAf8OvTr8lLi
8Y4ym/VK5/qE/CBl5yov3daqyeBC5Wi8UW1uGoxkrNyiEceFOZM3uY6vMRwM
c9v0TrofSoT2IF7fcKVfQz94M4u0hpQ/QWyRdU607QA4a3u/ix6qAYMkrbEb
7oNQKcQDgumJg2Darnbk3Lw6OLss7wP75SDICuw3AFkwDkG47NhJ84kWOPU0
favhimFQF8YTbJok2NnEMLDaM3MjG9uAWSsXczNpBCZ5/KsNkB7c35c5As5d
wbvyLNsh+/cX6uyyEagW5g9WhfPydKtHIe9Xyi+cu90wX32lhZzhGFQHvRsv
te4T8eQHOFbPZ6s+5ILqkmWRRo0/wEzIH9jVu/hc5P/GYXbq7/4BkQPgj7TU
fLZPgBDeANhI6Uqw/SbgSv2ScqfBAUhbtcmoOWICNIV8BauOruir5CngLPJ5
cVt7GDRrjqZqOE3BI+WQ4bsrRuCG4HxMg6f5iNf41lGwT6+q0znAg2kBvlFI
LMk69lyahDJMVPNV945Bud9fpurLSOjP4ynKIZVjIOQvCUn7N4we3PcDOn6U
pFtlktBJQd5/QN2B/ZmFfSS0wej86cad4xDxX/wJayMyMna4MLPDBLgI5pER
M0P6665NE+Bfb6ytXU1GX4TnGwZyDtRd+kFG3dxse6r2JHhEBn2Z9JRAgrQ1
TYp4JIkamU3qCqQpULb1OHR0riQSxm8KVkh1HR80lESphvqfg0ymQVhHpdDo
TZXwk77TcPjNLZejIVIoU1h/4JWj7ZlZCtLIYXjoPFeNB/aaPOU2W2lkrTan
y8iIB4LlEdLor1DOC1YQD0I1SNoyDAoqzU3RXH6HBw7uhgl1phQRfh7Q/ygy
+hBAQSN3+R7wIEtgh4LOVF+ysOjjgYH/0apEKxm0drQqc9M4D2oqOM+upcmg
y3x68Hgifsiisyxuj1U/DxQM5qeZxcmiN1vaN9BaebBH/3HP9k5ZxE9n6kue
KB9yaKXjxvyrgTwYX7H2mFKvHFoytOOr92YexJy9fTXcSR7xpxsyeaL4y//E
bzh3OC5kXB4Fdd8JDd8/DfPVIlti/1EQxps0LYq34s/4flLIK1XIU0R56hZj
+0sn4ZedD63G5ZSQ0ww9hv0mRfFW+plPrQuRDoGSs1CSFTPGX24CNqEd/eqm
sxAfrlrsOAj71Kyf/Dm9HO80pyojm3XxXdJqP+DEoHlUiJMy4nQZOVwwGxP1
DWUk5qvuE5PY4CllFOZ1LXa+1ygkyP3+W/ICKur+3evCOH0UGs7eZjgaUIV4
xkaEeBAVhQn8HIE/TLSK7ztS0R7FhMcmEiMwi9DvyzxHRfZ8uoYMi/yjivAM
g5L19GD7X1RUGh/sldw9BO+claV0M6hIfP7aDidLBOdTkXMVJzH/0yAU7nRS
k++join9Q9fDDw5Cut73yVMUGhKfZ+9t+4L+p0ZD1Sktrr7pAzD3xmyPFm0a
usOnj+OAMF9raIgakZL4NrQf9td27JplR0PieiGV79eC3GjoBNszd7ETFxJg
tsaiKBoKF+DjwpHre4ffxtIQ3WvpkivNffDuxMlwsyQayhDY7wXL1WfbgogZ
ewJC9YjiS0ON0m7/Fqh1wxVFVaWyyRn/RPXteEvrSxt5Our4hVtqjDvg7RnZ
f7YtpyOf7s+d6+M74GH66GDkCjoS10vdgGkth110tHXTx9XuVm0AKSrO0ofp
aID/GH8T1mNfOhLX376VD87Pi6YjrktlRVVBK/BPc34CHeV7yc57e6YFDHJe
7DPAdGQiwN8Melo2xh6f6SgtoUZukV0dfPMoqutTYiBxP3BnURULVRjIciC9
gJCuhQZth7XlcxjoiCC9NaLzxkDzBfYrYBkrdc/b3QwU3pPjOtZXCtMKVuQe
NwYS96Nk29WJoSEM5L/QVG/ybg5MKGwf6HzPQCnNCZPDe3Ig8gxVKayAgbgC
AuUI620hA4n7X1JW3cdr0wzk8ejCA05LMq7Y6B1OncNEkdvuBwTSinHBluMx
R5yYSNxvk4/Jl6c6M1GNzxc741vF2C1uncHlE0ykZ2vxqnjJB5GeYCJxP18l
Y/e9qZiJaK8eRON7Tbgrdc499XEm0ty9o2mNUzPW3bLezFmahcT6wZxx1Cle
h4Uy8/75rTT3O44MMKa3WLBQmk2PnbtRJ95XdD26908WEusTtqrKipLrLOTu
0X+HzuzGjMWP1yXFsNBTS667vG2vqP+zEGVtkKVpDhc/rC+7sq+BhcT6KNCz
wd6sjYV0ajKqaF/6sdSIjlHX+Iw/19XJOacHcSh/0FRBYv3lRrQqy2xQQTY9
DiX12iPYxb4f2h1VUM8pH1qE7wg2KAx9t+a0ChLru4OKHbn5YSqoQCe3YMX3
MbzO9fmeR4kq6D25sOsEfQLP3qDx/U29ChLrSVPrXqdL31SQ/knm64D7E5h8
3s/JvUsFqQh4OYmF+7LR4qxL1keOT2OvS4cvai5lI7F+LTc0o1SsYiPV8om0
A1E8LLPoWkP2FjZSGOM1OcSQiFSPuR9bnNhIrJdx6LGocn82WpA7I8hayYQ5
//59NuKts/P9NE4mQrTrj3s+ZCPHpYOVC2UliKqB2MTHSWJ7EsQCLcnOm0Vs
JFVvapT6myQxt2y03e0rG3UHX61o3CBFdLKMo1lyHCTW/5W6c58cZHOQnJ8e
JaxAikj0pju5LuCg9f/yBZs0IdTLHLQ6UOfjRT0KceBv24VxNhwkfv94pXGw
fcSWgx5XPpKcdKEQTol7tAOPclCM2qQjEStDtCpuN2ZGcZD4/ebN9ZWLtRI4
6P8Tzjbu
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
          180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
          193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 
          206, 207}]},
        RowBox[{
          TagBox["x", HoldForm], "\[Equal]", 
          RowBox[{"2", "-", 
            RowBox[{
              FractionBox["1", "2"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                 RowBox[{
                   RowBox[{"-", "3"}], "+", 
                   TagBox["y", HoldForm]}], ")"}], "2"]}]}]}]],
       Annotation[#, HoldForm[$CellContext`x] == 
        2 + Rational[-1, 2] (-3 + HoldForm[$CellContext`y])^2, 
        "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJw1Vgs0VWkU5uLc65Fc17vymChJJXoYM/XvMqPQWCXNKqXBDLXKoxrEUs2a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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143}]},
        RowBox[{
          RowBox[{
            SuperscriptBox[
             TagBox["x", HoldForm], "2"], "-", 
            FractionBox[
             SuperscriptBox[
              TagBox["y", HoldForm], "2"], "4"]}], "\[Equal]", 
          RowBox[{"-", "2"}]}]],
       Annotation[#, 
        HoldForm[$CellContext`x]^2 + 
         Rational[-1, 4] HoldForm[$CellContext`y]^2 == -2, 
        "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxdVns41FkfH4Ncy++XSnRBSUusy/Z0sW++Z0teIu9WbElp16bbvlGiZ3va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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
          180, 181, 182, 183, 184, 185, 186, 187, 188}]},
        RowBox[{
          RowBox[{
            SuperscriptBox[
             TagBox["x", HoldForm], "2"], "+", 
            SuperscriptBox[
             RowBox[{"(", 
               RowBox[{
                 RowBox[{"-", "3"}], "+", 
                 TagBox["y", HoldForm]}], ")"}], "2"]}], "\[Equal]", "2"}]],
       Annotation[#, 
        HoldForm[$CellContext`x]^2 + (-3 + HoldForm[$CellContext`y])^2 == 2, 
        "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxd0rtKA0EUxvFcRBBFIipe8ApRH8OUJsZGEKwFC5F1g76EYOUmKW3sbVdj
k1cQCxGSKCKWoqCNIEZ3DvkG/wPL4bfM7s75zi7uhJu7mVQqtfV3JdXWdsPq
e7Pn726y3uTDVhy04hf5AN6Dm0Fy406O4Qv4Jl+M8sVz+RguwCfOt6s91+Az
+N4d4Fluw0/wvuvnVQ7hI9jF1f2Q065+yll4LUoO+CWX4DJ86vr5katwHXbx
xunC/3l5h7C9v0+O4Cps8+yXL+Er2H0uGJDbcAe2PAdlq0NyGnbHi4blJXgZ
tv057M9hv7f1N4L+vBuwezw/KpfgddjyGUM+3h3Y5jkuh3AFtrwm5AychW3e
k3INrsOW3xTy816BLb9p5Od9DVteM3IZ3oAtr1n5AX6ELc855Oldge3/nJet
LhR+AcXVilo=
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 
          85}]},
        RowBox[{
          TagBox["x", HoldForm], "\[Equal]", "0"}]],
       Annotation[#, HoldForm[$CellContext`x] == 0, "Tooltip"]& ]}], {}}, {
    GraphicsComplexBox[CompressedData["
1:eJw1VU1MVFcUfjMMMwLyN8wwbEwkYjUaV40b2+Z8dmEKSRPtQroxiAnaDWIX
dCOLGm0XaFJjbRPtRjeNG4MxSl1Y7k0TaEwXJgbUOGIp/o/WOojy69B53znv
5pHzwrv3fOd85/vutO7r+6InHgRBX/kvjLpWQWMLtn4YrhTOnglXDhd788O9
+SRuD4cvOZxqay8/SbTzJQc3vXlkenMSe4vZrmI2hwTzJKG5c7avEuv50ox1
jAnL04zx7WvKTwKFc3XlpxkPiFOBvhB2OIsu5q3ApfnBofnBLPg5Hwc/92bt
XBzf7Ez170xlcYAfYrjCfRl8RqAYCHcqg37ui2HbhaPlJ4Nr3BfgPvNljIfA
Ygaf8/yK/BiGG024yv0lYRhuQo4FvpexzoHRzoEmbCLOsnTwXBO2jIQELcnx
obCBNO4RZ0m0j7TxtSixMHybxqchHeMLsisssz+NT5hnQX5gA2mUVsI1J1pf
Gl+GsKNz0sw6Go2/OdG+GqF1vhXlq9H4nxWdSyOOkog3cj6ksdCA08SZEZ1X
AyiDM0U5sD9cDcZnUXR+DTaf/0TrqMceAv0rd4hXj7uML6zfOgySh4JQNiN1
hlcwvDrj94nxW2v6eWx4tWjlPx6J1lGLKeaZFspjaDVIz8rfxs9qtFBgk6J9
1mBCCzE+anCQLxOisRpfUx8TQjrOVWOAuLfkJGM1bvLcX1ZfFX4iPzdEeaqC
54cxUT1VQed2WVR/kc+uXdc6U2hjfRcdaRlMgTpr/8P9Zr7bS17/dKrXJJ4q
vot8eI/+GXej1F8lrvPcbRf57h/t17WZ745w433HNvsTOMQ+Ji1fwuYx7fLm
Q63zodO6K7BB+XeRD7+iLp44hv1x7GCi5+6g+fAj1l1wlElXzPT5wkW+VF5f
OeUrQD15f+XYdmdg/njtlrUQ81XR8Esyw7xFp/OKfFl0ymPJ5vDG+l+WD1T/
LvKh+vat8btoOn3nOsx3eu/MGV/zovfavIt8qPfkgvX/Tn4h0KLrMd9NKo6L
fHeMQEvW36xoW0uO/g9mTYfvbR4zppuS8VM0X5dc5EP13Ypj+dte2/7A95kP
1deBP0y8l8ZfzEe+VJ3FvPLyzO6RmP+V+Z7Jz0wY9xfMl4of92vNhyco3Li/
RR0+snulwmu9D82HCR/5Un2eMPy86H1c6Xezjzs2v0p/2nyn93vSd1NAN+0e
SPop86HePym/jj763ead8ifNd/b75qe+6275vnvjx/8DheI7nw==
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111}]},
        RowBox[{
          TagBox["y", HoldForm], "\[Equal]", 
          RowBox[{"3", "+", 
            TagBox["x", HoldForm]}]}]],
       Annotation[#, HoldForm[$CellContext`y] == 3 + HoldForm[$CellContext`x],
         "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJw1VU1slFUUnb9+U0qZTqedTjcsGkQhXbAwJKaS3NOFBsRFZWFNXNQKWhNS
MEZYGExIEBawUdQEYVM3hmighITKQnkvxmIIC6K2YKw1pTRQht8pPzPTlql9
515fZvK+zPfuueece++bjnd3b3svEYvFBpa/YddV73Vvx8YXw0r749+EVcCp
wYmRwYnIXx0JDwUcfW7L8ifyW/hQgJ/uvDDdGfl3Svm+Ur6AFHEir9gFbOW5
Or+WAW3QPeUVpw3j3avHulen/J2hTHEo04Z/mSfpd4e0I3n0Ezfpz1QOD1cO
53GefBL+H57L4y7jEn5vT3pPTzqPnYyL+3M814rXmChu+VstPmbxrYircK/7
/+9rbhdxWtDeFwg8cxd794327mvBeuIsOsVtwYYLwYAFd2Q4EMxhkrgL7kfi
5MyPeUf8/Tm8EuSOVd0bge6eHF4lTtV9QT9yUN8qTmnl8HZIO1p2beTRjOvE
Lzvl2Qz16YlTPc14nvweG79mHOw6eaDr5CP3bbCpmMXXzDPn1I8sTrDOJTfw
flhZ86vktD5ZbKf/D9xb5NEEph2557gNNlm97hifjPVH0fAz5udN83MVXuDv
M8ZvFWY6aaCrhvION0J1T5n+RnQEu7on3WfUsdL0T5jelfiIuOOG34BP2Afj
rinIHWrAMfL5w33JvQG3GHfZzq/Ad9R/yWm/r8Ao4S8a/vJ7xp116mu98Tv/
k/ZLPcp/Bn6nRPszDa3jL6L1j9BD336TlwP9AxGuaH5RPhF+Z/+PifZXHYYY
d1Ve17nBuOoVmxso70lRn1P4nPu0KN8kOtRfsTnBDtb1pmh9E9jMwNuiOHG8
RF5FmQtl7ovjL62n2NwY/n3Dj6GRvt6XT4Os3hgWl8J6IDZHhl+y/DV5SNyS
ZBlXE+2fkumvifbRI9O3KGu0f8XmSH6lL09kE3nOi9rx1PhV5TR9L8s2zlNF
auRTFpsjOca6VuUD6n8qqmdePtS5kb8tj82NMHxpwfQ8Nr7PjO+cnDNdW03n
m6zvknwf6HU9FB47GrO5vCe8noox7Kdfd2Wz+TplPmufxG1uZ0XtiuMH4s0a
3wS8zpHpT2Cd1ZljU0ngGvtoRvReTkLrdcP0JO0emjJ/U5i1vvqY81KHPuq4
Zn1Rh690boRly0QY4D1wxfouMv6XhXTzaazhnP5sfZK2vjkr9v+CqYP97Yf6
1236D00S8BY=
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103}]},
        RowBox[{
          TagBox["y", HoldForm], "\[Equal]", 
          RowBox[{"3", "-", 
            TagBox["x", HoldForm]}]}]],
       Annotation[#, HoldForm[$CellContext`y] == 3 - HoldForm[$CellContext`x],
         "Tooltip"]& ]}], {}}},
  PlotStyle -> All,
  AspectRatio->1,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "GridLinesInFront" -> 
    True},
  PlotInteractivity:>True,
  PlotRange->{{-3, 3}, {-1, 8}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.96747538094871*^9, 3.967475427944517*^9}, 
   3.9674755249178*^9, 3.967475556513674*^9, 3.9674756078194427`*^9, 
   3.967475659450901*^9, {3.967475732957674*^9, 3.967475762215914*^9}, 
   3.967476728811049*^9, 3.967476840259782*^9, {3.967476940482931*^9, 
   3.9674769826720047`*^9}, {3.9674770767146873`*^9, 3.9674770966202993`*^9}},
 
 CellLabel->"Out[8]=",ExpressionUUID->"484cecab-3087-4743-8a7d-3ad1f9beabe0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"solid\"", ",", "\"black\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dashed\"", ",", "\"purple\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dotted\"", ",", "\"orange\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dotted\"", ",", "\"purple\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dashed\"", ",", "\"magenta\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dashed\"", ",", "\"yellow\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thin\"", ",", "\"green\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thick\"", ",", "\"blue\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dotted\"", ",", "\"magenta\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thick\"", ",", "\"blue\""}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "False"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"$P1: y=x^2$\"", ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"-", "2"}], ",", "4"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"$P2: y=-x^2+6$\"", ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "4"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"Intersecci\[OAcute]n\"", ",", 
             RowBox[{"{", 
               RowBox[{"0", ",", "3"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"$(-\\\\sqrt{3},3)$\"", ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"-", "1.7`"}], ",", "3.3`"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"$(\\\\sqrt{3},3)$\"", ",", 
             RowBox[{"{", 
               RowBox[{"1.7`", ",", "3.3`"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"Hip\[EAcute]rbola\"", ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "6"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"$r=\\\\sqrt{2}$\"", ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "1.5`"}], "}"}]}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", 
     RowBox[{"-", "3.5`"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "3.5`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", 
     RowBox[{"-", "1.5`"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "8.5`"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{{3.96747538094871*^9, 3.967475427944517*^9}, 
   3.9674755249178*^9, 3.967475556513674*^9, 3.9674756078194427`*^9, 
   3.967475659450901*^9, {3.967475732957674*^9, 3.967475762215914*^9}, 
   3.967476728811049*^9, 3.967476840259782*^9, {3.967476940482931*^9, 
   3.9674769826720047`*^9}, {3.9674770767146873`*^9, 3.967477096622706*^9}},
 CellLabel->"Out[11]=",ExpressionUUID->"334445b5-c1dc-491c-b767-344ec5f47441"],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/conicas9/conicas9.\
tex\"\>"], "Output",
 CellChangeTimes->{{3.96747538094871*^9, 3.967475427944517*^9}, 
   3.9674755249178*^9, 3.967475556513674*^9, 3.9674756078194427`*^9, 
   3.967475659450901*^9, {3.967475732957674*^9, 3.967475762215914*^9}, 
   3.967476728811049*^9, 3.967476840259782*^9, {3.967476940482931*^9, 
   3.9674769826720047`*^9}, {3.9674770767146873`*^9, 3.967477097040097*^9}},
 CellLabel->"Out[12]=",ExpressionUUID->"6f69854b-0f2c-424e-87e5-12a3a92827df"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967475380950388*^9, 3.967475427945208*^9}, 
   3.9674755249185457`*^9, 3.967475556514392*^9, 3.967475607820179*^9, 
   3.967475659451625*^9, {3.967475732958233*^9, 3.9674757622164803`*^9}, 
   3.9674767292387877`*^9, 3.967476840725172*^9, {3.967476940919159*^9, 
   3.967476983112259*^9}, {3.967477077171197*^9, 3.967477097040883*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"10b879af-50ba-4abe-8068-f8d579d6790c"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.967475380950388*^9, 3.967475427945208*^9}, 
   3.9674755249185457`*^9, 3.967475556514392*^9, 3.967475607820179*^9, 
   3.967475659451625*^9, {3.967475732958233*^9, 3.9674757622164803`*^9}, 
   3.9674767292387877`*^9, 3.967476840725172*^9, {3.967476940919159*^9, 
   3.967476983112259*^9}, {3.967477077171197*^9, 3.9674770970413113`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"1f086a6f-d397-4166-b3bb-d6586fa5d324"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967475380950388*^9, 3.967475427945208*^9}, 
   3.9674755249185457`*^9, 3.967475556514392*^9, 3.967475607820179*^9, 
   3.967475659451625*^9, {3.967475732958233*^9, 3.9674757622164803`*^9}, 
   3.9674767292387877`*^9, 3.967476840725172*^9, {3.967476940919159*^9, 
   3.967476983112259*^9}, {3.967477077171197*^9, 3.967477097041812*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"511f5c2b-309a-4892-9728-0ec62927f96d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967475380950388*^9, 3.967475427945208*^9}, 
   3.9674755249185457`*^9, 3.967475556514392*^9, 3.967475607820179*^9, 
   3.967475659451625*^9, {3.967475732958233*^9, 3.9674757622164803`*^9}, 
   3.9674767292387877`*^9, 3.967476840725172*^9, {3.967476940919159*^9, 
   3.967476983112259*^9}, {3.967477077171197*^9, 3.9674770970421247`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"85f56940-4d96-4fa8-9ab1-45f8abc23a96"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967475380950388*^9, 3.967475427945208*^9}, 
   3.9674755249185457`*^9, 3.967475556514392*^9, 3.967475607820179*^9, 
   3.967475659451625*^9, {3.967475732958233*^9, 3.9674757622164803`*^9}, 
   3.9674767292387877`*^9, 3.967476840725172*^9, {3.967476940919159*^9, 
   3.967476983112259*^9}, {3.967477077171197*^9, 3.967477097042448*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"e8c8087f-5a17-4e95-bc24-1376c64a5940"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.967475380950388*^9, 3.967475427945208*^9}, 
   3.9674755249185457`*^9, 3.967475556514392*^9, 3.967475607820179*^9, 
   3.967475659451625*^9, {3.967475732958233*^9, 3.9674757622164803`*^9}, 
   3.9674767292387877`*^9, 3.967476840725172*^9, {3.967476940919159*^9, 
   3.967476983112259*^9}, {3.967477077171197*^9, 3.967477097108058*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"a7e22ac9-338d-45da-82d0-0cbeb0b152b1"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.967475380950388*^9, 3.967475427945208*^9}, 
   3.9674755249185457`*^9, 3.967475556514392*^9, 3.967475607820179*^9, 
   3.967475659451625*^9, {3.967475732958233*^9, 3.9674757622164803`*^9}, 
   3.9674767292387877`*^9, 3.967476840725172*^9, {3.967476940919159*^9, 
   3.967476983112259*^9}, {3.967477077171197*^9, 3.9674770981132097`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"69b9e151-c655-4da0-b538-39c9fe1fac5a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", "\<\"/Users/enriquevilchezquesada/Downloads/conicas9/\
\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/conicas9/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967475380950388*^9, 3.967475427945208*^9}, 
   3.9674755249185457`*^9, 3.967475556514392*^9, 3.967475607820179*^9, 
   3.967475659451625*^9, {3.967475732958233*^9, 3.9674757622164803`*^9}, 
   3.9674767292387877`*^9, 3.967476840725172*^9, {3.967476940919159*^9, 
   3.967476983112259*^9}, {3.967477077171197*^9, 3.967477098114935*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"93a74f7a-8a5e-488f-bd49-c9ebce28794d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"conicas9\"\>"}],
  SequenceForm["Archivo: ", "conicas9"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967475380950388*^9, 3.967475427945208*^9}, 
   3.9674755249185457`*^9, 3.967475556514392*^9, 3.967475607820179*^9, 
   3.967475659451625*^9, {3.967475732958233*^9, 3.9674757622164803`*^9}, 
   3.9674767292387877`*^9, 3.967476840725172*^9, {3.967476940919159*^9, 
   3.967476983112259*^9}, {3.967477077171197*^9, 3.967477098115963*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"a59766f1-0721-4b68-87bd-df886d68b5fb"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.967475380950388*^9, 3.967475427945208*^9}, 
   3.9674755249185457`*^9, 3.967475556514392*^9, 3.967475607820179*^9, 
   3.967475659451625*^9, {3.967475732958233*^9, 3.9674757622164803`*^9}, 
   3.9674767292387877`*^9, 3.967476840725172*^9, {3.967476940919159*^9, 
   3.967476983112259*^9}, {3.967477077171197*^9, 3.9674770989390383`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"09b5612f-503b-401a-a1f3-7c1bcb235960"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/conicas9/conicas9.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/conicas9/conicas9.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967475380950388*^9, 3.967475427945208*^9}, 
   3.9674755249185457`*^9, 3.967475556514392*^9, 3.967475607820179*^9, 
   3.967475659451625*^9, {3.967475732958233*^9, 3.9674757622164803`*^9}, 
   3.9674767292387877`*^9, 3.967476840725172*^9, {3.967476940919159*^9, 
   3.967476983112259*^9}, {3.967477077171197*^9, 3.967477098939753*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"bcdee2b1-4a41-41a2-a470-16fea4587d35"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/conicas9/conicas9.\
pdf\"\>"], "Output",
 CellChangeTimes->{{3.96747538094871*^9, 3.967475427944517*^9}, 
   3.9674755249178*^9, 3.967475556513674*^9, 3.9674756078194427`*^9, 
   3.967475659450901*^9, {3.967475732957674*^9, 3.967475762215914*^9}, 
   3.967476728811049*^9, 3.967476840259782*^9, {3.967476940482931*^9, 
   3.9674769826720047`*^9}, {3.9674770767146873`*^9, 3.967477098951556*^9}},
 CellLabel->"Out[13]=",ExpressionUUID->"ccd4c2f1-a575-456c-876b-545d0e6b16f8"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1448, 688},
WindowMargins->{{Automatic, 50}, {21, Automatic}},
FrontEndVersion->"14.3 para Mac OS X ARM (64-bit) (July 8, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"5420f22d-720b-4572-84cb-8f050efca9fa"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[576, 22, 197, 3, 58, "Input",ExpressionUUID->"2521efcf-6906-4eba-ab97-75ec86b9ce05"],
Cell[CellGroupData[{
Cell[798, 29, 1102, 32, 86, "Print",ExpressionUUID->"93a74172-ff0a-48c5-b889-5556b227b091"],
Cell[1903, 63, 322, 5, 46, "Print",ExpressionUUID->"674b7854-cd88-4875-8e65-81260c318344"],
Cell[2228, 70, 320, 5, 46, "Print",ExpressionUUID->"d2ffd7ff-6ed8-42c2-acbf-1d7f845e9200"],
Cell[2551, 77, 563, 11, 46, "Print",ExpressionUUID->"9989d339-677b-4438-9527-3262e2c09fbf"],
Cell[3117, 90, 600, 12, 46, "Print",ExpressionUUID->"ce11a873-a43b-4e74-9987-a0a2f62df38a"],
Cell[3720, 104, 567, 11, 46, "Print",ExpressionUUID->"ceb58b47-ddcd-4420-b386-a6b3509d912a"],
Cell[4290, 117, 565, 11, 46, "Print",ExpressionUUID->"3a96b8f0-c93a-4caf-bc95-05324fe8da0c"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4904, 134, 432, 6, 136, "Subtitle",ExpressionUUID->"e620c90a-a47e-4279-8a06-c63909917048"],
Cell[CellGroupData[{
Cell[5361, 144, 206, 3, 58, "Input",ExpressionUUID->"619f226d-8d73-41d4-8fcf-41bf318723dc"],
Cell[5570, 149, 131925, 2580, 5351, "Output",ExpressionUUID->"5bf1ce74-a78b-4b02-a18f-9b0bc8c1b001"]
}, Open  ]],
Cell[CellGroupData[{
Cell[137532, 2734, 407, 6, 106, "Subsection",ExpressionUUID->"4990730b-335b-4741-81a6-e9c19d533e3a"],
Cell[CellGroupData[{
Cell[137964, 2744, 6373, 170, 1124, "Input",ExpressionUUID->"28fa47aa-4e40-421c-8947-d4387ce41d48"],
Cell[144340, 2916, 11447, 211, 752, "Output",ExpressionUUID->"e7198d52-6165-4505-a9f0-45f4b2866fa7"],
Cell[155790, 3129, 2294, 55, 148, "Output",ExpressionUUID->"43160be4-e4f2-4fbb-9955-e92eca9b7663"],
Cell[158087, 3186, 1009, 14, 66, "Output",ExpressionUUID->"68f42fb0-fa1d-4d00-82e1-5d48188af0b7"],
Cell[CellGroupData[{
Cell[159121, 3204, 1201, 20, 46, "Print",ExpressionUUID->"ef34e438-c250-43eb-9e15-5449a0ba788e"],
Cell[160325, 3226, 992, 15, 46, "Print",ExpressionUUID->"44b7f74e-7a1d-4f9c-9971-b2499e40f821"],
Cell[161320, 3243, 1186, 20, 46, "Print",ExpressionUUID->"7de0f30b-c64e-4f5c-a162-078a8d3251b3"],
Cell[162509, 3265, 1211, 20, 46, "Print",ExpressionUUID->"409e353c-822e-479c-accd-c5ab3316dd72"],
Cell[163723, 3287, 1191, 21, 46, "Print",ExpressionUUID->"6bd20ff4-eeea-4946-a6b5-5cac51c07fda"],
Cell[164917, 3310, 1002, 15, 46, "Print",ExpressionUUID->"83b8b8c1-b9e1-44ea-ab19-a0e24bf9b7cf"],
Cell[165922, 3327, 1003, 15, 46, "Print",ExpressionUUID->"b767709a-5fd4-4663-905d-2d1d9318a4ba"],
Cell[166928, 3344, 1237, 23, 46, "Print",ExpressionUUID->"fe2a596b-b35b-4315-9033-f21ebe3fef42"],
Cell[168168, 3369, 1116, 19, 46, "Print",ExpressionUUID->"b085ad53-a87b-4b37-91d4-3b50c535e068"],
Cell[169287, 3390, 999, 15, 46, "Print",ExpressionUUID->"3d53ca21-8226-4b70-88b3-c92767c8f51d"],
Cell[170289, 3407, 1243, 23, 46, "Print",ExpressionUUID->"ada8e69e-73ee-42ec-b80d-4a93aef8edb2"]
}, Open  ]],
Cell[171547, 3433, 1007, 14, 66, "Output",ExpressionUUID->"e4513195-118d-4b7e-b869-2e49213bbd8a"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[172603, 3453, 294, 4, 106, "Subsection",ExpressionUUID->"8c5757b8-938d-4bd1-8719-806bd88b112c"],
Cell[CellGroupData[{
Cell[172922, 3461, 6960, 190, 1124, "Input",ExpressionUUID->"2c5e1a65-a617-42ba-9dd0-9ebf0034f058"],
Cell[179885, 3653, 10473, 200, 752, "Output",ExpressionUUID->"74052746-f2af-41a7-af22-47459e8f6a11"],
Cell[190361, 3855, 1971, 51, 189, "Output",ExpressionUUID->"ce903e4e-80d4-4946-abb0-456d9be6ae9d"],
Cell[192335, 3908, 594, 8, 66, "Output",ExpressionUUID->"d29059e2-c5c0-402f-af67-209b4e272daf"],
Cell[CellGroupData[{
Cell[192954, 3920, 795, 14, 46, "Print",ExpressionUUID->"2bea6f08-f38b-468d-8d29-dea7a6bae665"],
Cell[193752, 3936, 583, 9, 46, "Print",ExpressionUUID->"a0a6e61f-240e-49be-971a-e23e0b0f665a"],
Cell[194338, 3947, 776, 14, 46, "Print",ExpressionUUID->"36d5b940-e81c-4753-890e-6eb35aeb014a"],
Cell[195117, 3963, 803, 14, 46, "Print",ExpressionUUID->"dcd985a1-f29b-4445-85ee-333ae8b03da6"],
Cell[195923, 3979, 785, 15, 46, "Print",ExpressionUUID->"f81c2345-dc09-40d6-87e0-e6bd8a8ec205"],
Cell[196711, 3996, 592, 9, 46, "Print",ExpressionUUID->"8bff247f-b5f0-4499-9fcd-cac33cbc45ea"],
Cell[197306, 4007, 593, 9, 46, "Print",ExpressionUUID->"b7013c65-66a9-4a99-a88e-e62fcc550fb1"],
Cell[197902, 4018, 829, 17, 46, "Print",ExpressionUUID->"321c049d-e00a-4a07-88d1-b79547950188"],
Cell[198734, 4037, 710, 13, 46, "Print",ExpressionUUID->"d4595632-c044-4db3-8a5e-80b9b2903d89"],
Cell[199447, 4052, 591, 9, 46, "Print",ExpressionUUID->"8e564270-aa15-49d4-a2bf-7c4b9bacda5f"],
Cell[200041, 4063, 835, 17, 46, "Print",ExpressionUUID->"b432258b-2c8e-4eae-9b13-74903f587bca"]
}, Open  ]],
Cell[200891, 4083, 592, 8, 66, "Output",ExpressionUUID->"0c0f8126-bcbe-4c4d-8d09-de67dcbe3068"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[201532, 4097, 424, 8, 106, "Subsection",ExpressionUUID->"65225bfa-9f11-4710-acdb-963434bfb5c4"],
Cell[CellGroupData[{
Cell[201981, 4109, 7637, 219, 1317, "Input",ExpressionUUID->"8e74580e-5ec6-49ce-9307-d62aa579270d"],
Cell[209621, 4330, 14929, 271, 752, "Output",ExpressionUUID->"2b31bc84-a66b-49fd-995e-604020cbf62d"],
Cell[224553, 4603, 2357, 61, 265, "Output",ExpressionUUID->"294b37a1-2c8f-43e3-bfa4-732e68e00c8d"],
Cell[226913, 4666, 632, 9, 66, "Output",ExpressionUUID->"7def601c-e352-4026-98d4-9ab44bb7e5aa"],
Cell[CellGroupData[{
Cell[227570, 4679, 842, 15, 46, "Print",ExpressionUUID->"0e60d4b9-44ab-4809-beb8-c251d2a04d16"],
Cell[228415, 4696, 635, 10, 46, "Print",ExpressionUUID->"0cb3de6c-3ab8-4b38-8e3b-50ecc3adcc65"],
Cell[229053, 4708, 827, 15, 46, "Print",ExpressionUUID->"4602118c-b331-47ef-b070-a956f6798bef"],
Cell[229883, 4725, 852, 15, 46, "Print",ExpressionUUID->"f3f33398-2792-47b6-bce8-5e836a2af7a7"],
Cell[230738, 4742, 832, 16, 46, "Print",ExpressionUUID->"e92eff27-ecfe-4201-985c-dfb7d8282965"],
Cell[231573, 4760, 641, 10, 46, "Print",ExpressionUUID->"ba206f11-e5bc-49b7-a39d-6606a86d31a7"],
Cell[232217, 4772, 641, 10, 46, "Print",ExpressionUUID->"b5428cd8-1e1c-41a1-a65d-6c5aef71eefb"],
Cell[232861, 4784, 880, 18, 46, "Print",ExpressionUUID->"f9b6a3ad-3495-4068-831f-0889b9ba5c9e"],
Cell[233744, 4804, 757, 14, 46, "Print",ExpressionUUID->"a23bd536-2a13-4a08-af9c-37de8583b67b"],
Cell[234504, 4820, 640, 10, 46, "Print",ExpressionUUID->"b015cd9d-4241-4b0d-8ca4-f3e261e89b63"],
Cell[235147, 4832, 884, 18, 46, "Print",ExpressionUUID->"05776720-27da-4849-9fbe-89b9024ced4e"]
}, Open  ]],
Cell[236046, 4853, 634, 9, 66, "Output",ExpressionUUID->"a3be0705-2fc7-44e5-8c81-495897ea2875"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[236729, 4868, 256, 4, 106, "Subsection",ExpressionUUID->"899facfd-3bb8-4347-8c96-cacd304db116"],
Cell[CellGroupData[{
Cell[237010, 4876, 7509, 207, 1276, "Input",ExpressionUUID->"b010f8d4-e000-4621-be90-3bd298132c1b"],
Cell[244522, 5085, 19143, 344, 752, "Output",ExpressionUUID->"891a55a7-a7a7-466a-9efd-9ad2021d1df7"],
Cell[263668, 5431, 1956, 53, 265, "Output",ExpressionUUID->"79aab704-1cd1-4f46-b4e2-4260d32cd368"],
Cell[265627, 5486, 412, 6, 66, "Output",ExpressionUUID->"9c69ecbe-0e01-4dc8-9f6f-cb412701fb33"],
Cell[CellGroupData[{
Cell[266064, 5496, 617, 12, 46, "Print",ExpressionUUID->"bbb65395-3394-4a3b-af81-a2575d7a8b67"],
Cell[266684, 5510, 408, 7, 46, "Print",ExpressionUUID->"d11af9d5-ef57-45b4-8571-ca1f1cc07e94"],
Cell[267095, 5519, 600, 12, 46, "Print",ExpressionUUID->"0acf16c0-6afb-4e3c-b5a8-caeb77a4bf22"],
Cell[267698, 5533, 629, 12, 46, "Print",ExpressionUUID->"6f8086ec-ce44-4767-b8a2-2b011c44a6e3"],
Cell[268330, 5547, 609, 13, 46, "Print",ExpressionUUID->"cb002607-3004-4e22-a287-9f896cc5da97"],
Cell[268942, 5562, 416, 7, 46, "Print",ExpressionUUID->"e368719d-b635-4db1-82ab-59292b895292"],
Cell[269361, 5571, 417, 7, 46, "Print",ExpressionUUID->"0f3f93f6-3912-486b-9624-8ec27d08facb"],
Cell[269781, 5580, 653, 15, 46, "Print",ExpressionUUID->"b7990e1c-0874-4634-a198-f026a9e310c3"],
Cell[270437, 5597, 532, 11, 46, "Print",ExpressionUUID->"acd7775c-98b4-4f4d-8a8d-76058dd8f9ff"],
Cell[270972, 5610, 415, 7, 46, "Print",ExpressionUUID->"2e7e49b0-c82c-44fa-85df-c1961a55c1c4"],
Cell[271390, 5619, 657, 15, 46, "Print",ExpressionUUID->"1f2c75f6-a28b-4ff7-98f5-e326a9c0c885"]
}, Open  ]],
Cell[272062, 5637, 413, 6, 66, "Output",ExpressionUUID->"b185fedb-6e4e-4b92-afc5-3d0369f47b0f"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[272524, 5649, 410, 6, 106, "Subsection",ExpressionUUID->"aa294ed9-0072-424d-8b67-43d0ff09ece9"],
Cell[CellGroupData[{
Cell[272959, 5659, 8079, 240, 1459, "Input",ExpressionUUID->"829104e8-6ca1-4dc5-b23e-472255228763"],
Cell[281041, 5901, 21751, 389, 752, "Output",ExpressionUUID->"399a88ea-3380-480b-82f5-35258158c9f7"],
Cell[302795, 6292, 2105, 57, 209, "Output",ExpressionUUID->"5eefa6f5-26bc-4e0e-a755-5370bb506772"],
Cell[304903, 6351, 337, 5, 66, "Output",ExpressionUUID->"43b46bf7-ed91-4849-81c9-e5c44950f35f"],
Cell[CellGroupData[{
Cell[305265, 6360, 520, 11, 46, "Print",ExpressionUUID->"4e8b17bd-1954-47cc-b2fb-4f5891bb5fd2"],
Cell[305788, 6373, 312, 6, 46, "Print",ExpressionUUID->"3b414e80-95e1-4cf2-b0bc-15583678fd90"],
Cell[306103, 6381, 506, 11, 46, "Print",ExpressionUUID->"637c55a9-b35d-4b7d-ad5c-c2de1c344811"],
Cell[306612, 6394, 531, 11, 46, "Print",ExpressionUUID->"7ca49824-75cd-4ba8-8989-a29538e0160d"],
Cell[307146, 6407, 511, 12, 46, "Print",ExpressionUUID->"09b1d4b0-9109-42da-af0a-6ec4482a1236"],
Cell[307660, 6421, 322, 6, 46, "Print",ExpressionUUID->"c2e08027-42af-48f2-a3d3-d394189857a0"],
Cell[307985, 6429, 323, 6, 46, "Print",ExpressionUUID->"3c738d05-b5d1-4596-8172-85edacf2ce8d"],
Cell[308311, 6437, 559, 14, 46, "Print",ExpressionUUID->"0c27c3d1-1d38-4db8-afe7-7eda57195041"],
Cell[308873, 6453, 434, 10, 46, "Print",ExpressionUUID->"fc267e85-e3ba-4757-b202-bda2de066d5f"],
Cell[309310, 6465, 317, 6, 46, "Print",ExpressionUUID->"80d60953-cde3-44d9-9eae-86a9c12c30fa"],
Cell[309630, 6473, 562, 14, 46, "Print",ExpressionUUID->"92360db6-92a3-472c-ac93-8a828e6185e3"]
}, Open  ]],
Cell[310207, 6490, 337, 5, 66, "Output",ExpressionUUID->"175d5a5e-1b5f-4754-ad20-455b83388c73"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[310593, 6501, 323, 5, 106, "Subsection",ExpressionUUID->"178cf152-119a-4333-b58b-905fec096e5a"],
Cell[CellGroupData[{
Cell[310941, 6510, 8978, 269, 1529, "Input",ExpressionUUID->"411096f6-7043-4c79-9b18-d6d1eebdb479"],
Cell[319922, 6781, 20921, 381, 752, "Output",ExpressionUUID->"27bb1b89-a13b-4ba3-bec4-123924d82956"],
Cell[340846, 7164, 2194, 60, 316, "Output",ExpressionUUID->"114d529f-e4e3-4fe7-a424-d4a373656583"],
Cell[343043, 7226, 314, 4, 66, "Output",ExpressionUUID->"6655607e-3800-4ead-9399-ac4850081a3f"],
Cell[CellGroupData[{
Cell[343382, 7234, 518, 10, 46, "Print",ExpressionUUID->"744b8394-cbbb-4e6c-b66a-b148f00f0d05"],
Cell[343903, 7246, 311, 5, 46, "Print",ExpressionUUID->"cc757938-4b3a-4dc2-b3a4-aaae68e30543"],
Cell[344217, 7253, 503, 10, 46, "Print",ExpressionUUID->"1f9884f5-f71f-422f-91c6-908fe8c04f21"],
Cell[344723, 7265, 528, 10, 46, "Print",ExpressionUUID->"8a47fa40-a6fd-47e1-8a80-fc94a3535876"],
Cell[345254, 7277, 508, 11, 46, "Print",ExpressionUUID->"af916ba7-4475-4607-95f7-a0bd318121f6"],
Cell[345765, 7290, 317, 5, 46, "Print",ExpressionUUID->"7025dd7e-c864-4b37-aba2-6029e2fee632"],
Cell[346085, 7297, 318, 5, 46, "Print",ExpressionUUID->"11960263-103c-4c08-adb0-e2f58e07fe96"],
Cell[346406, 7304, 554, 13, 46, "Print",ExpressionUUID->"fdb6b26d-ce9c-4c39-a36e-968f37a8eed2"],
Cell[346963, 7319, 433, 9, 46, "Print",ExpressionUUID->"42cf5950-3141-4fc6-8a7a-18839c47023a"],
Cell[347399, 7330, 316, 5, 46, "Print",ExpressionUUID->"82a939ed-8a4c-441d-af4b-15dd0239001b"],
Cell[347718, 7337, 562, 13, 46, "Print",ExpressionUUID->"dd9c843d-9c36-41a4-8f05-d2ad0d36cf03"]
}, Open  ]],
Cell[348295, 7353, 316, 4, 66, "Output",ExpressionUUID->"97a53644-c2e9-424c-92aa-5e76c60fcc96"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[348660, 7363, 280, 4, 106, "Subsection",ExpressionUUID->"eae0cae2-8037-48b4-9a67-7836b2dc3cc6"],
Cell[CellGroupData[{
Cell[348965, 7371, 10196, 300, 1652, "Input",ExpressionUUID->"656f54e7-e67e-42ce-9173-2ba018febfd4"],
Cell[359164, 7673, 33612, 590, 741, "Output",ExpressionUUID->"84169b17-495a-4952-bbe2-f7c5c766d034"],
Cell[392779, 8265, 2936, 64, 209, "Output",ExpressionUUID->"8adb053c-8cff-4fbc-ab71-f848814b1630"],
Cell[395718, 8331, 1612, 24, 66, "Output",ExpressionUUID->"047e2d9e-a278-4a8d-9dd1-641b66abacbd"],
Cell[CellGroupData[{
Cell[397355, 8359, 542, 11, 46, "Print",ExpressionUUID->"e92a40f6-09fc-4664-909a-00c768e030df"],
Cell[397900, 8372, 335, 6, 46, "Print",ExpressionUUID->"8ba5725a-0172-47ae-a82a-035d0f71ca3b"],
Cell[398238, 8380, 525, 11, 46, "Print",ExpressionUUID->"82dac6c7-3153-49f0-859d-a8927836ac0d"],
Cell[398766, 8393, 552, 11, 46, "Print",ExpressionUUID->"ff6ee03e-5ba7-46c4-9e87-6b4f9ec9753e"],
Cell[399321, 8406, 534, 12, 46, "Print",ExpressionUUID->"b33a4c62-2ce5-493a-9079-10b569dea108"],
Cell[399858, 8420, 341, 6, 46, "Print",ExpressionUUID->"497f87ca-9397-41af-996b-f5de482b6cd0"],
Cell[400202, 8428, 342, 6, 46, "Print",ExpressionUUID->"6715b4e3-038a-4fb5-b571-e576ed8184f8"],
Cell[400547, 8436, 578, 14, 46, "Print",ExpressionUUID->"2b99e203-14e7-49ce-883e-dffd5fbe0287"],
Cell[401128, 8452, 457, 10, 46, "Print",ExpressionUUID->"f4a77027-ff7b-4920-ae70-436e6c444bb2"],
Cell[401588, 8464, 340, 6, 46, "Print",ExpressionUUID->"7bbc74dd-446b-4f93-b5ed-9f76b8d08fa7"],
Cell[401931, 8472, 583, 14, 46, "Print",ExpressionUUID->"9301b838-4274-43ba-9d96-ce1d0f72283e"]
}, Open  ]],
Cell[402529, 8489, 1613, 24, 66, "Output",ExpressionUUID->"136f17df-4471-4f33-8a4a-eeeff11b00eb"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[404191, 8519, 275, 4, 106, "Subsection",ExpressionUUID->"aef04dee-b0bc-4345-b21e-40738ad32ec8"],
Cell[CellGroupData[{
Cell[404491, 8527, 10796, 329, 1723, "Input",ExpressionUUID->"d35b87ae-735c-4063-8570-3c194088cceb"],
Cell[415290, 8858, 27384, 497, 752, "Output",ExpressionUUID->"e0d54b6e-c2c4-4755-b3e6-be4fe2d89f26"],
Cell[442677, 9357, 2409, 67, 316, "Output",ExpressionUUID->"970ba75f-daba-4884-a155-791ade81b38c"],
Cell[445089, 9426, 222, 4, 66, "Output",ExpressionUUID->"b6c4a165-2daa-4e5d-9621-665492e2b2ee"],
Cell[CellGroupData[{
Cell[445336, 9434, 425, 9, 46, "Print",ExpressionUUID->"f13babb0-3c4a-46c3-84a4-d25edc72cfe4"],
Cell[445764, 9445, 213, 4, 46, "Print",ExpressionUUID->"bc4d9632-30ce-4157-bcd7-b4373231cda6"],
Cell[445980, 9451, 406, 9, 46, "Print",ExpressionUUID->"20df4040-6a5c-413a-ab84-59358a147ac3"],
Cell[446389, 9462, 433, 9, 46, "Print",ExpressionUUID->"6e82957d-10b7-43ee-a227-270310bc6c17"],
Cell[446825, 9473, 415, 10, 46, "Print",ExpressionUUID->"1f8026fb-7f01-470c-823f-ebb30270751b"],
Cell[447243, 9485, 222, 4, 46, "Print",ExpressionUUID->"fa17627e-91f1-40fe-b84c-2166a1a84c4d"],
Cell[447468, 9491, 223, 4, 46, "Print",ExpressionUUID->"93fa2bf0-66e7-49aa-b5bf-162ff194c133"],
Cell[447694, 9497, 459, 12, 46, "Print",ExpressionUUID->"c23e7805-511c-4e4d-82c2-7d6183842127"],
Cell[448156, 9511, 338, 8, 46, "Print",ExpressionUUID->"ca296857-fefc-48e9-a455-e883c315cb5b"],
Cell[448497, 9521, 223, 4, 46, "Print",ExpressionUUID->"76ea2915-947e-484a-8147-ee7fe0b86014"],
Cell[448723, 9527, 467, 12, 46, "Print",ExpressionUUID->"ffb43973-576b-4830-92f8-16fb7c797960"]
}, Open  ]],
Cell[449205, 9542, 222, 4, 66, "Output",ExpressionUUID->"b484a3fc-d51a-4e80-a9f9-7383b5d21623"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[449476, 9552, 276, 4, 106, "Subsection",ExpressionUUID->"6c5c5f03-e44d-4a8e-8683-1a1f5f171e1d"],
Cell[CellGroupData[{
Cell[449777, 9560, 11996, 360, 1976, "Input",ExpressionUUID->"4390b575-da26-4f72-befa-b85ab8b7f443"],
Cell[461776, 9922, 37363, 661, 765, "Output",ExpressionUUID->"484cecab-3087-4743-8a7d-3ad1f9beabe0"],
Cell[499142, 10585, 3199, 80, 419, "Output",ExpressionUUID->"334445b5-c1dc-491c-b767-344ec5f47441"],
Cell[502344, 10667, 531, 7, 66, "Output",ExpressionUUID->"6f69854b-0f2c-424e-87e5-12a3a92827df"],
Cell[CellGroupData[{
Cell[502900, 10678, 737, 13, 46, "Print",ExpressionUUID->"10b879af-50ba-4abe-8068-f8d579d6790c"],
Cell[503640, 10693, 530, 8, 46, "Print",ExpressionUUID->"1f086a6f-d397-4166-b3bb-d6586fa5d324"],
Cell[504173, 10703, 720, 13, 46, "Print",ExpressionUUID->"511f5c2b-309a-4892-9728-0ec62927f96d"],
Cell[504896, 10718, 749, 13, 46, "Print",ExpressionUUID->"85f56940-4d96-4fa8-9ab1-45f8abc23a96"],
Cell[505648, 10733, 727, 14, 46, "Print",ExpressionUUID->"e8c8087f-5a17-4e95-bc24-1376c64a5940"],
Cell[506378, 10749, 536, 8, 46, "Print",ExpressionUUID->"a7e22ac9-338d-45da-82d0-0cbeb0b152b1"],
Cell[506917, 10759, 539, 8, 46, "Print",ExpressionUUID->"69b9e151-c655-4da0-b538-39c9fe1fac5a"],
Cell[507459, 10769, 773, 16, 46, "Print",ExpressionUUID->"93a74f7a-8a5e-488f-bd49-c9ebce28794d"],
Cell[508235, 10787, 652, 12, 46, "Print",ExpressionUUID->"a59766f1-0721-4b68-87bd-df886d68b5fb"],
Cell[508890, 10801, 537, 8, 46, "Print",ExpressionUUID->"09b5612f-503b-401a-a1f3-7c1bcb235960"],
Cell[509430, 10811, 779, 16, 46, "Print",ExpressionUUID->"bcdee2b1-4a41-41a2-a470-16fea4587d35"]
}, Open  ]],
Cell[510224, 10830, 531, 7, 66, "Output",ExpressionUUID->"ccd4c2f1-a575-456c-876b-545d0e6b16f8"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

